/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.materialize;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.MaterializationKey;
import net.hydromatic.optiq.materialize.TileKey;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.util.Util;

class MaterializationActor {
    final Map<MaterializationKey, Materialization> keyMap = Maps.newHashMap();
    final Map<QueryKey, MaterializationKey> keyBySql = Maps.newHashMap();
    final Map<TileKey, MaterializationKey> keyByTile = Maps.newHashMap();
    final Multimap<TileKey, TileKey> tilesByDimensionality = HashMultimap.create();

    MaterializationActor() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryKey {
        final String sql;
        final OptiqSchema schema;
        final List<String> path;

        QueryKey(String sql, OptiqSchema schema, List<String> path) {
            this.sql = sql;
            this.schema = schema;
            this.path = path;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QueryKey && this.sql.equals(((QueryKey)obj).sql) && this.schema.equals(((QueryKey)obj).schema) && ((Object)this.path).equals(((QueryKey)obj).path);
        }

        public int hashCode() {
            return Util.hashV(this.sql, this.schema, this.path);
        }
    }

    static class Materialization {
        final MaterializationKey key;
        final OptiqRootSchema rootSchema;
        OptiqSchema.TableEntry materializedTable;
        final String sql;
        final RelDataType rowType;

        Materialization(MaterializationKey key, OptiqRootSchema rootSchema, OptiqSchema.TableEntry materializedTable, String sql, RelDataType rowType) {
            this.key = key;
            this.rootSchema = rootSchema;
            this.materializedTable = materializedTable;
            this.sql = sql;
            this.rowType = rowType;
        }
    }
}

