/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.materialize;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.linq4j.AbstractQueryable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.config.OptiqConnectionProperty;
import net.hydromatic.optiq.impl.clone.CloneSchema;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.MetaImpl;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.Lattice;
import net.hydromatic.optiq.materialize.MaterializationActor;
import net.hydromatic.optiq.materialize.MaterializationKey;
import net.hydromatic.optiq.materialize.TileKey;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.runtime.Hook;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeImpl;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaterializationService {
    private static final MaterializationService INSTANCE = new MaterializationService();
    private static final ThreadLocal<MaterializationService> THREAD_INSTANCE = new ThreadLocal<MaterializationService>(){

        @Override
        protected MaterializationService initialValue() {
            return new MaterializationService();
        }
    };
    private static final Comparator<Pair<OptiqSchema.TableEntry, TileKey>> C = new Comparator<Pair<OptiqSchema.TableEntry, TileKey>>(){

        @Override
        public int compare(Pair<OptiqSchema.TableEntry, TileKey> o0, Pair<OptiqSchema.TableEntry, TileKey> o1) {
            Table t0 = ((OptiqSchema.TableEntry)o0.left).getTable();
            Table t1 = ((OptiqSchema.TableEntry)o1.left).getTable();
            int c = Double.compare(t0.getStatistic().getRowCount(), t1.getStatistic().getRowCount());
            if (c != 0) {
                return c;
            }
            return ((OptiqSchema.TableEntry)o0.left).name.compareTo(((OptiqSchema.TableEntry)o1.left).name);
        }
    };
    private final MaterializationActor actor = new MaterializationActor();

    private MaterializationService() {
    }

    public MaterializationKey defineMaterialization(OptiqSchema schema, TileKey tileKey, String viewSql, List<String> viewSchemaPath, String suggestedTableName, boolean create) {
        MaterializationActor.QueryKey queryKey = new MaterializationActor.QueryKey(viewSql, schema, viewSchemaPath);
        MaterializationKey existingKey = this.actor.keyBySql.get(queryKey);
        if (existingKey != null) {
            return existingKey;
        }
        if (!create) {
            return null;
        }
        final OptiqConnection connection = MetaImpl.connect(schema.root(), null);
        Pair<String, Table> pair = schema.getTableBySql(viewSql);
        Table materializedTable = pair == null ? null : (Table)pair.right;
        RelDataType rowType = null;
        if (materializedTable == null) {
            ImmutableMap map = ImmutableMap.of((Object)((Object)OptiqConnectionProperty.CREATE_MATERIALIZATIONS), (Object)"false");
            final OptiqPrepare.PrepareResult<Object> prepareResult = Schemas.prepare(connection, schema, viewSchemaPath, viewSql, (ImmutableMap<OptiqConnectionProperty, String>)map);
            rowType = prepareResult.rowType;
            JavaTypeFactory typeFactory = connection.getTypeFactory();
            materializedTable = CloneSchema.createCloneTable(typeFactory, RelDataTypeImpl.proto(prepareResult.rowType), Functions.adapt((List)prepareResult.structType.columns, (Function1)new Function1<ColumnMetaData, ColumnMetaData.Rep>(){

                public ColumnMetaData.Rep apply(ColumnMetaData column) {
                    return column.type.representation;
                }
            }), new AbstractQueryable<Object>(){

                public Enumerator<Object> enumerator() {
                    DataContext dataContext = Schemas.createDataContext(connection);
                    return prepareResult.enumerator(dataContext);
                }

                public Type getElementType() {
                    return Object.class;
                }

                public Expression getExpression() {
                    throw new UnsupportedOperationException();
                }

                public QueryProvider getProvider() {
                    return connection;
                }

                public Iterator<Object> iterator() {
                    DataContext dataContext = Schemas.createDataContext(connection);
                    return prepareResult.iterator(dataContext);
                }
            });
        }
        String tableName = Schemas.uniqueTableName(schema, Util.first(suggestedTableName, "m"));
        OptiqSchema.TableEntry tableEntry = schema.add(tableName, materializedTable, (ImmutableList<String>)ImmutableList.of((Object)viewSql));
        Hook.CREATE_MATERIALIZATION.run(tableName);
        if (rowType == null) {
            OptiqPrepare.ParseResult parse = Schemas.parse(connection, schema, viewSchemaPath, viewSql);
            rowType = parse.rowType;
        }
        MaterializationKey key = new MaterializationKey();
        MaterializationActor.Materialization materialization = new MaterializationActor.Materialization(key, schema.root(), tableEntry, viewSql, rowType);
        this.actor.keyMap.put(materialization.key, materialization);
        this.actor.keyBySql.put(queryKey, materialization.key);
        if (tileKey != null) {
            this.actor.keyByTile.put(tileKey, materialization.key);
        }
        return key;
    }

    public OptiqSchema.TableEntry checkValid(MaterializationKey key) {
        MaterializationActor.Materialization materialization = this.actor.keyMap.get(key);
        if (materialization != null) {
            return materialization.materializedTable;
        }
        return null;
    }

    public Pair<OptiqSchema.TableEntry, TileKey> defineTile(Lattice lattice, BitSet groupSet, List<Lattice.Measure> measureList, OptiqSchema schema, boolean create, boolean exact) {
        OptiqSchema.TableEntry tableEntry;
        OptiqSchema.TableEntry tableEntry2;
        TileKey tileKey = new TileKey(lattice, groupSet, (ImmutableList<Lattice.Measure>)ImmutableList.copyOf(measureList));
        MaterializationKey materializationKey = this.actor.keyByTile.get(tileKey);
        if (materializationKey != null && (tableEntry2 = this.checkValid(materializationKey)) != null) {
            return Pair.of(tableEntry2, tileKey);
        }
        TileKey tileKey0 = new TileKey(lattice, groupSet, (ImmutableList<Lattice.Measure>)ImmutableList.of());
        for (TileKey tileKey1 : this.actor.tilesByDimensionality.get((Object)tileKey0)) {
            OptiqSchema.TableEntry tableEntry3;
            assert (tileKey1.dimensions.equals(groupSet));
            if (!this.allSatisfiable(measureList, tileKey1) || (materializationKey = this.actor.keyByTile.get(tileKey1)) == null || (tableEntry3 = this.checkValid(materializationKey)) == null) continue;
            return Pair.of(tableEntry3, tileKey1);
        }
        if (!exact) {
            PriorityQueue<Pair<OptiqSchema.TableEntry, TileKey>> queue = new PriorityQueue<Pair<OptiqSchema.TableEntry, TileKey>>(1, C);
            for (Map.Entry<TileKey, MaterializationKey> entry : this.actor.keyByTile.entrySet()) {
                TileKey tileKey2 = entry.getKey();
                if (tileKey2.lattice != lattice || !BitSets.contains(tileKey2.dimensions, groupSet) || tileKey2.dimensions.equals(groupSet) || !this.allSatisfiable(measureList, tileKey2) || (tableEntry = this.checkValid(materializationKey = entry.getValue())) == null) continue;
                queue.add(Pair.of(tableEntry, tileKey2));
            }
            if (!queue.isEmpty()) {
                Pair<OptiqSchema.TableEntry, TileKey> best = queue.peek();
                for (Pair pair : queue) {
                    System.out.println("table=" + ((OptiqSchema.TableEntry)pair.left).path() + " " + ((OptiqSchema.TableEntry)pair.left).getTable().getStatistic().getRowCount());
                }
                return best;
            }
        }
        if (!create) {
            return null;
        }
        ArrayList obsolete = Lists.newArrayList();
        LinkedHashSet measureSet = Sets.newLinkedHashSet();
        for (TileKey tileKey3 : this.actor.tilesByDimensionality.get((Object)tileKey0)) {
            measureSet.addAll(tileKey3.measures);
            obsolete.add(tileKey3);
        }
        measureSet.addAll(measureList);
        TileKey newTileKey = new TileKey(lattice, groupSet, (ImmutableList<Lattice.Measure>)ImmutableList.copyOf((Collection)measureSet));
        String string = lattice.sql(groupSet, (List<Lattice.Measure>)newTileKey.measures);
        materializationKey = this.defineMaterialization(schema, newTileKey, string, schema.path(null), "m" + groupSet, true);
        if (materializationKey != null && (tableEntry = this.checkValid(materializationKey)) != null) {
            for (TileKey tileKey1 : obsolete) {
                this.actor.tilesByDimensionality.remove((Object)tileKey0, (Object)tileKey1);
                this.actor.keyByTile.remove(tileKey1);
            }
            this.actor.tilesByDimensionality.put((Object)tileKey0, (Object)newTileKey);
            this.actor.keyByTile.put(newTileKey, materializationKey);
            return Pair.of(tableEntry, newTileKey);
        }
        return null;
    }

    private boolean allSatisfiable(List<Lattice.Measure> measureList, TileKey tileKey) {
        for (Lattice.Measure measure : measureList) {
            if (tileKey.measures.contains((Object)measure) || BitSets.contains(tileKey.dimensions, measure.argBitSet())) continue;
            return false;
        }
        return true;
    }

    public List<Prepare.Materialization> query(OptiqSchema rootSchema) {
        ArrayList<Prepare.Materialization> list = new ArrayList<Prepare.Materialization>();
        for (MaterializationActor.Materialization materialization : this.actor.keyMap.values()) {
            if (materialization.rootSchema != rootSchema || materialization.materializedTable == null) continue;
            list.add(new Prepare.Materialization(materialization.materializedTable, materialization.sql));
        }
        return list;
    }

    public void clear() {
        this.actor.keyMap.clear();
    }

    public static void setThreadLocal() {
        THREAD_INSTANCE.set(new MaterializationService());
    }

    public static MaterializationService instance() {
        MaterializationService materializationService = THREAD_INSTANCE.get();
        if (materializationService != null) {
            return materializationService;
        }
        return INSTANCE;
    }
}

