/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.FilterableTable;
import net.hydromatic.optiq.ProjectableFilterableTable;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.ScannableTable;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqCatalogReader;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.JavaRules;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlAccessType;
import org.eigenbase.sql.validate.SqlMonotonicity;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelOptTableImpl
implements Prepare.PreparingTable {
    private final RelOptSchema schema;
    private final RelDataType rowType;
    private final Table table;
    private final Function<Class, Expression> expressionFunction;
    private final ImmutableList<String> names;
    private final Double rowCount;

    private RelOptTableImpl(RelOptSchema schema, RelDataType rowType, List<String> names, Table table, Function<Class, Expression> expressionFunction, Double rowCount) {
        this.schema = schema;
        this.rowType = rowType;
        this.names = ImmutableList.copyOf(names);
        this.table = table;
        this.expressionFunction = expressionFunction;
        this.rowCount = rowCount;
        assert (expressionFunction != null);
        assert (rowType != null);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, List<String> names, Expression expression) {
        Function expressionFunction = Functions.constant((Object)expression);
        return new RelOptTableImpl(schema, rowType, names, null, (Function<Class, Expression>)expressionFunction, null);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, final OptiqSchema.TableEntry tableEntry, Double rowCount) {
        Object expressionFunction;
        final Table table = tableEntry.getTable();
        if (table instanceof QueryableTable) {
            final QueryableTable queryableTable = (QueryableTable)table;
            expressionFunction = new Function<Class, Expression>(){

                public Expression apply(Class clazz) {
                    return queryableTable.getExpression(tableEntry.schema.plus(), tableEntry.name, clazz);
                }
            };
        } else {
            expressionFunction = table instanceof ScannableTable || table instanceof FilterableTable || table instanceof ProjectableFilterableTable ? new Function<Class, Expression>(){

                public Expression apply(Class clazz) {
                    return Schemas.tableExpression(tableEntry.schema.plus(), Object[].class, tableEntry.name, table.getClass());
                }
            } : new Function<Class, Expression>(){

                public Expression apply(Class input) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new RelOptTableImpl(schema, rowType, tableEntry.path(), table, (Function<Class, Expression>)expressionFunction, rowCount);
    }

    public static RelOptTableImpl create(RelOptSchema schema, RelDataType rowType, TranslatableTable table) {
        Function<Class, Expression> expressionFunction = new Function<Class, Expression>(){

            public Expression apply(Class input) {
                throw new UnsupportedOperationException();
            }
        };
        return new RelOptTableImpl(schema, rowType, (List<String>)ImmutableList.of(), table, expressionFunction, null);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz.isInstance(this.table)) {
            return clazz.cast(this.table);
        }
        if (clazz == OptiqSchema.class) {
            return clazz.cast(Schemas.subSchema(((OptiqCatalogReader)this.schema).rootSchema, Util.skipLast(this.getQualifiedName())));
        }
        return null;
    }

    @Override
    public Expression getExpression(Class clazz) {
        return (Expression)this.expressionFunction.apply((Object)clazz);
    }

    @Override
    public double getRowCount() {
        Double rowCount;
        if (this.rowCount != null) {
            return this.rowCount;
        }
        if (this.table != null && (rowCount = this.table.getStatistic().getRowCount()) != null) {
            return rowCount;
        }
        return 100.0;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        if (this.table instanceof TranslatableTable) {
            return ((TranslatableTable)this.table).toRel(context, this);
        }
        RelOptCluster cluster = context.getCluster();
        Class elementType = this.deduceElementType();
        JavaRules.EnumerableTableAccessRel scan = new JavaRules.EnumerableTableAccessRel(cluster, cluster.traitSetOf(EnumerableConvention.INSTANCE), this, elementType);
        if (this.table instanceof FilterableTable || this.table instanceof ProjectableFilterableTable) {
            return new JavaRules.EnumerableInterpreterRel(cluster, scan.getTraitSet(), scan, 1.0);
        }
        return scan;
    }

    private Class deduceElementType() {
        if (this.table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)this.table;
            Type type = queryableTable.getElementType();
            if (type instanceof Class) {
                return (Class)type;
            }
            return Object[].class;
        }
        if (this.table instanceof ScannableTable || this.table instanceof FilterableTable || this.table instanceof ProjectableFilterableTable) {
            return Object[].class;
        }
        return Object.class;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return Collections.emptyList();
    }

    @Override
    public boolean isKey(BitSet columns) {
        return this.table.getStatistic().isKey(columns);
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public List<String> getQualifiedName() {
        return this.names;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public SqlAccessType getAllowedAccess() {
        return SqlAccessType.ALL;
    }
}

