/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.expressions.BinaryExpression;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MemberExpression;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.OptimizeVisitor;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.ImplementableAggFunction;
import net.hydromatic.optiq.ImplementableFunction;
import net.hydromatic.optiq.impl.AggregateFunctionImpl;
import net.hydromatic.optiq.rules.java.AggAddContext;
import net.hydromatic.optiq.rules.java.AggContext;
import net.hydromatic.optiq.rules.java.AggImplementor;
import net.hydromatic.optiq.rules.java.AggResetContext;
import net.hydromatic.optiq.rules.java.AggResultContext;
import net.hydromatic.optiq.rules.java.CallImplementor;
import net.hydromatic.optiq.rules.java.NotNullImplementor;
import net.hydromatic.optiq.rules.java.NullPolicy;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.rules.java.StrictAggImplementor;
import net.hydromatic.optiq.rules.java.StrictWinAggImplementor;
import net.hydromatic.optiq.rules.java.WinAggAddContext;
import net.hydromatic.optiq.rules.java.WinAggContext;
import net.hydromatic.optiq.rules.java.WinAggImplementor;
import net.hydromatic.optiq.rules.java.WinAggResultContext;
import net.hydromatic.optiq.runtime.SqlFunctions;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.fun.SqlTrimFunction;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.sql.validate.SqlUserDefinedAggFunction;
import org.eigenbase.sql.validate.SqlUserDefinedFunction;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexImpTable {
    public static final ConstantExpression NULL_EXPR = Expressions.constant(null);
    public static final ConstantExpression FALSE_EXPR = Expressions.constant((Object)false);
    public static final ConstantExpression TRUE_EXPR = Expressions.constant((Object)true);
    public static final MemberExpression BOXED_FALSE_EXPR = Expressions.field(null, Boolean.class, (String)"FALSE");
    public static final MemberExpression BOXED_TRUE_EXPR = Expressions.field(null, Boolean.class, (String)"TRUE");
    private final Map<SqlOperator, CallImplementor> map = new HashMap<SqlOperator, CallImplementor>();
    private final Map<Aggregation, Supplier<? extends AggImplementor>> aggMap = new HashMap<Aggregation, Supplier<? extends AggImplementor>>();
    private final Map<Aggregation, Supplier<? extends WinAggImplementor>> winAggMap = new HashMap<Aggregation, Supplier<? extends WinAggImplementor>>();
    public static final RexImpTable INSTANCE = new RexImpTable();

    RexImpTable() {
        this.defineMethod((SqlOperator)SqlStdOperatorTable.UPPER, BuiltinMethod.UPPER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOWER, BuiltinMethod.LOWER.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.INITCAP, BuiltinMethod.INITCAP.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SUBSTRING, BuiltinMethod.SUBSTRING.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, BuiltinMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, BuiltinMethod.CHAR_LENGTH.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CONCAT, BuiltinMethod.STRING_CONCAT.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.OVERLAY, BuiltinMethod.OVERLAY.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POSITION, BuiltinMethod.POSITION.method, NullPolicy.STRICT);
        TrimImplementor trimImplementor = new TrimImplementor();
        this.defineImplementor(SqlStdOperatorTable.TRIM, NullPolicy.STRICT, trimImplementor, false);
        this.defineBinary(SqlStdOperatorTable.AND, ExpressionType.AndAlso, NullPolicy.AND, null);
        this.defineBinary(SqlStdOperatorTable.OR, ExpressionType.OrElse, NullPolicy.OR, null);
        this.defineUnary(SqlStdOperatorTable.NOT, ExpressionType.Not, NullPolicy.NOT);
        this.defineBinary(SqlStdOperatorTable.LESS_THAN, ExpressionType.LessThan, NullPolicy.STRICT, "lt");
        this.defineBinary(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, ExpressionType.LessThanOrEqual, NullPolicy.STRICT, "le");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN, ExpressionType.GreaterThan, NullPolicy.STRICT, "gt");
        this.defineBinary(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ExpressionType.GreaterThanOrEqual, NullPolicy.STRICT, "ge");
        this.defineBinary(SqlStdOperatorTable.EQUALS, ExpressionType.Equal, NullPolicy.STRICT, "eq");
        this.defineBinary(SqlStdOperatorTable.NOT_EQUALS, ExpressionType.NotEqual, NullPolicy.STRICT, "ne");
        this.defineBinary(SqlStdOperatorTable.PLUS, ExpressionType.Add, NullPolicy.STRICT, "plus");
        this.defineBinary(SqlStdOperatorTable.MINUS, ExpressionType.Subtract, NullPolicy.STRICT, "minus");
        this.defineBinary(SqlStdOperatorTable.MULTIPLY, ExpressionType.Multiply, NullPolicy.STRICT, "multiply");
        this.defineBinary(SqlStdOperatorTable.DIVIDE, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineBinary(SqlStdOperatorTable.DIVIDE_INTEGER, ExpressionType.Divide, NullPolicy.STRICT, "divide");
        this.defineUnary(SqlStdOperatorTable.UNARY_MINUS, ExpressionType.Negate, NullPolicy.STRICT);
        this.defineUnary(SqlStdOperatorTable.UNARY_PLUS, ExpressionType.UnaryPlus, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.MOD, "mod", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXP, "exp", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.POWER, "power", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LN, "ln", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.LOG10, "log10", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ABS, "abs", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CEIL, "ceil", NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.FLOOR, "floor", NullPolicy.STRICT);
        this.defineImplementor(SqlStdOperatorTable.DATETIME_PLUS, NullPolicy.STRICT, new DatetimeArithmeticImplementor(), false);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, BuiltinMethod.UNIX_DATE_EXTRACT.method, NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.IS_NULL, new IsXxxImplementor(null, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_NULL, new IsXxxImplementor(null, true));
        this.map.put(SqlStdOperatorTable.IS_TRUE, new IsXxxImplementor(true, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_TRUE, new IsXxxImplementor(true, true));
        this.map.put(SqlStdOperatorTable.IS_FALSE, new IsXxxImplementor(false, false));
        this.map.put(SqlStdOperatorTable.IS_NOT_FALSE, new IsXxxImplementor(false, true));
        MethodImplementor likeImplementor = new MethodImplementor(BuiltinMethod.LIKE.method);
        this.defineImplementor(SqlStdOperatorTable.LIKE, NullPolicy.STRICT, likeImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_LIKE, NullPolicy.STRICT, NotImplementor.of(likeImplementor), false);
        MethodImplementor similarImplementor = new MethodImplementor(BuiltinMethod.SIMILAR.method);
        this.defineImplementor(SqlStdOperatorTable.SIMILAR_TO, NullPolicy.STRICT, similarImplementor, false);
        this.defineImplementor(SqlStdOperatorTable.NOT_SIMILAR_TO, NullPolicy.STRICT, NotImplementor.of(similarImplementor), false);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.CARDINALITY, BuiltinMethod.COLLECTION_SIZE.method, NullPolicy.STRICT);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.SLICE, BuiltinMethod.SLICE.method, NullPolicy.NONE);
        this.defineMethod((SqlOperator)SqlStdOperatorTable.ELEMENT, BuiltinMethod.ELEMENT.method, NullPolicy.STRICT);
        this.map.put(SqlStdOperatorTable.CASE, new CaseImplementor());
        this.map.put(SqlStdOperatorTable.CAST, new CastOptimizedImplementor());
        this.defineImplementor(SqlStdOperatorTable.REINTERPRET, NullPolicy.STRICT, new ReinterpretImplementor(), false);
        ValueConstructorImplementor value = new ValueConstructorImplementor();
        this.map.put(SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value);
        this.map.put(SqlStdOperatorTable.ITEM, new ItemImplementor());
        SystemFunctionImplementor systemFunctionImplementor = new SystemFunctionImplementor();
        this.map.put(SqlStdOperatorTable.USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SESSION_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.SYSTEM_USER, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_PATH, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_ROLE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_TIMESTAMP, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.CURRENT_DATE, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIME, systemFunctionImplementor);
        this.map.put(SqlStdOperatorTable.LOCALTIMESTAMP, systemFunctionImplementor);
        this.aggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM0, this.constructorSupplier(SumImplementor.class));
        this.aggMap.put(SqlStdOperatorTable.SUM, this.constructorSupplier(SumImplementor.class));
        Supplier<MinMaxImplementor> minMax = this.constructorSupplier(MinMaxImplementor.class);
        this.aggMap.put(SqlStdOperatorTable.MIN, minMax);
        this.aggMap.put(SqlStdOperatorTable.MAX, minMax);
        this.aggMap.put(SqlStdOperatorTable.SINGLE_VALUE, this.constructorSupplier(SingleValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.RANK, this.constructorSupplier(RankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.DENSE_RANK, this.constructorSupplier(DenseRankImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.ROW_NUMBER, this.constructorSupplier(RowNumberImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.FIRST_VALUE, this.constructorSupplier(FirstValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAST_VALUE, this.constructorSupplier(LastValueImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LEAD, this.constructorSupplier(LeadImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.LAG, this.constructorSupplier(LagImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.NTILE, this.constructorSupplier(NtileImplementor.class));
        this.winAggMap.put(SqlStdOperatorTable.COUNT, this.constructorSupplier(CountWinImplementor.class));
    }

    private <T> Supplier<T> constructorSupplier(Class<T> klass) {
        Constructor<T> constructor;
        try {
            constructor = klass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(klass + " should implement zero arguments constructor");
        }
        return new Supplier<T>(){

            public T get() {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException("Unable to instantiate aggregate implementor " + constructor, e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Error while creating aggregate implementor " + constructor, e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Error while creating aggregate implementor " + constructor, e);
                }
            }
        };
    }

    private void defineImplementor(SqlOperator operator, NullPolicy nullPolicy, NotNullImplementor implementor, boolean harmonize) {
        CallImplementor callImplementor = RexImpTable.createImplementor(implementor, nullPolicy, harmonize);
        this.map.put(operator, callImplementor);
    }

    private static RexCall call2(boolean harmonize, RexToLixTranslator translator, RexCall call) {
        if (!harmonize) {
            return call;
        }
        List<RexNode> operands2 = RexImpTable.harmonize(translator, call.getOperands());
        if (((Object)operands2).equals(call.getOperands())) {
            return call;
        }
        return call.clone(call.getType(), operands2);
    }

    public static CallImplementor createImplementor(final NotNullImplementor implementor, final NullPolicy nullPolicy, final boolean harmonize) {
        switch (nullPolicy) {
            case ANY: 
            case STRICT: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        return RexImpTable.implementNullSemantics0(translator, call, nullAs, nullPolicy, harmonize, implementor);
                    }
                };
            }
            case AND: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        RexCall call2 = RexImpTable.call2(false, translator, call);
                        final NullAs nullAs2 = nullAs == NullAs.TRUE ? NullAs.NULL : nullAs;
                        List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs2);
                        switch (nullAs) {
                            case NOT_POSSIBLE: 
                            case TRUE: {
                                return Expressions.foldAnd(expressions);
                            }
                        }
                        return Expressions.foldAnd((List)Lists.transform(expressions, (com.google.common.base.Function)new com.google.common.base.Function<Expression, Expression>(){

                            public Expression apply(Expression e) {
                                return nullAs2.handle(e);
                            }
                        }));
                    }
                };
            }
            case OR: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        RexCall call2 = RexImpTable.call2(harmonize, translator, call);
                        NullAs nullAs2 = nullAs == NullAs.TRUE ? NullAs.NULL : nullAs;
                        List<Expression> expressions = translator.translateList(call2.getOperands(), nullAs2);
                        switch (nullAs) {
                            case NOT_POSSIBLE: 
                            case FALSE: {
                                return Expressions.foldOr(expressions);
                            }
                        }
                        Expression t0 = expressions.get(0);
                        Expression t1 = expressions.get(1);
                        if (!RexImpTable.nullable(call2, 0) && !RexImpTable.nullable(call2, 1)) {
                            return Expressions.orElse((Expression)t0, (Expression)t1);
                        }
                        return RexImpTable.optimize(Expressions.condition((Expression)Expressions.equal((Expression)t0, (Expression)NULL_EXPR), (Expression)Expressions.condition((Expression)Expressions.orElse((Expression)Expressions.equal((Expression)t1, (Expression)NULL_EXPR), (Expression)Expressions.not((Expression)t1)), (Expression)NULL_EXPR, (Expression)BOXED_TRUE_EXPR), (Expression)Expressions.condition((Expression)Expressions.not((Expression)t0), (Expression)t1, (Expression)BOXED_TRUE_EXPR)));
                    }
                };
            }
            case NOT: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        switch (nullAs) {
                            case NULL: {
                                return Expressions.call((Method)BuiltinMethod.NOT.method, translator.translateList(call.getOperands(), nullAs));
                            }
                        }
                        return Expressions.not((Expression)translator.translate(call.getOperands().get(0), this.negate(nullAs)));
                    }

                    private NullAs negate(NullAs nullAs) {
                        switch (nullAs) {
                            case FALSE: {
                                return NullAs.TRUE;
                            }
                            case TRUE: {
                                return NullAs.FALSE;
                            }
                        }
                        return nullAs;
                    }
                };
            }
            case NONE: {
                return new CallImplementor(){

                    public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
                        RexCall call2 = RexImpTable.call2(false, translator, call);
                        return RexImpTable.implementCall(translator, call2, implementor, nullAs);
                    }
                };
            }
        }
        throw new AssertionError((Object)nullPolicy);
    }

    private void defineMethod(SqlOperator operator, String functionName, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodNameImplementor(functionName), false);
    }

    private void defineMethod(SqlOperator operator, Method method, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new MethodImplementor(method), false);
    }

    private void defineUnary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy) {
        this.defineImplementor(operator, nullPolicy, new UnaryImplementor(expressionType), false);
    }

    private void defineBinary(SqlOperator operator, ExpressionType expressionType, NullPolicy nullPolicy, String backupMethodName) {
        this.defineImplementor(operator, nullPolicy, new BinaryImplementor(expressionType, backupMethodName), true);
    }

    public CallImplementor get(SqlOperator operator) {
        if (operator instanceof SqlUserDefinedFunction) {
            Function udf = ((SqlUserDefinedFunction)operator).getFunction();
            if (!(udf instanceof ImplementableFunction)) {
                throw new IllegalStateException("User defined function " + operator + " must implement " + "ImplementableFunction");
            }
            return ((ImplementableFunction)udf).getImplementor();
        }
        return this.map.get(operator);
    }

    public AggImplementor get(Aggregation aggregation, boolean forWindowAggregate) {
        Supplier<? extends WinAggImplementor> winAgg;
        if (aggregation instanceof SqlUserDefinedAggFunction) {
            SqlUserDefinedAggFunction udaf = (SqlUserDefinedAggFunction)aggregation;
            if (!(udaf.function instanceof ImplementableAggFunction)) {
                throw new IllegalStateException("User defined aggregation " + aggregation + " must implement " + "ImplementableAggFunction");
            }
            return ((ImplementableAggFunction)udaf.function).getImplementor(forWindowAggregate);
        }
        if (forWindowAggregate && (winAgg = this.winAggMap.get(aggregation)) != null) {
            return (AggImplementor)winAgg.get();
        }
        Supplier<? extends AggImplementor> aggSupplier = this.aggMap.get(aggregation);
        if (aggSupplier == null) {
            return null;
        }
        return (AggImplementor)aggSupplier.get();
    }

    static Expression maybeNegate(boolean negate, Expression expression) {
        if (!negate) {
            return expression;
        }
        return Expressions.not((Expression)expression);
    }

    static Expression optimize(Expression expression) {
        return expression.accept((Visitor)new OptimizeVisitor());
    }

    static Expression optimize2(Expression operand, Expression expression) {
        if (Primitive.is((Type)operand.getType())) {
            return RexImpTable.optimize(expression);
        }
        return RexImpTable.optimize(Expressions.condition((Expression)Expressions.equal((Expression)operand, (Expression)NULL_EXPR), (Expression)NULL_EXPR, (Expression)expression));
    }

    private static boolean nullable(RexCall call, int i) {
        return call.getOperands().get(i).getType().isNullable();
    }

    private static List<RexNode> harmonize(RexToLixTranslator translator, List<RexNode> operands) {
        int nullCount = 0;
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        RelDataTypeFactory typeFactory = translator.builder.getTypeFactory();
        for (RexNode operand : operands) {
            RelDataType type = operand.getType();
            type = RexImpTable.toSql(typeFactory, type);
            if (translator.isNullable(operand)) {
                ++nullCount;
            } else {
                type = typeFactory.createTypeWithNullability(type, false);
            }
            types.add(type);
        }
        if (RexImpTable.allSame(types)) {
            return operands;
        }
        RelDataType type = typeFactory.leastRestrictive(types);
        if (type == null) {
            return operands;
        }
        assert (nullCount > 0 == type.isNullable());
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (RexNode operand : operands) {
            list.add(translator.builder.ensureType(type, operand, false));
        }
        return list;
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        SqlTypeName typeName;
        if (type instanceof RelDataTypeFactoryImpl.JavaType && (typeName = type.getSqlTypeName()) != null && typeName != SqlTypeName.OTHER) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(typeName), type.isNullable());
        }
        return type;
    }

    private static <E> boolean allSame(List<E> list) {
        Object prev = null;
        for (E e : list) {
            if (prev != null && !prev.equals(e)) {
                return false;
            }
            prev = e;
        }
        return true;
    }

    private static Expression implementNullSemantics0(RexToLixTranslator translator, RexCall call, NullAs nullAs, NullPolicy nullPolicy, boolean harmonize, NotNullImplementor implementor) {
        switch (nullAs) {
            case IS_NOT_NULL: {
                if (nullPolicy != NullPolicy.STRICT) break;
                return Expressions.foldAnd(translator.translateList(call.getOperands(), nullAs));
            }
            case IS_NULL: {
                if (nullPolicy != NullPolicy.STRICT) break;
                return Expressions.foldOr(translator.translateList(call.getOperands(), nullAs));
            }
        }
        RexCall call2 = RexImpTable.call2(harmonize, translator, call);
        try {
            return RexImpTable.implementNullSemantics(translator, call2, nullAs, nullPolicy, implementor);
        }
        catch (RexToLixTranslator.AlwaysNull e) {
            switch (nullAs) {
                case NOT_POSSIBLE: {
                    throw e;
                }
                case FALSE: {
                    return FALSE_EXPR;
                }
                case TRUE: {
                    return TRUE_EXPR;
                }
            }
            return NULL_EXPR;
        }
    }

    private static Expression implementNullSemantics(RexToLixTranslator translator, RexCall call, NullAs nullAs, NullPolicy nullPolicy, NotNullImplementor implementor) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        switch (nullAs) {
            case NULL: {
                for (Ord operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                Expression box = Expressions.box((Expression)RexImpTable.implementCall(translator, call, implementor, nullAs));
                return RexImpTable.optimize(Expressions.condition((Expression)Expressions.foldOr(list), (Expression)Types.castIfNecessary((Type)box.getType(), (Expression)NULL_EXPR), (Expression)box));
            }
            case FALSE: {
                for (Ord operand : Ord.zip(call.getOperands())) {
                    if (!translator.isNullable((RexNode)operand.e)) continue;
                    list.add(translator.translate((RexNode)operand.e, NullAs.IS_NOT_NULL));
                    translator = translator.setNullable((RexNode)operand.e, false);
                }
                list.add(RexImpTable.implementCall(translator, call, implementor, nullAs));
                return Expressions.foldAnd(list);
            }
            case NOT_POSSIBLE: {
                HashMap<RexNode, Boolean> nullable = new HashMap<RexNode, Boolean>();
                if (nullPolicy == NullPolicy.STRICT) {
                    for (RexNode arg : call.getOperands()) {
                        if (!translator.isNullable(arg) || nullable.containsKey(arg)) continue;
                        nullable.put(arg, false);
                    }
                }
                nullable.put(call, false);
                translator = translator.setNullable(nullable);
            }
        }
        return RexImpTable.implementCall(translator, call, implementor, nullAs);
    }

    private static Expression implementCall(RexToLixTranslator translator, RexCall call, NotNullImplementor implementor, NullAs nullAs) {
        List<Expression> translatedOperands = translator.translateList(call.getOperands());
        switch (nullAs) {
            case NOT_POSSIBLE: 
            case NULL: {
                for (Expression translatedOperand : translatedOperands) {
                    if (!Expressions.isConstantNull((Expression)translatedOperand)) continue;
                    return NULL_EXPR;
                }
                break;
            }
        }
        Expression result = implementor.implement(translator, call, translatedOperands);
        return nullAs.handle(result);
    }

    static Expression getDefaultValue(Type type) {
        if (Primitive.is((Type)type)) {
            Primitive p = Primitive.of((Type)type);
            return Expressions.constant((Object)p.defaultValue, (Type)type);
        }
        return Expressions.constant(null, (Type)type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatetimeArithmeticImplementor
    implements NotNullImplementor {
        private DatetimeArithmeticImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            RexNode operand0 = call.getOperands().get(0);
            Expression trop0 = translatedOperands.get(0);
            Expression trop1 = translatedOperands.get(1);
            switch (operand0.getType().getSqlTypeName()) {
                case DATE: {
                    trop1 = Expressions.convert_((Expression)Expressions.divide((Expression)trop1, (Expression)Expressions.constant((Object)86400000L)), Integer.TYPE);
                    break;
                }
                case TIME: {
                    trop1 = Expressions.convert_((Expression)trop1, Integer.TYPE);
                }
            }
            return Expressions.add((Expression)trop0, (Expression)trop1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NotImplementor
    implements NotNullImplementor {
        private final NotNullImplementor implementor;

        public NotImplementor(NotNullImplementor implementor) {
            this.implementor = implementor;
        }

        private static NotNullImplementor of(NotNullImplementor implementor) {
            return new NotImplementor(implementor);
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression expression = this.implementor.implement(translator, call, translatedOperands);
            return Expressions.not((Expression)expression);
        }
    }

    private static class IsXxxImplementor
    implements CallImplementor {
        private final Boolean seek;
        private final boolean negate;

        public IsXxxImplementor(Boolean seek, boolean negate) {
            this.seek = seek;
            this.negate = negate;
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            List<RexNode> operands = call.getOperands();
            assert (operands.size() == 1);
            if (this.seek == null) {
                return translator.translate(operands.get(0), this.negate ? NullAs.IS_NOT_NULL : NullAs.IS_NULL);
            }
            return RexImpTable.maybeNegate(this.negate == this.seek, translator.translate(operands.get(0), this.seek != false ? NullAs.FALSE : NullAs.TRUE));
        }
    }

    private static class SystemFunctionImplementor
    implements CallImplementor {
        private SystemFunctionImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            switch (nullAs) {
                case IS_NULL: {
                    return Expressions.constant((Object)false);
                }
                case IS_NOT_NULL: {
                    return Expressions.constant((Object)true);
                }
            }
            SqlOperator op = call.getOperator();
            if (op == SqlStdOperatorTable.CURRENT_USER || op == SqlStdOperatorTable.SESSION_USER || op == SqlStdOperatorTable.USER) {
                return Expressions.constant((Object)"sa");
            }
            if (op == SqlStdOperatorTable.SYSTEM_USER) {
                return Expressions.constant((Object)System.getProperty("user.name"));
            }
            if (op == SqlStdOperatorTable.CURRENT_PATH || op == SqlStdOperatorTable.CURRENT_ROLE) {
                return Expressions.constant((Object)"");
            }
            if (op == SqlStdOperatorTable.CURRENT_TIMESTAMP) {
                return Expressions.call((Method)BuiltinMethod.CURRENT_TIMESTAMP.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.CURRENT_TIME) {
                return Expressions.call((Method)BuiltinMethod.CURRENT_TIME.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.CURRENT_DATE) {
                return Expressions.call((Method)BuiltinMethod.CURRENT_DATE.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.LOCALTIMESTAMP) {
                return Expressions.call((Method)BuiltinMethod.LOCAL_TIMESTAMP.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            if (op == SqlStdOperatorTable.LOCALTIME) {
                return Expressions.call((Method)BuiltinMethod.LOCAL_TIME.method, (Expression[])new Expression[]{DataContext.ROOT});
            }
            throw new AssertionError((Object)("unknown function " + op));
        }
    }

    private static class ItemImplementor
    implements CallImplementor {
        private ItemImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            MethodImplementor implementor = this.getImplementor(call.getOperands().get(0).getType().getSqlTypeName());
            return RexImpTable.implementNullSemantics0(translator, call, nullAs, NullPolicy.STRICT, false, implementor);
        }

        private MethodImplementor getImplementor(SqlTypeName sqlTypeName) {
            switch (sqlTypeName) {
                case ARRAY: {
                    return new MethodImplementor(BuiltinMethod.ARRAY_ITEM.method);
                }
                case MAP: {
                    return new MethodImplementor(BuiltinMethod.MAP_ITEM.method);
                }
            }
            return new MethodImplementor(BuiltinMethod.ANY_ITEM.method);
        }
    }

    private static class ValueConstructorImplementor
    implements CallImplementor {
        private ValueConstructorImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return translator.translateConstructor(call.getOperands(), call.getOperator().getKind());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReinterpretImplementor
    implements NotNullImplementor {
        private ReinterpretImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            return translatedOperands.get(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastImplementor
    implements NotNullImplementor {
        private CastImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            assert (call.getOperands().size() == 1);
            RelDataType sourceType = call.getOperands().get(0).getType();
            boolean nullable = translator.isNullable(call) && sourceType.isNullable() && !Primitive.is((Type)translatedOperands.get(0).getType());
            RelDataType targetType = translator.nullifyType(call.getType(), nullable);
            return translator.translateCast(sourceType, targetType, translatedOperands.get(0));
        }
    }

    private static class CastOptimizedImplementor
    implements CallImplementor {
        private final CallImplementor accurate = RexImpTable.createImplementor(new CastImplementor(), NullPolicy.STRICT, false);

        private CastOptimizedImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            RexNode arg = call.getOperands().get(0);
            if (call.getType().equals(arg.getType())) {
                return translator.translate(arg, nullAs);
            }
            if (SqlTypeUtil.equalSansNullability(translator.typeFactory, call.getType(), arg.getType()) && nullAs == NullAs.NULL && translator.deref(arg) instanceof RexLiteral) {
                return RexToLixTranslator.translateLiteral((RexLiteral)translator.deref(arg), call.getType(), translator.typeFactory, nullAs);
            }
            return this.accurate.implement(translator, call, nullAs);
        }
    }

    private static class CaseImplementor
    implements CallImplementor {
        private CaseImplementor() {
        }

        public Expression implement(RexToLixTranslator translator, RexCall call, NullAs nullAs) {
            return this.implementRecurse(translator, call, nullAs, 0);
        }

        private Expression implementRecurse(RexToLixTranslator translator, RexCall call, NullAs nullAs, int i) {
            Expression ifFalse;
            Expression ifTrue;
            List<RexNode> operands = call.getOperands();
            if (i == operands.size() - 1) {
                return translator.translate(translator.builder.ensureType(call.getType(), operands.get(i), false), nullAs);
            }
            try {
                ifTrue = translator.translate(translator.builder.ensureType(call.getType(), operands.get(i + 1), false), nullAs);
            }
            catch (RexToLixTranslator.AlwaysNull e) {
                ifTrue = null;
            }
            try {
                ifFalse = this.implementRecurse(translator, call, nullAs, i + 2);
            }
            catch (RexToLixTranslator.AlwaysNull e) {
                if (ifTrue == null) {
                    throw RexToLixTranslator.AlwaysNull.INSTANCE;
                }
                ifFalse = null;
            }
            Expression test = translator.translate(operands.get(i), NullAs.FALSE);
            return ifTrue == null || ifFalse == null ? Util.first(ifTrue, ifFalse) : Expressions.condition((Expression)test, (Expression)ifTrue, (Expression)ifFalse);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnaryImplementor
    implements NotNullImplementor {
        private final ExpressionType expressionType;

        UnaryImplementor(ExpressionType expressionType) {
            this.expressionType = expressionType;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.makeUnary((ExpressionType)this.expressionType, (Expression)translatedOperands.get(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryImplementor
    implements NotNullImplementor {
        private static final List<Primitive> COMP_OP_TYPES = ImmutableList.of((Object)Primitive.BYTE, (Object)Primitive.CHAR, (Object)Primitive.SHORT, (Object)Primitive.INT, (Object)Primitive.LONG, (Object)Primitive.FLOAT, (Object)Primitive.DOUBLE);
        private static final List<SqlBinaryOperator> COMPARISON_OPERATORS = ImmutableList.of((Object)SqlStdOperatorTable.LESS_THAN, (Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Object)SqlStdOperatorTable.GREATER_THAN, (Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        private final ExpressionType expressionType;
        private final String backupMethodName;

        BinaryImplementor(ExpressionType expressionType, String backupMethodName) {
            this.expressionType = expressionType;
            this.backupMethodName = backupMethodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> expressions) {
            if (this.backupMethodName != null) {
                Primitive primitive = Primitive.ofBoxOr((Type)expressions.get(0).getType());
                SqlBinaryOperator op = (SqlBinaryOperator)call.getOperator();
                if (primitive == null || COMPARISON_OPERATORS.contains(op) && !COMP_OP_TYPES.contains(primitive)) {
                    return Expressions.call(SqlFunctions.class, (String)this.backupMethodName, expressions);
                }
            }
            return Expressions.makeBinary((ExpressionType)this.expressionType, (Expression)expressions.get(0), (Expression)expressions.get(1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodNameImplementor
    implements NotNullImplementor {
        private final String methodName;

        MethodNameImplementor(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            return Expressions.call(SqlFunctions.class, (String)this.methodName, translatedOperands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodImplementor
    implements NotNullImplementor {
        private final Method method;

        MethodImplementor(Method method) {
            this.method = method;
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            if (Modifier.isStatic(this.method.getModifiers())) {
                return Expressions.call((Method)this.method, translatedOperands);
            }
            return Expressions.call((Expression)translatedOperands.get(0), (Method)this.method, Util.skip(translatedOperands, 1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrimImplementor
    implements NotNullImplementor {
        private TrimImplementor() {
        }

        @Override
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Object value = ((ConstantExpression)translatedOperands.get((int)0)).value;
            SqlTrimFunction.Flag flag = (SqlTrimFunction.Flag)value;
            return Expressions.call((Method)BuiltinMethod.TRIM.method, (Expression[])new Expression[]{Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.LEADING ? 1 : 0)), Expressions.constant((Object)(flag == SqlTrimFunction.Flag.BOTH || flag == SqlTrimFunction.Flag.TRAILING ? 1 : 0)), translatedOperands.get(1), translatedOperands.get(2)});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RowNumberImplementor
    extends StrictWinAggImplementor {
        RowNumberImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            return Collections.emptyList();
        }

        @Override
        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add((Expression)Expressions.subtract((Expression)result.index(), (Expression)result.startIndex()), (Expression)Expressions.constant((Object)1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NtileImplementor
    implements WinAggImplementor {
        NtileImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            Expression tiles = winResult.rowTranslator(winResult.index()).translate(rexArgs.get(0), Integer.TYPE);
            BinaryExpression ntile = Expressions.add((Expression)Expressions.constant((Object)1), (Expression)Expressions.divide((Expression)Expressions.multiply((Expression)tiles, (Expression)Expressions.subtract((Expression)winResult.index(), (Expression)winResult.startIndex())), (Expression)winResult.getPartitionRowCount()));
            return ntile;
        }
    }

    public static class LagImplementor
    extends LeadLagImplementor {
        protected LagImplementor() {
            super(false);
        }
    }

    public static class LeadImplementor
    extends LeadLagImplementor {
        protected LeadImplementor() {
            super(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LeadLagImplementor
    implements WinAggImplementor {
        private final boolean isLead;

        protected LeadLagImplementor(boolean isLead) {
            this.isLead = isLead;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return false;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            List<RexNode> rexArgs = winResult.rexArguments();
            ParameterExpression res = Expressions.parameter((int)0, (Type)info.returnType(), (String)result.currentBlock().newName(this.isLead ? "lead" : "lag"));
            RexToLixTranslator currentRowTranslator = winResult.rowTranslator(winResult.computeIndex((Expression)Expressions.constant((Object)0), WinAggImplementor.SeekType.SET));
            Object offset = rexArgs.size() >= 2 ? currentRowTranslator.translate(rexArgs.get(1), Integer.TYPE) : Expressions.constant((Object)1);
            if (!this.isLead) {
                offset = Expressions.negate((Expression)offset);
            }
            Expression dstIndex = winResult.computeIndex((Expression)offset, WinAggImplementor.SeekType.SET);
            Expression rowInRange = winResult.rowInPartition(dstIndex);
            BlockBuilder thenBlock = result.nestBlock();
            Expression lagResult = winResult.rowTranslator(dstIndex).translate(rexArgs.get(0), res.type);
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)lagResult)));
            result.exitBlock();
            BlockStatement thenBranch = thenBlock.toBlock();
            Expression defaultValue = rexArgs.size() == 3 ? currentRowTranslator.translate(rexArgs.get(2), res.type) : RexImpTable.getDefaultValue(res.type);
            result.currentBlock().add((Statement)Expressions.declare((int)0, (ParameterExpression)res, null));
            result.currentBlock().add((Statement)Expressions.ifThenElse((Expression)rowInRange, (Node)thenBranch, (Node)Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)defaultValue))));
            return res;
        }
    }

    static class LastValueImplementor
    extends FirstLastValueImplementor {
        protected LastValueImplementor() {
            super(WinAggImplementor.SeekType.END);
        }
    }

    static class FirstValueImplementor
    extends FirstLastValueImplementor {
        protected FirstValueImplementor() {
            super(WinAggImplementor.SeekType.START);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FirstLastValueImplementor
    implements WinAggImplementor {
        private final WinAggImplementor.SeekType seekType;

        protected FirstLastValueImplementor(WinAggImplementor.SeekType seekType) {
            this.seekType = seekType;
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Collections.emptyList();
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
        }

        @Override
        public boolean needCacheWhenFrameIntact() {
            return true;
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            WinAggResultContext winResult = (WinAggResultContext)result;
            return Expressions.condition((Expression)winResult.hasRows(), (Expression)winResult.rowTranslator(winResult.computeIndex((Expression)Expressions.constant((Object)0), this.seekType)).translate(winResult.rexArguments().get(0), info.returnType()), (Expression)RexImpTable.getDefaultValue(info.returnType()));
        }
    }

    static class DenseRankImplementor
    extends RankImplementor {
        DenseRankImplementor() {
        }

        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            return Expressions.add((Expression)acc, (Expression)Expressions.constant((Object)1));
        }
    }

    static class RankImplementor
    extends StrictWinAggImplementor {
        RankImplementor() {
        }

        protected void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            Expression acc = add.accumulator().get(0);
            BlockBuilder builder = add.nestBlock();
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)Expressions.lessThan((Expression)add.compareRows((Expression)Expressions.subtract((Expression)add.currentPosition(), (Expression)Expressions.constant((Object)1)), add.currentPosition()), (Expression)Expressions.constant((Object)0)), (Node)Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)this.computeNewRank(acc, add)))));
            add.exitBlock();
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)Expressions.greaterThan((Expression)add.currentPosition(), (Expression)add.startIndex()), (Node)builder.toBlock()));
        }

        protected Expression computeNewRank(Expression acc, WinAggAddContext add) {
            Expression pos = add.currentPosition();
            if (!add.startIndex().equals((Object)Expressions.constant((Object)0))) {
                pos = Expressions.subtract((Expression)pos, (Expression)add.startIndex());
            }
            return pos;
        }

        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            return Expressions.add((Expression)super.implementNotNullResult(info, result), (Expression)Expressions.constant((Object)1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserDefinedAggReflectiveImplementor
    extends StrictAggImplementor {
        private final AggregateFunctionImpl afi;

        public UserDefinedAggReflectiveImplementor(AggregateFunctionImpl afi) {
            this.afi = afi;
        }

        @Override
        public List<Type> getNotNullState(AggContext info) {
            if (this.afi.isStatic) {
                return Collections.singletonList(this.afi.accumulatorType);
            }
            return Arrays.asList(this.afi.accumulatorType, this.afi.declaringClass);
        }

        @Override
        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            if (!this.afi.isStatic) {
                reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(1), (Expression)Expressions.new_(this.afi.declaringClass))));
            }
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(0), (Expression)Expressions.call((Expression)(this.afi.isStatic ? null : acc.get(1)), (Method)this.afi.initMethod, (Expression[])new Expression[0]))));
        }

        @Override
        protected void implementNotNullAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            List<Expression> aggArgs = add.arguments();
            ArrayList<Expression> args = new ArrayList<Expression>(aggArgs.size() + 1);
            args.add(acc.get(0));
            args.addAll(aggArgs);
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(0), (Expression)Expressions.call((Expression)(this.afi.isStatic ? null : acc.get(1)), (Method)this.afi.addMethod, args))));
        }

        @Override
        protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
            List<Expression> acc = result.accumulator();
            return Expressions.call((Expression)(this.afi.isStatic ? null : acc.get(1)), (Method)this.afi.resultMethod, (Expression[])new Expression[]{acc.get(0)});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SingleValueImplementor
    implements AggImplementor {
        SingleValueImplementor() {
        }

        @Override
        public List<Type> getStateType(AggContext info) {
            return Arrays.asList(Boolean.TYPE, info.returnType());
        }

        @Override
        public void implementReset(AggContext info, AggResetContext reset) {
            List<Expression> acc = reset.accumulator();
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(0), (Expression)Expressions.constant((Object)false))));
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(1), (Expression)RexImpTable.getDefaultValue(acc.get(1).getType()))));
        }

        @Override
        public void implementAdd(AggContext info, AggAddContext add) {
            List<Expression> acc = add.accumulator();
            Expression flag = acc.get(0);
            add.currentBlock().add((Statement)Expressions.ifThen((Expression)flag, (Node)Expressions.throw_((Expression)Expressions.new_(IllegalStateException.class, (Expression[])new Expression[]{Expressions.constant((Object)("more than one value in agg " + info.aggregation().toString()))}))));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)flag, (Expression)Expressions.constant((Object)true))));
            add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(1), (Expression)add.arguments().get(0))));
        }

        @Override
        public Expression implementResult(AggContext info, AggResultContext result) {
            return RexToLixTranslator.convert(result.accumulator().get(1), info.returnType());
        }
    }

    static class MinMaxImplementor
    extends StrictAggImplementor {
        MinMaxImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            boolean isMin;
            Expression acc = reset.accumulator().get(0);
            Primitive p = Primitive.of((Type)acc.getType());
            boolean bl = isMin = SqlStdOperatorTable.MIN == info.aggregation();
            Object inf = p == null ? null : (isMin ? p.max : p.min);
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)Expressions.constant((Object)inf, (Type)acc.getType()))));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression acc = add.accumulator().get(0);
            Expression arg = add.arguments().get(0);
            Aggregation aggregation = info.aggregation();
            MethodCallExpression next = Expressions.call(SqlFunctions.class, (String)(aggregation == SqlStdOperatorTable.MIN ? "lesser" : "greater"), (Expression[])new Expression[]{acc, Expressions.unbox((Expression)arg)});
            this.accAdvance(add, acc, (Expression)next);
        }
    }

    static class SumImplementor
    extends StrictAggImplementor {
        SumImplementor() {
        }

        protected void implementNotNullReset(AggContext info, AggResetContext reset) {
            ConstantExpression start = info.returnType() == BigDecimal.class ? Expressions.constant((Object)BigDecimal.ZERO) : Expressions.constant((Object)0);
            reset.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)reset.accumulator().get(0), (Expression)start)));
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            Expression acc = add.accumulator().get(0);
            Object next = info.returnType() == BigDecimal.class ? Expressions.call((Expression)acc, (String)"add", (Expression[])new Expression[]{add.arguments().get(0)}) : Expressions.add((Expression)acc, (Expression)Types.castIfNecessary((Type)acc.type, (Expression)add.arguments().get(0)));
            this.accAdvance(add, acc, (Expression)next);
        }

        public Expression implementNotNullResult(AggContext info, AggResultContext result) {
            return super.implementNotNullResult(info, result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CountWinImplementor
    extends StrictWinAggImplementor {
        boolean justFrameRowCount;

        CountWinImplementor() {
        }

        @Override
        public List<Type> getNotNullState(WinAggContext info) {
            boolean hasNullable = false;
            for (RelDataType relDataType : info.parameterRelTypes()) {
                if (!relDataType.isNullable()) continue;
                hasNullable = true;
                break;
            }
            if (!hasNullable) {
                this.justFrameRowCount = true;
                return Collections.emptyList();
            }
            return super.getNotNullState(info);
        }

        @Override
        public void implementNotNullAdd(WinAggContext info, WinAggAddContext add) {
            if (this.justFrameRowCount) {
                return;
            }
            add.currentBlock().add(Expressions.statement((Expression)Expressions.postIncrementAssign((Expression)add.accumulator().get(0))));
        }

        @Override
        protected Expression implementNotNullResult(WinAggContext info, WinAggResultContext result) {
            if (this.justFrameRowCount) {
                return result.getFrameRowCount();
            }
            return super.implementNotNullResult(info, result);
        }
    }

    static class CountImplementor
    extends StrictAggImplementor {
        CountImplementor() {
        }

        public void implementNotNullAdd(AggContext info, AggAddContext add) {
            add.currentBlock().add(Expressions.statement((Expression)Expressions.postIncrementAssign((Expression)add.accumulator().get(0))));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NullAs {
        NULL,
        FALSE,
        TRUE,
        NOT_POSSIBLE,
        IS_NULL,
        IS_NOT_NULL;


        public static NullAs of(boolean nullable) {
            return nullable ? NULL : NOT_POSSIBLE;
        }

        public Expression handle(Expression x) {
            switch (Primitive.flavor((Type)x.getType())) {
                case PRIMITIVE: {
                    switch (this) {
                        case NOT_POSSIBLE: 
                        case TRUE: 
                        case FALSE: 
                        case NULL: {
                            return x;
                        }
                        case IS_NULL: {
                            return FALSE_EXPR;
                        }
                        case IS_NOT_NULL: {
                            return TRUE_EXPR;
                        }
                    }
                    throw new AssertionError();
                }
                case BOX: {
                    switch (this) {
                        case NOT_POSSIBLE: {
                            return RexToLixTranslator.convert(x, Primitive.ofBox((Type)x.getType()).primitiveClass);
                        }
                    }
                }
            }
            switch (this) {
                case NOT_POSSIBLE: 
                case NULL: {
                    return x;
                }
                case FALSE: {
                    return Expressions.call((Method)BuiltinMethod.IS_TRUE.method, (Expression[])new Expression[]{x});
                }
                case TRUE: {
                    return Expressions.call((Method)BuiltinMethod.IS_NOT_FALSE.method, (Expression[])new Expression[]{x});
                }
                case IS_NULL: {
                    return Expressions.equal((Expression)x, (Expression)NULL_EXPR);
                }
                case IS_NOT_NULL: {
                    return Expressions.notEqual((Expression)x, (Expression)NULL_EXPR);
                }
            }
            throw new AssertionError();
        }
    }
}

