/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

public class Like {
    private static final String JAVA_REGEX_SPECIALS = "[]()|^-+*?{}$\\";
    private static final String SQL_SIMILAR_SPECIALS = "[]()|^-+*_%?{}";
    private static final String[] REG_CHAR_CLASSES = new String[]{"[:ALPHA:]", "\\p{Alpha}", "[:alpha:]", "\\p{Alpha}", "[:UPPER:]", "\\p{Upper}", "[:upper:]", "\\p{Upper}", "[:LOWER:]", "\\p{Lower}", "[:lower:]", "\\p{Lower}", "[:DIGIT:]", "\\d", "[:digit:]", "\\d", "[:SPACE:]", " ", "[:space:]", " ", "[:WHITESPACE:]", "\\s", "[:whitespace:]", "\\s", "[:ALNUM:]", "\\p{Alnum}", "[:alnum:]", "\\p{Alnum}"};

    private Like() {
    }

    static String sqlToRegexLike(String sqlPattern, CharSequence escapeStr) {
        char escapeChar;
        if (escapeStr != null) {
            if (escapeStr.length() != 1) {
                throw Like.invalidEscapeCharacter(((Object)escapeStr).toString());
            }
            escapeChar = escapeStr.charAt(0);
        } else {
            escapeChar = '\u0000';
        }
        return Like.sqlToRegexLike(sqlPattern, escapeChar);
    }

    static String sqlToRegexLike(String sqlPattern, char escapeChar) {
        int len = sqlPattern.length();
        StringBuilder javaPattern = new StringBuilder(len + len);
        for (int i = 0; i < len; ++i) {
            char c = sqlPattern.charAt(i);
            if (JAVA_REGEX_SPECIALS.indexOf(c) >= 0) {
                javaPattern.append('\\');
            }
            if (c == escapeChar) {
                if (i == sqlPattern.length() - 1) {
                    throw Like.invalidEscapeSequence(sqlPattern, i);
                }
                char nextChar = sqlPattern.charAt(i + 1);
                if (nextChar == '_' || nextChar == '%' || nextChar == escapeChar) {
                    javaPattern.append(nextChar);
                    ++i;
                    continue;
                }
                throw Like.invalidEscapeSequence(sqlPattern, i);
            }
            if (c == '_') {
                javaPattern.append('.');
                continue;
            }
            if (c == '%') {
                javaPattern.append(".");
                javaPattern.append('*');
                continue;
            }
            javaPattern.append(c);
        }
        return javaPattern.toString();
    }

    private static RuntimeException invalidEscapeCharacter(String s) {
        return new RuntimeException("Invalid escape character '" + s + "'");
    }

    private static RuntimeException invalidEscapeSequence(String s, int i) {
        return new RuntimeException("Invalid escape sequence '" + s + "', " + i);
    }

    private static void similarEscapeRuleChecking(String sqlPattern, char escapeChar) {
        if (escapeChar == '\u0000') {
            return;
        }
        if (SQL_SIMILAR_SPECIALS.indexOf(escapeChar) >= 0) {
            for (int i = 0; i < sqlPattern.length(); ++i) {
                if (sqlPattern.charAt(i) != escapeChar) continue;
                if (i == sqlPattern.length() - 1) {
                    throw Like.invalidEscapeSequence(sqlPattern, i);
                }
                char c = sqlPattern.charAt(i + 1);
                if (SQL_SIMILAR_SPECIALS.indexOf(c) >= 0 || c == escapeChar) continue;
                throw Like.invalidEscapeSequence(sqlPattern, i);
            }
        }
        if (escapeChar == ':') {
            int position = sqlPattern.indexOf("[:");
            if (position >= 0) {
                position = sqlPattern.indexOf(":]");
            }
            if (position < 0) {
                throw Like.invalidEscapeSequence(sqlPattern, position);
            }
        }
    }

    private static RuntimeException invalidRegularExpression(String pattern, int i) {
        return new RuntimeException("Invalid regular expression '" + pattern + "'");
    }

    private static int sqlSimilarRewriteCharEnumeration(String sqlPattern, StringBuilder javaPattern, int pos, char escapeChar) {
        int i;
        for (i = pos + 1; i < sqlPattern.length(); ++i) {
            char c = sqlPattern.charAt(i);
            if (c == ']') {
                return i - 1;
            }
            if (c == escapeChar) {
                char nextChar;
                if (SQL_SIMILAR_SPECIALS.indexOf(nextChar = sqlPattern.charAt(++i)) >= 0) {
                    if (JAVA_REGEX_SPECIALS.indexOf(nextChar) >= 0) {
                        javaPattern.append('\\');
                    }
                    javaPattern.append(nextChar);
                    continue;
                }
                if (escapeChar == nextChar) {
                    javaPattern.append(nextChar);
                    continue;
                }
                throw Like.invalidRegularExpression(sqlPattern, i);
            }
            if (c == '-') {
                javaPattern.append('-');
                continue;
            }
            if (c == '^') {
                javaPattern.append('^');
                continue;
            }
            if (sqlPattern.startsWith("[:", i)) {
                int numOfRegCharSets = REG_CHAR_CLASSES.length / 2;
                boolean found = false;
                for (int j = 0; j < numOfRegCharSets; ++j) {
                    if (!sqlPattern.startsWith(REG_CHAR_CLASSES[j + j], i)) continue;
                    javaPattern.append(REG_CHAR_CLASSES[j + j + 1]);
                    i += REG_CHAR_CLASSES[j + j].length() - 1;
                    found = true;
                    break;
                }
                if (found) continue;
                throw Like.invalidRegularExpression(sqlPattern, i);
            }
            if (SQL_SIMILAR_SPECIALS.indexOf(c) >= 0) {
                throw Like.invalidRegularExpression(sqlPattern, i);
            }
            javaPattern.append(c);
        }
        return i - 1;
    }

    static String sqlToRegexSimilar(String sqlPattern, CharSequence escapeStr) {
        char escapeChar;
        if (escapeStr != null) {
            if (escapeStr.length() != 1) {
                throw Like.invalidEscapeCharacter(((Object)escapeStr).toString());
            }
            escapeChar = escapeStr.charAt(0);
        } else {
            escapeChar = '\u0000';
        }
        return Like.sqlToRegexSimilar(sqlPattern, escapeChar);
    }

    static String sqlToRegexSimilar(String sqlPattern, char escapeChar) {
        Like.similarEscapeRuleChecking(sqlPattern, escapeChar);
        boolean insideCharacterEnumeration = false;
        StringBuilder javaPattern = new StringBuilder(sqlPattern.length() * 2);
        int len = sqlPattern.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = sqlPattern.charAt(i);
            if (c == escapeChar) {
                if (i == len - 1) {
                    throw Like.invalidEscapeSequence(sqlPattern, i);
                }
                char nextChar = sqlPattern.charAt(i + 1);
                if (SQL_SIMILAR_SPECIALS.indexOf(nextChar) >= 0) {
                    if (JAVA_REGEX_SPECIALS.indexOf(nextChar) >= 0) {
                        javaPattern.append('\\');
                    }
                    javaPattern.append(nextChar);
                } else if (nextChar == escapeChar) {
                    javaPattern.append(nextChar);
                } else {
                    throw Like.invalidEscapeSequence(sqlPattern, i);
                }
                ++i;
                continue;
            }
            switch (c) {
                case '_': {
                    javaPattern.append('.');
                    continue block8;
                }
                case '%': {
                    javaPattern.append('.');
                    javaPattern.append('*');
                    continue block8;
                }
                case '[': {
                    javaPattern.append('[');
                    insideCharacterEnumeration = true;
                    i = Like.sqlSimilarRewriteCharEnumeration(sqlPattern, javaPattern, i, escapeChar);
                    continue block8;
                }
                case ']': {
                    if (!insideCharacterEnumeration) {
                        throw Like.invalidRegularExpression(sqlPattern, i);
                    }
                    insideCharacterEnumeration = false;
                    javaPattern.append(']');
                    continue block8;
                }
                case '\\': {
                    javaPattern.append("\\\\");
                    continue block8;
                }
                case '$': {
                    javaPattern.append("\\$");
                    continue block8;
                }
                default: {
                    javaPattern.append(c);
                }
            }
        }
        if (insideCharacterEnumeration) {
            throw Like.invalidRegularExpression(sqlPattern, len);
        }
        return javaPattern.toString();
    }
}

