/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCall {
    private final Aggregation aggregation;
    private final boolean distinct;
    public final RelDataType type;
    public final String name;
    private final ImmutableList<Integer> argList;

    public AggregateCall(Aggregation aggregation, boolean distinct, List<Integer> argList, RelDataType type, String name) {
        this.type = type;
        this.name = name;
        assert (aggregation != null);
        assert (argList != null);
        assert (type != null);
        this.aggregation = aggregation;
        this.argList = ImmutableList.copyOf(argList);
        this.distinct = distinct;
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int groupCount, RelNode input, RelDataType type, String name) {
        if (type == null) {
            RelDataTypeFactory typeFactory = input.getCluster().getTypeFactory();
            List<RelDataType> types = SqlTypeUtil.projectTypes(input.getRowType(), argList);
            AggregateRelBase.AggCallBinding callBinding = new AggregateRelBase.AggCallBinding(typeFactory, aggFunction, types, groupCount);
            type = aggFunction.inferReturnType(callBinding);
        }
        return new AggregateCall(aggFunction, distinct, argList, type, name);
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final Aggregation getAggregation() {
        return this.aggregation;
    }

    public final List<Integer> getArgList() {
        return this.argList;
    }

    public final RelDataType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public AggregateCall rename(String name) {
        return new AggregateCall(this.aggregation, this.distinct, (List<Integer>)this.argList, this.type, name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.aggregation.getName());
        buf.append("(");
        if (this.distinct) {
            buf.append(this.argList.size() == 0 ? "DISTINCT" : "DISTINCT ");
        }
        int i = -1;
        for (Integer arg : this.argList) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append("$");
            buf.append(arg);
        }
        buf.append(")");
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AggregateCall)) {
            return false;
        }
        AggregateCall other = (AggregateCall)o;
        return this.aggregation.equals(other.aggregation) && this.distinct == other.distinct && this.argList.equals(other.argList);
    }

    public int hashCode() {
        return this.aggregation.hashCode() + this.argList.hashCode();
    }

    public AggregateRelBase.AggCallBinding createBinding(AggregateRelBase aggregateRelBase) {
        RelDataType rowType = aggregateRelBase.getChild().getRowType();
        return new AggregateRelBase.AggCallBinding(aggregateRelBase.getCluster().getTypeFactory(), (SqlAggFunction)this.aggregation, SqlTypeUtil.projectTypes(rowType, this.argList), aggregateRelBase.getGroupCount());
    }

    public AggregateCall copy(List<Integer> args) {
        return new AggregateCall(this.aggregation, this.distinct, args, this.type, this.name);
    }

    public AggregateCall adaptTo(RelNode input, List<Integer> aggArgs, int oldGroupKeyCount, int newGroupKeyCount) {
        SqlAggFunction sqlAgg = (SqlAggFunction)this.aggregation;
        RelDataType newType = oldGroupKeyCount == newGroupKeyCount ? this.type : null;
        return AggregateCall.create(sqlAgg, this.distinct, aggArgs, newGroupKeyCount, input, newType, this.getName());
    }

    public AggregateCall transform(Mappings.TargetMapping mapping) {
        return this.copy(Mappings.permute(this.argList, mapping));
    }
}

