/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eigenbase.rel.Correlation;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttle;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CorrelatorRel
extends JoinRelBase {
    protected final ImmutableList<Correlation> correlations;

    public CorrelatorRel(RelOptCluster cluster, RelNode left, RelNode right, RexNode joinCond, List<Correlation> correlations, JoinRelType joinType) {
        super(cluster, cluster.traitSetOf(Convention.NONE), left, right, joinCond, joinType, (Set<String>)ImmutableSet.of());
        this.correlations = ImmutableList.copyOf(correlations);
        assert (joinType == JoinRelType.LEFT || joinType == JoinRelType.INNER);
    }

    public CorrelatorRel(RelOptCluster cluster, RelNode left, RelNode right, List<Correlation> correlations, JoinRelType joinType) {
        this(cluster, left, right, cluster.getRexBuilder().makeLiteral(true), correlations, joinType);
    }

    public CorrelatorRel(RelInput input) {
        this(input.getCluster(), input.getInputs().get(0), input.getInputs().get(1), CorrelatorRel.getCorrelations(input), input.getEnum("joinType", JoinRelType.class));
    }

    private static List<Correlation> getCorrelations(RelInput input) {
        ArrayList<Correlation> list = new ArrayList<Correlation>();
        List correlations1 = (List)input.get("correlations");
        for (Map correlation : correlations1) {
            list.add(new Correlation((Integer)correlation.get("correlation"), (Integer)correlation.get("offset")));
        }
        return list;
    }

    @Override
    public CorrelatorRel copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new CorrelatorRel(this.getCluster(), left, right, (List<Correlation>)this.correlations, this.joinType);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("correlations", this.correlations);
    }

    public List<Correlation> getCorrelations() {
        return this.correlations;
    }
}

