/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.mapping.IntPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinInfo {
    public final ImmutableIntList leftKeys;
    public final ImmutableIntList rightKeys;

    protected JoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        this.leftKeys = (ImmutableIntList)Preconditions.checkNotNull((Object)leftKeys);
        this.rightKeys = (ImmutableIntList)Preconditions.checkNotNull((Object)rightKeys);
        assert (leftKeys.size() == rightKeys.size());
    }

    public static JoinInfo of(RelNode left, RelNode right, RexNode condition) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys);
        if (remaining.isAlwaysTrue()) {
            return new EquiJoinInfo(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys));
        }
        return new NonEquiJoinInfo(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys), remaining);
    }

    public static JoinInfo of(ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        return new EquiJoinInfo(leftKeys, rightKeys);
    }

    public abstract boolean isEqui();

    public List<IntPair> pairs() {
        return IntPair.zip(this.leftKeys, this.rightKeys);
    }

    public BitSet leftSet() {
        return BitSets.of(this.leftKeys);
    }

    public BitSet rightSet() {
        return BitSets.of(this.rightKeys);
    }

    public abstract RexNode getRemaining(RexBuilder var1);

    public RexNode getEquiCondition(RelNode left, RelNode right, RexBuilder rexBuilder) {
        return RelOptUtil.createEquiJoinCondition(left, this.leftKeys, right, this.rightKeys, rexBuilder);
    }

    private static class NonEquiJoinInfo
    extends JoinInfo {
        public final RexNode remaining;

        protected NonEquiJoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys, RexNode remaining) {
            super(leftKeys, rightKeys);
            this.remaining = (RexNode)Preconditions.checkNotNull((Object)remaining);
            assert (!remaining.isAlwaysTrue());
        }

        public boolean isEqui() {
            return false;
        }

        public RexNode getRemaining(RexBuilder rexBuilder) {
            return this.remaining;
        }
    }

    private static class EquiJoinInfo
    extends JoinInfo {
        protected EquiJoinInfo(ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
            super(leftKeys, rightKeys);
        }

        public boolean isEqui() {
            return true;
        }

        public RexNode getRemaining(RexBuilder rexBuilder) {
            return rexBuilder.makeLiteral(true);
        }
    }
}

