/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import com.google.common.collect.ImmutableList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.JoinInfo;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlKind;

public class RelFactories {
    public static final ProjectFactory DEFAULT_PROJECT_FACTORY = new ProjectFactoryImpl();
    public static final FilterFactory DEFAULT_FILTER_FACTORY = new FilterFactoryImpl();
    public static final JoinFactory DEFAULT_JOIN_FACTORY = new JoinFactoryImpl();
    public static final SemiJoinFactory DEFAULT_SEMI_JOIN_FACTORY = new SemiJoinFactoryImpl();
    public static final SortFactory DEFAULT_SORT_FACTORY = new SortFactoryImpl();
    public static final AggregateFactory DEFAULT_AGGREGATE_FACTORY = new AggregateFactoryImpl();
    public static final SetOpFactory DEFAULT_SET_OP_FACTORY = new SetOpFactoryImpl();

    private RelFactories() {
    }

    private static class SemiJoinFactoryImpl
    implements SemiJoinFactory {
        private SemiJoinFactoryImpl() {
        }

        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            return new SemiJoinRel(left.getCluster(), left.getTraitSet(), left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
    }

    public static interface SemiJoinFactory {
        public RelNode createSemiJoin(RelNode var1, RelNode var2, RexNode var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JoinFactoryImpl
    implements JoinFactory {
        private JoinFactoryImpl() {
        }

        @Override
        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            RelOptCluster cluster = left.getCluster();
            return new JoinRel(cluster, left, right, condition, joinType, variablesStopped, semiJoinDone, (ImmutableList<RelDataTypeField>)ImmutableList.of());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JoinFactory {
        public RelNode createJoin(RelNode var1, RelNode var2, RexNode var3, JoinRelType var4, Set<String> var5, boolean var6);
    }

    private static class FilterFactoryImpl
    implements FilterFactory {
        private FilterFactoryImpl() {
        }

        public RelNode createFilter(RelNode child, RexNode condition) {
            return new FilterRel(child.getCluster(), child, condition);
        }
    }

    public static interface FilterFactory {
        public RelNode createFilter(RelNode var1, RexNode var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AggregateFactoryImpl
    implements AggregateFactory {
        private AggregateFactoryImpl() {
        }

        @Override
        public RelNode createAggregate(RelNode child, BitSet groupSet, List<AggregateCall> aggCalls) {
            return new AggregateRel(child.getCluster(), child, groupSet, aggCalls);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AggregateFactory {
        public RelNode createAggregate(RelNode var1, BitSet var2, List<AggregateCall> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetOpFactoryImpl
    implements SetOpFactory {
        private SetOpFactoryImpl() {
        }

        @Override
        public RelNode createSetOp(SqlKind kind, List<RelNode> inputs, boolean all) {
            RelOptCluster cluster = inputs.get(0).getCluster();
            switch (kind) {
                case UNION: {
                    return new UnionRel(cluster, inputs, all);
                }
                case EXCEPT: {
                    return new MinusRel(cluster, inputs, all);
                }
                case INTERSECT: {
                    return new IntersectRel(cluster, inputs, all);
                }
            }
            throw new AssertionError((Object)("not a set op: " + (Object)((Object)kind)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SetOpFactory {
        public RelNode createSetOp(SqlKind var1, List<RelNode> var2, boolean var3);
    }

    private static class SortFactoryImpl
    implements SortFactory {
        private SortFactoryImpl() {
        }

        public RelNode createSort(RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            return new SortRel(child.getCluster(), traits, child, collation, offset, fetch);
        }
    }

    public static interface SortFactory {
        public RelNode createSort(RelTraitSet var1, RelNode var2, RelCollation var3, RexNode var4, RexNode var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectFactoryImpl
    implements ProjectFactory {
        private ProjectFactoryImpl() {
        }

        @Override
        public RelNode createProject(RelNode child, List<? extends RexNode> childExprs, List<String> fieldNames) {
            return RelOptUtil.createProject(child, childExprs, fieldNames);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProjectFactory {
        public RelNode createProject(RelNode var1, List<? extends RexNode> var2, List<String> var3);
    }
}

