/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptSamplingParameters;
import org.eigenbase.relopt.RelTraitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplingRel
extends SingleRel {
    private final RelOptSamplingParameters params;

    public SamplingRel(RelOptCluster cluster, RelNode child, RelOptSamplingParameters params) {
        super(cluster, cluster.traitSetOf(Convention.NONE), child);
        this.params = params;
    }

    public SamplingRel(RelInput input) {
        this(input.getCluster(), input.getInput(), SamplingRel.getSamplingParameters(input));
    }

    private static RelOptSamplingParameters getSamplingParameters(RelInput input) {
        String mode = input.getString("mode");
        float percentage = input.getFloat("rate");
        Object repeatableSeed = input.get("repeatableSeed");
        boolean repeatable = repeatableSeed instanceof Number;
        return new RelOptSamplingParameters(mode.equals("bernoulli"), percentage, repeatable, repeatable ? ((Number)repeatableSeed).intValue() : 0);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new SamplingRel(this.getCluster(), SamplingRel.sole(inputs), this.params);
    }

    public RelOptSamplingParameters getSamplingParameters() {
        return this.params;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("mode", this.params.isBernoulli() ? "bernoulli" : "system").item("rate", Float.valueOf(this.params.getSamplingPercentage())).item("repeatableSeed", this.params.isRepeatable() ? Integer.valueOf(this.params.getRepeatableSeed()) : "-");
    }
}

