/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel;

import java.util.List;
import org.eigenbase.rel.RelInput;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SetOpRel;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.sql.SqlKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnionRelBase
extends SetOpRel {
    protected UnionRelBase(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, SqlKind.UNION, all);
    }

    protected UnionRelBase(RelInput input) {
        super(input);
    }

    @Override
    public double getRows() {
        double dRows = UnionRelBase.estimateRowCount(this);
        if (!this.all) {
            dRows *= 0.5;
        }
        return dRows;
    }

    public static double estimateRowCount(RelNode rel) {
        double dRows = 0.0;
        for (RelNode input : rel.getInputs()) {
            dRows += RelMetadataQuery.getRowCount(input).doubleValue();
        }
        return dRows;
    }
}

