/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.JoinInfo;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRedundantSemiJoinRule
extends RelOptRule {
    public static final AddRedundantSemiJoinRule INSTANCE = new AddRedundantSemiJoinRule(JoinRel.class);

    private AddRedundantSemiJoinRule(Class<? extends JoinRelBase> clazz) {
        super(AddRedundantSemiJoinRule.operand(clazz, AddRedundantSemiJoinRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        JoinRelBase origJoinRel = (JoinRelBase)call.rel(0);
        if (origJoinRel.isSemiJoinDone()) {
            return;
        }
        if (origJoinRel.getJoinType() != JoinRelType.INNER) {
            return;
        }
        JoinInfo joinInfo = origJoinRel.analyzeCondition();
        if (joinInfo.leftKeys.size() == 0) {
            return;
        }
        SemiJoinRel semiJoin = new SemiJoinRel(origJoinRel.getCluster(), origJoinRel.getCluster().traitSetOf(Convention.NONE), origJoinRel.getLeft(), origJoinRel.getRight(), origJoinRel.getCondition(), joinInfo.leftKeys, joinInfo.rightKeys);
        JoinRelBase newJoinRel = origJoinRel.copy(origJoinRel.getTraitSet(), origJoinRel.getCondition(), semiJoin, origJoinRel.getRight(), JoinRelType.INNER, true);
        call.transformTo(newJoinRel);
    }
}

