/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.SubstitutionVisitor;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.util.mapping.Mappings;

public class AggregateFilterTransposeRule
extends RelOptRule {
    public static final AggregateFilterTransposeRule INSTANCE = new AggregateFilterTransposeRule();

    private AggregateFilterTransposeRule() {
        super(AggregateFilterTransposeRule.operand(AggregateRelBase.class, AggregateFilterTransposeRule.operand(FilterRelBase.class, AggregateFilterTransposeRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        AggregateRelBase aggregate = (AggregateRelBase)call.rel(0);
        FilterRelBase filter = (FilterRelBase)call.rel(1);
        BitSet filterColumns = RelOptUtil.InputFinder.bits(filter.getCondition());
        final BitSet newGroupSet = BitSets.union(aggregate.getGroupSet(), filterColumns);
        RelNode input = filter.getChild();
        Boolean unique = RelMetadataQuery.areColumnsUnique(input, newGroupSet);
        if (unique != null && unique.booleanValue()) {
            return;
        }
        AggregateRelBase newAggregate = aggregate.copy(aggregate.getTraitSet(), input, newGroupSet, aggregate.getAggCallList());
        Mappings.TargetMapping mapping = Mappings.target(new Function<Integer, Integer>(){

            public Integer apply(Integer a0) {
                return BitSets.toList(newGroupSet).indexOf(a0);
            }
        }, input.getRowType().getFieldCount(), newGroupSet.cardinality());
        RexNode newCondition = RexUtil.apply(mapping, filter.getCondition());
        FilterRelBase newFilter = filter.copy(filter.getTraitSet(), newAggregate, newCondition);
        if (BitSets.contains(aggregate.getGroupSet(), filterColumns)) {
            assert (newGroupSet.equals(aggregate.getGroupSet()));
            call.transformTo(newFilter);
        } else {
            BitSet topGroupSet = new BitSet();
            for (int c : BitSets.toIter(aggregate.getGroupSet())) {
                topGroupSet.set(BitSets.toList(newGroupSet).indexOf(c));
            }
            ArrayList topAggCallList = Lists.newArrayList();
            int i = newGroupSet.cardinality();
            for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
                SqlAggFunction rollup = SubstitutionVisitor.getRollup(aggregateCall.getAggregation());
                if (rollup == null) {
                    return;
                }
                if (aggregateCall.isDistinct()) {
                    return;
                }
                topAggCallList.add(new AggregateCall(rollup, aggregateCall.isDistinct(), (List<Integer>)ImmutableList.of((Object)i++), aggregateCall.type, aggregateCall.name));
            }
            AggregateRelBase topAggregate = aggregate.copy(aggregate.getTraitSet(), newFilter, topGroupSet, topAggCallList);
            call.transformTo(topAggregate);
        }
    }
}

