/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;

public class AggregateProjectMergeRule
extends RelOptRule {
    public static final AggregateProjectMergeRule INSTANCE = new AggregateProjectMergeRule();

    private AggregateProjectMergeRule() {
        super(AggregateProjectMergeRule.operand(AggregateRelBase.class, AggregateProjectMergeRule.operand(ProjectRelBase.class, AggregateProjectMergeRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectRelBase project;
        AggregateRelBase aggregate = (AggregateRelBase)call.rel(0);
        RelNode x = AggregateProjectMergeRule.apply(aggregate, project = (ProjectRelBase)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(AggregateRelBase aggregate, ProjectRelBase project) {
        AggregateRelBase newAggregate;
        ArrayList newKeys = Lists.newArrayList();
        for (int key : BitSets.toIter(aggregate.getGroupSet())) {
            RexNode rex = project.getProjects().get(key);
            if (rex instanceof RexInputRef) {
                newKeys.add(((RexInputRef)rex).getIndex());
                continue;
            }
            return null;
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            ImmutableList.Builder newArgs = ImmutableList.builder();
            for (int arg : aggregateCall.getArgList()) {
                RexNode rex = project.getProjects().get(arg);
                if (rex instanceof RexInputRef) {
                    newArgs.add((Object)((RexInputRef)rex).getIndex());
                    continue;
                }
                return null;
            }
            aggCalls.add((Object)aggregateCall.copy((List<Integer>)newArgs.build()));
        }
        BitSet newGroupSet = BitSets.of(newKeys);
        RelNode rel = newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getChild(), newGroupSet, (List<AggregateCall>)aggCalls.build());
        if (!BitSets.toList(newGroupSet).equals(newKeys)) {
            ArrayList posList = Lists.newArrayList();
            Iterator i$ = newKeys.iterator();
            while (i$.hasNext()) {
                int newKey = (Integer)i$.next();
                posList.add(BitSets.toList(newGroupSet).indexOf(newKey));
            }
            for (int i = newAggregate.getGroupSet().cardinality(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            rel = RelOptUtil.createProject(RelFactories.DEFAULT_PROJECT_FACTORY, rel, posList);
        }
        return rel;
    }
}

