/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.StarTable;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.Lattice;
import net.hydromatic.optiq.materialize.TileKey;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.RelOptTableImpl;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.AggregateProjectMergeRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptLattice;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.SubstitutionVisitor;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.util.Pair;
import org.eigenbase.util.mapping.AbstractSourceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateStarTableRule
extends RelOptRule {
    public static final AggregateStarTableRule INSTANCE = new AggregateStarTableRule(AggregateStarTableRule.operand(AggregateRelBase.class, AggregateStarTableRule.some(AggregateStarTableRule.operand(StarTable.StarTableScan.class, AggregateStarTableRule.none()), new RelOptRuleOperand[0])), "AggregateStarTableRule");
    public static final AggregateStarTableRule INSTANCE2 = new AggregateStarTableRule(AggregateStarTableRule.operand(AggregateRelBase.class, AggregateStarTableRule.operand(ProjectRelBase.class, AggregateStarTableRule.operand(StarTable.StarTableScan.class, AggregateStarTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "AggregateStarTableRule:project"){

        public void onMatch(RelOptRuleCall call) {
            AggregateRelBase aggregate2;
            ProjectRelBase project2;
            AggregateRelBase aggregate = (AggregateRelBase)call.rel(0);
            ProjectRelBase project = (ProjectRelBase)call.rel(1);
            StarTable.StarTableScan scan = (StarTable.StarTableScan)call.rel(2);
            RelNode rel = AggregateProjectMergeRule.apply(aggregate, project);
            if (rel instanceof AggregateRelBase) {
                project2 = null;
                aggregate2 = (AggregateRelBase)rel;
            } else if (rel instanceof ProjectRelBase) {
                project2 = (ProjectRelBase)rel;
                aggregate2 = (AggregateRelBase)project2.getChild();
            } else {
                return;
            }
            this.apply(call, project2, aggregate2, scan);
        }
    };

    private AggregateStarTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        AggregateRelBase aggregate = (AggregateRelBase)call.rel(0);
        StarTable.StarTableScan scan = (StarTable.StarTableScan)call.rel(1);
        this.apply(call, null, aggregate, scan);
    }

    protected void apply(RelOptRuleCall call, ProjectRelBase postProject, final AggregateRelBase aggregate, StarTable.StarTableScan scan) {
        RelOptCluster cluster = scan.getCluster();
        RelOptTable table = scan.getTable();
        RelOptLattice lattice = call.getPlanner().getLattice(table);
        final List<Lattice.Measure> measures = lattice.lattice.toMeasures(aggregate.getAggCallList());
        Pair<OptiqSchema.TableEntry, TileKey> pair = lattice.getAggregate(call.getPlanner(), aggregate.getGroupSet(), measures);
        if (pair == null) {
            return;
        }
        OptiqSchema.TableEntry tableEntry = (OptiqSchema.TableEntry)pair.left;
        final TileKey tileKey = (TileKey)pair.right;
        double rowCount = aggregate.getRows();
        Table aggregateTable = tableEntry.getTable();
        RelDataType aggregateTableRowType = aggregateTable.getRowType(cluster.getTypeFactory());
        RelOptTableImpl aggregateRelOptTable = RelOptTableImpl.create(table.getRelOptSchema(), aggregateTableRowType, tableEntry, rowCount);
        RelNode rel = aggregateRelOptTable.toRel(RelOptUtil.getContext(cluster));
        if (tileKey == null) {
            if (OptiqPrepareImpl.DEBUG) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + " (exact match)");
            }
        } else if (!tileKey.dimensions.equals(aggregate.getGroupSet())) {
            if (OptiqPrepareImpl.DEBUG) {
                System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + ", rolling up " + tileKey.dimensions + " to " + aggregate.getGroupSet());
            }
            assert (BitSets.contains(tileKey.dimensions, aggregate.getGroupSet()));
            ArrayList aggCalls = Lists.newArrayList();
            BitSet groupSet = new BitSet();
            Iterator<Object> i$ = BitSets.toIter(aggregate.getGroupSet()).iterator();
            while (i$.hasNext()) {
                int key = i$.next();
                groupSet.set(BitSets.toList(tileKey.dimensions).indexOf(key));
            }
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                AggregateCall copy = AggregateStarTableRule.rollUp(groupSet.cardinality(), rel, aggCall, tileKey);
                if (copy == null) {
                    return;
                }
                aggCalls.add(copy);
            }
            rel = aggregate.copy(aggregate.getTraitSet(), rel, groupSet, aggCalls);
        } else if (!tileKey.measures.equals(measures)) {
            System.out.println("Using materialization " + aggregateRelOptTable.getQualifiedName() + ", right granularity, but different measures " + aggregate.getAggCallList());
            rel = RelOptUtil.project(rel, new AbstractSourceMapping(tileKey.dimensions.cardinality() + tileKey.measures.size(), aggregate.getRowType().getFieldCount()){

                public int getSourceOpt(int source) {
                    if (source < aggregate.getGroupCount()) {
                        int in = (Integer)BitSets.toList(tileKey.dimensions).get(source);
                        return BitSets.toList(aggregate.getGroupSet()).indexOf(in);
                    }
                    Lattice.Measure measure = (Lattice.Measure)measures.get(source - aggregate.getGroupCount());
                    int i = tileKey.measures.indexOf((Object)measure);
                    assert (i >= 0);
                    return tileKey.dimensions.cardinality() + i;
                }
            });
        }
        if (postProject != null) {
            rel = postProject.copy(postProject.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rel));
        }
        call.transformTo(rel);
    }

    private static AggregateCall rollUp(int groupCount, RelNode input, AggregateCall aggregateCall, TileKey tileKey) {
        block4: {
            SqlAggFunction roll;
            if (aggregateCall.isDistinct()) {
                return null;
            }
            SqlAggFunction aggregation = (SqlAggFunction)aggregateCall.getAggregation();
            Pair<SqlAggFunction, List<Integer>> seek = Pair.of(aggregation, aggregateCall.getArgList());
            int offset = tileKey.dimensions.cardinality();
            ImmutableList<Lattice.Measure> measures = tileKey.measures;
            int i = AggregateStarTableRule.find(measures, seek);
            if (i >= 0 && (roll = SubstitutionVisitor.getRollup(aggregation)) != null) {
                return AggregateCall.create(roll, false, (List<Integer>)ImmutableList.of((Object)(offset + i)), groupCount, input, null, aggregateCall.name);
            }
            ArrayList newArgs = Lists.newArrayList();
            for (Integer arg : aggregateCall.getArgList()) {
                int z = BitSets.toList(tileKey.dimensions).indexOf(arg);
                if (z >= 0) {
                    newArgs.add(z);
                    continue;
                }
                break block4;
            }
            return AggregateCall.create(aggregation, false, newArgs, groupCount, input, null, aggregateCall.name);
        }
        return null;
    }

    private static int find(ImmutableList<Lattice.Measure> measures, Pair<SqlAggFunction, List<Integer>> seek) {
        for (int i = 0; i < measures.size(); ++i) {
            Lattice.Measure measure = (Lattice.Measure)measures.get(i);
            if (!measure.agg.equals(seek.left) || !((Object)measure.argOrdinals()).equals(seek.right)) continue;
            return i;
        }
        return -1;
    }
}

