/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterAggregateTransposeRule
extends RelOptRule {
    public static final FilterAggregateTransposeRule INSTANCE = new FilterAggregateTransposeRule(FilterRelBase.class, RelFactories.DEFAULT_FILTER_FACTORY, AggregateRelBase.class);
    private final RelFactories.FilterFactory filterFactory;

    public FilterAggregateTransposeRule(Class<? extends FilterRelBase> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends AggregateRelBase> aggregateClass) {
        super(FilterAggregateTransposeRule.operand(filterClass, FilterAggregateTransposeRule.operand(aggregateClass, FilterAggregateTransposeRule.any()), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FilterRelBase filterRel = (FilterRelBase)call.rel(0);
        AggregateRelBase aggRel = (AggregateRelBase)call.rel(1);
        List<RexNode> conditions = RelOptUtil.conjunctions(filterRel.getCondition());
        BitSet groupKeys = aggRel.getGroupSet();
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = aggRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        ArrayList pushedConditions = Lists.newArrayList();
        ArrayList remainingConditions = Lists.newArrayList();
        for (RexNode condition : conditions) {
            BitSet rCols = RelOptUtil.InputFinder.bits(condition);
            if (BitSets.contains(groupKeys, rCols)) {
                pushedConditions.add(condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, aggRel.getInput(0).getRowType().getFieldList(), adjustments)));
                continue;
            }
            remainingConditions.add(condition);
        }
        RelNode rel = RelOptUtil.createFilter(aggRel.getInput(0), pushedConditions, this.filterFactory);
        if (rel == aggRel.getInput(0)) {
            return;
        }
        rel = aggRel.copy(aggRel.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rel));
        rel = RelOptUtil.createFilter(rel, remainingConditions, this.filterFactory);
        call.transformTo(rel);
    }
}

