/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.FilterableTable;
import net.hydromatic.optiq.ProjectableFilterableTable;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.JavaRules;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Static;

public class FilterTableRule
extends RelOptRule {
    private static final Predicate<TableAccessRelBase> PREDICATE = new Predicate<TableAccessRelBase>(){

        public boolean apply(TableAccessRelBase scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(FilterableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final FilterTableRule INSTANCE = new FilterTableRule();

    private FilterTableRule() {
        super(FilterTableRule.operand(FilterRelBase.class, FilterTableRule.operand(JavaRules.EnumerableInterpreterRel.class, FilterTableRule.operand(TableAccessRelBase.class, null, PREDICATE, FilterTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        FilterSplit filterSplit;
        FilterRelBase filter = (FilterRelBase)call.rel(0);
        JavaRules.EnumerableInterpreterRel interpreter = (JavaRules.EnumerableInterpreterRel)call.rel(1);
        TableAccessRelBase scan = (TableAccessRelBase)call.rel(2);
        FilterableTable filterableTable = scan.getTable().unwrap(FilterableTable.class);
        ProjectableFilterableTable projectableFilterableTable = scan.getTable().unwrap(ProjectableFilterableTable.class);
        if (filterableTable != null) {
            filterSplit = FilterSplit.of(filterableTable, filter.getCondition(), null);
        } else if (projectableFilterableTable != null) {
            filterSplit = FilterSplit.of(projectableFilterableTable, filter.getCondition(), null);
        } else {
            throw new AssertionError(scan.getTable());
        }
        RelNode newFilter = RelOptUtil.createFilter(interpreter.getChild(), filterSplit.acceptedFilters, EnumerableRel.FILTER_FACTORY);
        JavaRules.EnumerableInterpreterRel newInterpreter = new JavaRules.EnumerableInterpreterRel(interpreter.getCluster(), interpreter.getTraitSet(), newFilter, 0.15);
        RelNode residue = RelOptUtil.createFilter((RelNode)newInterpreter, filterSplit.rejectedFilters);
        call.transformTo(residue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterSplit {
        public final ImmutableList<RexNode> acceptedFilters;
        public final ImmutableList<RexNode> rejectedFilters;

        public FilterSplit(ImmutableList<RexNode> acceptedFilters, ImmutableList<RexNode> rejectedFilters) {
            this.acceptedFilters = acceptedFilters;
            this.rejectedFilters = rejectedFilters;
        }

        public static FilterSplit of(FilterableTable table, RexNode condition, DataContext dataContext) {
            ArrayList filters = Lists.newArrayList();
            RelOptUtil.decomposeConjunction(condition, filters);
            ImmutableList originalFilters = ImmutableList.copyOf((Collection)filters);
            Enumerable<Object[]> enumerable = table.scan(dataContext, filters);
            return FilterSplit.rest((List<RexNode>)originalFilters, filters, enumerable);
        }

        public static FilterSplit of(ProjectableFilterableTable table, RexNode condition, DataContext dataContext) {
            ArrayList filters = Lists.newArrayList();
            RelOptUtil.decomposeConjunction(condition, filters);
            ImmutableList originalFilters = ImmutableList.copyOf((Collection)filters);
            Enumerable<Object[]> enumerable = table.scan(dataContext, filters, null);
            return FilterSplit.rest((List<RexNode>)originalFilters, filters, enumerable);
        }

        private static FilterSplit rest(List<RexNode> originalFilters, List<RexNode> filters, Enumerable<Object[]> enumerable) {
            if (enumerable == null) {
                throw Static.RESOURCE.filterableTableScanReturnedNull().ex();
            }
            ImmutableList.Builder accepted = ImmutableList.builder();
            ImmutableList.Builder rejected = ImmutableList.builder();
            for (RexNode originalFilter : originalFilters) {
                if (filters.contains(originalFilter)) {
                    rejected.add((Object)originalFilter);
                    continue;
                }
                accepted.add((Object)originalFilter);
            }
            for (RexNode node : filters) {
                if (originalFilters.contains(node)) continue;
                throw Static.RESOURCE.filterableTableInventedFilter(node.toString()).ex();
            }
            return new FilterSplit((ImmutableList<RexNode>)accepted.build(), (ImmutableList<RexNode>)rejected.build());
        }
    }
}

