/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelColumnOrigin;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.LoptJoinTree;
import org.eigenbase.rel.rules.MultiJoinRel;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.util.IntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoptMultiJoin {
    MultiJoinRel multiJoin;
    private List<RexNode> joinFilters;
    private List<RexNode> allJoinFilters;
    private final int nJoinFactors;
    private int nTotalFields;
    private final ImmutableList<RelNode> joinFactors;
    private final ImmutableList<JoinRelType> joinTypes;
    private final BitSet[] outerJoinFactors;
    private List<BitSet> projFields;
    private Map<Integer, int[]> joinFieldRefCountsMap;
    private Map<RexNode, BitSet> factorsRefByJoinFilter;
    private Map<RexNode, BitSet> fieldsRefByJoinFilter;
    int[] joinStart;
    int[] nFieldsInJoinFactor;
    BitSet[] factorsRefByFactor;
    int[][] factorWeights;
    final RelDataTypeFactory factory;
    Integer[] joinRemovalFactors;
    SemiJoinRel[] joinRemovalSemiJoins;
    Set<Integer> removableOuterJoinFactors;
    Map<Integer, RemovableSelfJoin> removableSelfJoinPairs;

    public LoptMultiJoin(MultiJoinRel multiJoin) {
        this.multiJoin = multiJoin;
        this.joinFactors = ImmutableList.copyOf(multiJoin.getInputs());
        this.nJoinFactors = this.joinFactors.size();
        this.projFields = multiJoin.getProjFields();
        this.joinFieldRefCountsMap = multiJoin.getCopyJoinFieldRefCountsMap();
        this.joinFilters = Lists.newArrayList(RelOptUtil.conjunctions(multiJoin.getJoinFilter()));
        this.allJoinFilters = new ArrayList<RexNode>(this.joinFilters);
        List<RexNode> outerJoinFilters = multiJoin.getOuterJoinConditions();
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.allJoinFilters.addAll(RelOptUtil.conjunctions(outerJoinFilters.get(i)));
        }
        int start = 0;
        this.nTotalFields = multiJoin.getRowType().getFieldCount();
        this.joinStart = new int[this.nJoinFactors];
        this.nFieldsInJoinFactor = new int[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.joinStart[i] = start;
            this.nFieldsInJoinFactor[i] = ((RelNode)this.joinFactors.get(i)).getRowType().getFieldCount();
            start += this.nFieldsInJoinFactor[i];
        }
        this.joinTypes = ImmutableList.copyOf(multiJoin.getJoinTypes());
        List<RexNode> outerJoinConds = this.multiJoin.getOuterJoinConditions();
        this.outerJoinFactors = new BitSet[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            if (outerJoinConds.get(i) == null) continue;
            BitSet dependentFactors = this.getJoinFilterFactorBitmap(outerJoinConds.get(i), false);
            dependentFactors.clear(i);
            this.outerJoinFactors[i] = dependentFactors;
        }
        this.setJoinFilterRefs();
        this.factory = multiJoin.getCluster().getTypeFactory();
        this.joinRemovalFactors = new Integer[this.nJoinFactors];
        this.joinRemovalSemiJoins = new SemiJoinRel[this.nJoinFactors];
        this.removableOuterJoinFactors = new HashSet<Integer>();
        this.removableSelfJoinPairs = new HashMap<Integer, RemovableSelfJoin>();
    }

    public MultiJoinRel getMultiJoinRel() {
        return this.multiJoin;
    }

    public int getNumJoinFactors() {
        return this.nJoinFactors;
    }

    public RelNode getJoinFactor(int factIdx) {
        return (RelNode)this.joinFactors.get(factIdx);
    }

    public int getNumTotalFields() {
        return this.nTotalFields;
    }

    public int getNumFieldsInJoinFactor(int factIdx) {
        return this.nFieldsInJoinFactor[factIdx];
    }

    public List<RexNode> getJoinFilters() {
        return this.joinFilters;
    }

    public BitSet getFactorsRefByJoinFilter(RexNode joinFilter) {
        return this.factorsRefByJoinFilter.get(joinFilter);
    }

    public List<RelDataTypeField> getMultiJoinFields() {
        return this.multiJoin.getRowType().getFieldList();
    }

    public BitSet getFieldsRefByJoinFilter(RexNode joinFilter) {
        return this.fieldsRefByJoinFilter.get(joinFilter);
    }

    public int[][] getFactorWeights() {
        return this.factorWeights;
    }

    public BitSet getFactorsRefByFactor(int factIdx) {
        return this.factorsRefByFactor[factIdx];
    }

    public int getJoinStart(int factIdx) {
        return this.joinStart[factIdx];
    }

    public boolean isNullGenerating(int factIdx) {
        return this.joinTypes.get(factIdx) != JoinRelType.INNER;
    }

    public BitSet getOuterJoinFactors(int factIdx) {
        return this.outerJoinFactors[factIdx];
    }

    public RexNode getOuterJoinCond(int factIdx) {
        return this.multiJoin.getOuterJoinConditions().get(factIdx);
    }

    public BitSet getProjFields(int factIdx) {
        return this.projFields.get(factIdx);
    }

    public int[] getJoinFieldRefCounts(int factIdx) {
        return this.joinFieldRefCountsMap.get(factIdx);
    }

    public Integer getJoinRemovalFactor(int dimIdx) {
        return this.joinRemovalFactors[dimIdx];
    }

    public SemiJoinRel getJoinRemovalSemiJoin(int dimIdx) {
        return this.joinRemovalSemiJoins[dimIdx];
    }

    public void setJoinRemovalFactor(int dimIdx, int factIdx) {
        this.joinRemovalFactors[dimIdx] = factIdx;
    }

    public void setJoinRemovalSemiJoin(int dimIdx, SemiJoinRel semiJoin) {
        this.joinRemovalSemiJoins[dimIdx] = semiJoin;
    }

    BitSet getJoinFilterFactorBitmap(RexNode joinFilter, boolean setFields) {
        BitSet fieldRefBitmap = this.fieldBitmap(joinFilter);
        if (setFields) {
            this.fieldsRefByJoinFilter.put(joinFilter, fieldRefBitmap);
        }
        return this.factorBitmap(fieldRefBitmap);
    }

    private BitSet fieldBitmap(RexNode joinFilter) {
        BitSet fieldRefBitmap = new BitSet(this.nTotalFields);
        joinFilter.accept(new RelOptUtil.InputFinder(fieldRefBitmap));
        return fieldRefBitmap;
    }

    private void setJoinFilterRefs() {
        this.fieldsRefByJoinFilter = new HashMap<RexNode, BitSet>();
        this.factorsRefByJoinFilter = new HashMap<RexNode, BitSet>();
        ListIterator<RexNode> filterIter = this.allJoinFilters.listIterator();
        while (filterIter.hasNext()) {
            RexNode joinFilter = filterIter.next();
            if (joinFilter.isAlwaysTrue()) {
                filterIter.remove();
            }
            BitSet factorRefBitmap = this.getJoinFilterFactorBitmap(joinFilter, true);
            this.factorsRefByJoinFilter.put(joinFilter, factorRefBitmap);
        }
    }

    private BitSet factorBitmap(BitSet fieldRefBitmap) {
        BitSet factorRefBitmap = new BitSet(this.nJoinFactors);
        for (int field : BitSets.toIter(fieldRefBitmap)) {
            int factor = this.findRef(field);
            factorRefBitmap.set(factor);
        }
        return factorRefBitmap;
    }

    public int findRef(int rexInputRef) {
        for (int i = 0; i < this.nJoinFactors; ++i) {
            if (rexInputRef < this.joinStart[i] || rexInputRef >= this.joinStart[i] + this.nFieldsInJoinFactor[i]) continue;
            return i;
        }
        throw new AssertionError();
    }

    public void setFactorWeights() {
        this.factorWeights = new int[this.nJoinFactors][this.nJoinFactors];
        this.factorsRefByFactor = new BitSet[this.nJoinFactors];
        for (int i = 0; i < this.nJoinFactors; ++i) {
            this.factorsRefByFactor[i] = new BitSet(this.nJoinFactors);
        }
        for (RexNode joinFilter : this.allJoinFilters) {
            BitSet factorRefs = this.factorsRefByJoinFilter.get(joinFilter);
            if (!(joinFilter instanceof RexCall) || !joinFilter.isA(SqlKind.COMPARISON)) continue;
            for (int factor : BitSets.toIter(factorRefs)) {
                this.factorsRefByFactor[factor].or(factorRefs);
                this.factorsRefByFactor[factor].clear(factor);
            }
            if (factorRefs.cardinality() == 2) {
                int weight;
                int leftFactor = factorRefs.nextSetBit(0);
                int rightFactor = factorRefs.nextSetBit(leftFactor + 1);
                RexCall call = (RexCall)joinFilter;
                BitSet leftFields = this.fieldBitmap(call.getOperands().get(0));
                BitSet leftBitmap = this.factorBitmap(leftFields);
                if (leftBitmap.cardinality() == 1) {
                    switch (joinFilter.getKind()) {
                        case EQUALS: {
                            weight = 3;
                            break;
                        }
                        default: {
                            weight = 2;
                            break;
                        }
                    }
                } else {
                    weight = 1;
                }
                this.setFactorWeight(weight, leftFactor, rightFactor);
                continue;
            }
            IntList list = BitSets.toList(factorRefs);
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int outer = (Integer)i$.next();
                Iterator i$2 = list.iterator();
                while (i$2.hasNext()) {
                    int inner = (Integer)i$2.next();
                    if (outer == inner) continue;
                    this.setFactorWeight(1, outer, inner);
                }
            }
        }
    }

    private void setFactorWeight(int weight, int leftFactor, int rightFactor) {
        if (this.factorWeights[leftFactor][rightFactor] < weight) {
            this.factorWeights[leftFactor][rightFactor] = weight;
            this.factorWeights[rightFactor][leftFactor] = weight;
        }
    }

    public boolean hasAllFactors(LoptJoinTree joinTree, BitSet factorsNeeded) {
        return BitSets.contains(BitSets.of(joinTree.getTreeOrder()), factorsNeeded);
    }

    public void getChildFactors(LoptJoinTree joinTree, BitSet childFactors) {
        for (int child : joinTree.getTreeOrder()) {
            childFactors.set(child);
        }
    }

    public List<RelDataTypeField> getJoinFields(LoptJoinTree left, LoptJoinTree right) {
        RelDataType rowType = this.factory.createJoinType(left.getJoinTree().getRowType(), right.getJoinTree().getRowType());
        return rowType.getFieldList();
    }

    public void addRemovableOuterJoinFactor(int factIdx) {
        this.removableOuterJoinFactors.add(factIdx);
    }

    public boolean isRemovableOuterJoinFactor(int factIdx) {
        return this.removableOuterJoinFactors.contains(factIdx);
    }

    public void addRemovableSelfJoinPair(int factor1, int factor2) {
        int rightFactor;
        int leftFactor;
        if (this.getNumFieldsInJoinFactor(factor1) > this.getNumFieldsInJoinFactor(factor2)) {
            leftFactor = factor1;
            rightFactor = factor2;
        } else {
            leftFactor = factor2;
            rightFactor = factor1;
        }
        HashMap<Integer, Integer> columnMapping = new HashMap<Integer, Integer>();
        RelNode left = this.getJoinFactor(leftFactor);
        HashMap<Integer, Integer> leftFactorColMapping = new HashMap<Integer, Integer>();
        for (int i = 0; i < left.getRowType().getFieldCount(); ++i) {
            RelColumnOrigin colOrigin = RelMetadataQuery.getColumnOrigin(left, i);
            if (colOrigin == null) continue;
            leftFactorColMapping.put(colOrigin.getOriginColumnOrdinal(), i);
        }
        RelNode right = this.getJoinFactor(rightFactor);
        for (int i = 0; i < right.getRowType().getFieldCount(); ++i) {
            Integer leftOffset;
            RelColumnOrigin colOrigin = RelMetadataQuery.getColumnOrigin(right, i);
            if (colOrigin == null || (leftOffset = (Integer)leftFactorColMapping.get(colOrigin.getOriginColumnOrdinal())) == null) continue;
            columnMapping.put(i, leftOffset);
        }
        RemovableSelfJoin selfJoin = new RemovableSelfJoin(leftFactor, rightFactor, columnMapping);
        this.removableSelfJoinPairs.put(leftFactor, selfJoin);
        this.removableSelfJoinPairs.put(rightFactor, selfJoin);
    }

    public Integer getOtherSelfJoinFactor(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return null;
        }
        if (selfJoin.getRightFactor() == factIdx) {
            return selfJoin.getLeftFactor();
        }
        return selfJoin.getRightFactor();
    }

    public boolean isLeftFactorInRemovableSelfJoin(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return false;
        }
        return selfJoin.getLeftFactor() == factIdx;
    }

    public boolean isRightFactorInRemovableSelfJoin(int factIdx) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(factIdx);
        if (selfJoin == null) {
            return false;
        }
        return selfJoin.getRightFactor() == factIdx;
    }

    public Integer getRightColumnMapping(int rightFactor, int rightOffset) {
        RemovableSelfJoin selfJoin = this.removableSelfJoinPairs.get(rightFactor);
        assert (selfJoin.getRightFactor() == rightFactor);
        return selfJoin.getColumnMapping().get(rightOffset);
    }

    public Edge createEdge(RexNode condition) {
        BitSet fieldRefBitmap = this.fieldBitmap(condition);
        BitSet factorRefBitmap = this.factorBitmap(fieldRefBitmap);
        return new Edge(condition, factorRefBitmap, fieldRefBitmap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemovableSelfJoin {
        private int leftFactor;
        private int rightFactor;
        private Map<Integer, Integer> columnMapping;

        RemovableSelfJoin(int leftFactor, int rightFactor, Map<Integer, Integer> columnMapping) {
            this.leftFactor = leftFactor;
            this.rightFactor = rightFactor;
            this.columnMapping = columnMapping;
        }

        public int getLeftFactor() {
            return this.leftFactor;
        }

        public int getRightFactor() {
            return this.rightFactor;
        }

        public Map<Integer, Integer> getColumnMapping() {
            return this.columnMapping;
        }
    }

    static class Edge {
        final BitSet factors;
        final BitSet columns;
        final RexNode condition;

        Edge(RexNode condition, BitSet factors, BitSet columns) {
            this.condition = condition;
            this.factors = factors;
            this.columns = columns;
        }

        public String toString() {
            return "Edge(condition: " + this.condition + ", factors: " + this.factors + ", columns: " + this.columns + ")";
        }
    }
}

