/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.rex.RexUtil;

public class MergeFilterRule
extends RelOptRule {
    public static final MergeFilterRule INSTANCE = new MergeFilterRule(RelFactories.DEFAULT_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public MergeFilterRule(RelFactories.FilterFactory filterFactory) {
        super(MergeFilterRule.operand(FilterRelBase.class, MergeFilterRule.operand(FilterRelBase.class, MergeFilterRule.any()), new RelOptRuleOperand[0]));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        FilterRelBase topFilter = (FilterRelBase)call.rel(0);
        FilterRelBase bottomFilter = (FilterRelBase)call.rel(1);
        RexBuilder rexBuilder = topFilter.getCluster().getRexBuilder();
        RexProgram bottomProgram = this.createProgram(bottomFilter);
        RexProgram topProgram = this.createProgram(topFilter);
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        RexNode newCondition = mergedProgram.expandLocalRef(mergedProgram.getCondition());
        FilterRelBase newFilterRel = (FilterRelBase)this.filterFactory.createFilter(bottomFilter.getChild(), RexUtil.flatten(rexBuilder, newCondition));
        call.transformTo(newFilterRel);
    }

    private RexProgram createProgram(FilterRelBase filterRel) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(filterRel.getRowType(), filterRel.getCluster().getRexBuilder());
        programBuilder.addIdentity();
        programBuilder.addCondition(filterRel.getCondition());
        return programBuilder.getProgram();
    }
}

