/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.util.Permutation;

public class MergeProjectRule
extends RelOptRule {
    public static final MergeProjectRule INSTANCE = new MergeProjectRule();
    private final boolean force;
    private final RelFactories.ProjectFactory projectFactory;

    private MergeProjectRule() {
        this(false, RelFactories.DEFAULT_PROJECT_FACTORY);
    }

    public MergeProjectRule(boolean force, RelFactories.ProjectFactory pFactory) {
        super(MergeProjectRule.operand(ProjectRelBase.class, MergeProjectRule.operand(ProjectRelBase.class, MergeProjectRule.any()), new RelOptRuleOperand[0]), "MergeProjectRule" + (force ? ": force mode" : ""));
        this.force = force;
        this.projectFactory = pFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectRelBase topProject = (ProjectRelBase)call.rel(0);
        ProjectRelBase bottomProject = (ProjectRelBase)call.rel(1);
        RexBuilder rexBuilder = topProject.getCluster().getRexBuilder();
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                call.transformTo(RelOptUtil.projectMapping(bottomProject.getChild(), product.inverse(), topProject.getRowType().getFieldNames(), this.projectFactory));
                return;
            }
        }
        if (!this.force && RelOptUtil.checkProjAndChildInputs(topProject, false)) {
            return;
        }
        RexProgram bottomProgram = RexProgram.create(bottomProject.getChild().getRowType(), bottomProject.getProjects(), null, bottomProject.getRowType(), rexBuilder);
        List<RexNode> projExprs = topProject.getProjects();
        RexProgram topProgram = RexProgram.create(bottomProject.getRowType(), projExprs, null, topProject.getRowType(), rexBuilder);
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        int nProjExprs = projExprs.size();
        ArrayList<RexNode> newProjExprs = new ArrayList<RexNode>();
        List<RexLocalRef> projList = mergedProgram.getProjectList();
        for (int i = 0; i < nProjExprs; ++i) {
            newProjExprs.add(mergedProgram.expandLocalRef(projList.get(i)));
        }
        RelNode newProjectRel = this.projectFactory.createProject(bottomProject.getChild(), newProjExprs, topProject.getRowType().getFieldNames());
        call.transformTo(newProjectRel);
    }
}

