/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.ProjectableFilterableTable;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.JavaRules;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexShuttle;

public abstract class ProjectTableRule
extends RelOptRule {
    private static final Predicate<TableAccessRelBase> PREDICATE = new Predicate<TableAccessRelBase>(){

        public boolean apply(TableAccessRelBase scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final ProjectTableRule INSTANCE = new ProjectTableRule(ProjectTableRule.operand(ProjectRelBase.class, ProjectTableRule.operand(JavaRules.EnumerableInterpreterRel.class, ProjectTableRule.operand(TableAccessRelBase.class, null, PREDICATE, ProjectTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "ProjectTableRule:basic"){

        public void onMatch(RelOptRuleCall call) {
            ProjectRelBase project = (ProjectRelBase)call.rel(0);
            JavaRules.EnumerableInterpreterRel interpreter = (JavaRules.EnumerableInterpreterRel)call.rel(1);
            TableAccessRelBase scan = (TableAccessRelBase)call.rel(2);
            RelOptTable table = scan.getTable();
            assert (table.unwrap(ProjectableFilterableTable.class) != null);
            this.apply(call, project, null, interpreter);
        }
    };
    public static final ProjectTableRule INSTANCE2 = new ProjectTableRule(ProjectTableRule.operand(ProjectRelBase.class, ProjectTableRule.operand(FilterRelBase.class, ProjectTableRule.operand(JavaRules.EnumerableInterpreterRel.class, ProjectTableRule.operand(TableAccessRelBase.class, null, PREDICATE, ProjectTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "ProjectTableRule:filter"){

        public void onMatch(RelOptRuleCall call) {
            ProjectRelBase project = (ProjectRelBase)call.rel(0);
            FilterRelBase filter = (FilterRelBase)call.rel(1);
            JavaRules.EnumerableInterpreterRel interpreter = (JavaRules.EnumerableInterpreterRel)call.rel(2);
            TableAccessRelBase scan = (TableAccessRelBase)call.rel(3);
            RelOptTable table = scan.getTable();
            assert (table.unwrap(ProjectableFilterableTable.class) != null);
            this.apply(call, project, filter, interpreter);
        }
    };

    private ProjectTableRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected void apply(RelOptRuleCall call, ProjectRelBase project, FilterRelBase filter, JavaRules.EnumerableInterpreterRel interpreter) {
        ArrayList extraProjects;
        final RexBuilder rexBuilder = project.getCluster().getRexBuilder();
        RexProgram program = RexProgram.create(interpreter.getRowType(), project.getProjects(), null, project.getRowType(), rexBuilder);
        final ArrayList projectOrdinals = Lists.newArrayList();
        if (program.getExprList().size() == program.getInputRowType().getFieldCount()) {
            for (RexLocalRef ref : program.getProjectList()) {
                projectOrdinals.add(ref.getIndex());
            }
            extraProjects = null;
        } else {
            extraProjects = Lists.newArrayList();
            RexShuttle shuttle = new RexShuttle(){
                final List<RexInputRef> inputRefs = Lists.newArrayList();

                public RexNode visitInputRef(RexInputRef inputRef) {
                    RexInputRef ref;
                    int source = inputRef.getIndex();
                    int target = projectOrdinals.indexOf(source);
                    if (target < 0) {
                        target = projectOrdinals.size();
                        projectOrdinals.add(source);
                        ref = rexBuilder.makeInputRef(inputRef.getType(), target);
                        this.inputRefs.add(ref);
                    } else {
                        ref = this.inputRefs.get(target);
                    }
                    return ref;
                }
            };
            for (RexNode node : project.getProjects()) {
                extraProjects.add(node.accept(shuttle));
            }
        }
        RelNode input = interpreter.getChild();
        if (filter != null) {
            input = RelOptUtil.createFilter(input, filter.getCondition(), EnumerableRel.FILTER_FACTORY);
        }
        RelNode newProject = RelOptUtil.createProject(EnumerableRel.PROJECT_FACTORY, input, projectOrdinals);
        JavaRules.EnumerableInterpreterRel newInterpreter = new JavaRules.EnumerableInterpreterRel(interpreter.getCluster(), interpreter.getTraitSet(), newProject, 0.15);
        RelNode residue = extraProjects != null ? RelOptUtil.createProject((RelNode)newInterpreter, extraProjects, project.getRowType().getFieldNames()) : newInterpreter;
        call.transformTo(residue);
    }
}

