/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.EquiJoinRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PushFilterPastJoinRule
extends RelOptRule {
    public static final PushFilterPastJoinRule FILTER_ON_JOIN = new PushFilterIntoJoinRule(true);
    public static final PushFilterPastJoinRule DUMB_FILTER_ON_JOIN = new PushFilterIntoJoinRule(false);
    public static final PushFilterPastJoinRule JOIN = new PushDownJoinConditionRule(RelFactories.DEFAULT_FILTER_FACTORY, RelFactories.DEFAULT_PROJECT_FACTORY);
    private final boolean smart;
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;

    protected PushFilterPastJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
        super(operand, "PushFilterRule: " + id);
        this.smart = smart;
        this.filterFactory = filterFactory;
        this.projectFactory = projectFactory;
    }

    protected void perform(RelOptRuleCall call, FilterRelBase filter, JoinRelBase join) {
        List<RexNode> joinFilters = RelOptUtil.conjunctions(join.getCondition());
        ImmutableList origJoinFilters = ImmutableList.copyOf(joinFilters);
        if (filter == null && joinFilters.isEmpty()) {
            return;
        }
        ArrayList aboveFilters = filter != null ? RelOptUtil.conjunctions(filter.getCondition()) : Lists.newArrayList();
        ImmutableList origAboveFilters = ImmutableList.copyOf((Collection)aboveFilters);
        JoinRelType joinType = join.getJoinType();
        if (this.smart && !origAboveFilters.isEmpty() && join.getJoinType() != JoinRelType.INNER) {
            joinType = RelOptUtil.simplifyJoin(join, (ImmutableList<RexNode>)origAboveFilters, joinType);
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        boolean filterPushed = false;
        if (RelOptUtil.classifyFilters(join, aboveFilters, joinType, !(join instanceof EquiJoinRel), !joinType.generatesNullsOnLeft(), !joinType.generatesNullsOnRight(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        this.validateJoinFilters(aboveFilters, joinFilters, join, joinType);
        if (leftFilters.isEmpty() && rightFilters.isEmpty() && joinFilters.size() == origJoinFilters.size() && Sets.newHashSet(joinFilters).equals(Sets.newHashSet((Iterable)origJoinFilters))) {
            filterPushed = false;
        }
        if (RelOptUtil.classifyFilters(join, joinFilters, joinType, false, !joinType.generatesNullsOnRight(), !joinType.generatesNullsOnLeft(), joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        if (!filterPushed && joinType == join.getJoinType() || joinFilters.isEmpty() && leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelNode leftRel = RelOptUtil.createFilter(join.getLeft(), leftFilters, this.filterFactory);
        RelNode rightRel = RelOptUtil.createFilter(join.getRight(), rightFilters, this.filterFactory);
        RexNode joinFilter = RexUtil.composeConjunction(rexBuilder, joinFilters, false);
        if (joinFilter.isAlwaysTrue() && leftFilters.isEmpty() && rightFilters.isEmpty() && joinType == join.getJoinType()) {
            return;
        }
        RelNode newJoinRel = join.copy(join.getCluster().traitSetOf(Convention.NONE), joinFilter, leftRel, rightRel, joinType, join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newJoinRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, rightRel);
        }
        newJoinRel = RelOptUtil.createCastRel(newJoinRel, join.getRowType(), false, this.projectFactory);
        RelNode newRel = RelOptUtil.createFilter(newJoinRel, aboveFilters, this.filterFactory);
        call.transformTo(newRel);
    }

    protected void validateJoinFilters(List<RexNode> aboveFilters, List<RexNode> joinFilters, JoinRelBase join) {
        this.validateJoinFilters(aboveFilters, joinFilters, join, join.getJoinType());
    }

    protected void validateJoinFilters(List<RexNode> aboveFilters, List<RexNode> joinFilters, JoinRelBase join, JoinRelType joinType) {
    }

    public static class PushFilterIntoJoinRule
    extends PushFilterPastJoinRule {
        public PushFilterIntoJoinRule(boolean smart) {
            this(smart, RelFactories.DEFAULT_FILTER_FACTORY, RelFactories.DEFAULT_PROJECT_FACTORY);
        }

        public PushFilterIntoJoinRule(boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
            super(RelOptRule.operand(FilterRelBase.class, RelOptRule.operand(JoinRelBase.class, RelOptRule.any()), new RelOptRuleOperand[0]), "PushFilterPastJoinRule:filter", smart, filterFactory, projectFactory);
        }

        public void onMatch(RelOptRuleCall call) {
            FilterRelBase filter = (FilterRelBase)call.rel(0);
            JoinRelBase join = (JoinRelBase)call.rel(1);
            this.perform(call, filter, join);
        }
    }

    public static class PushDownJoinConditionRule
    extends PushFilterPastJoinRule {
        public PushDownJoinConditionRule(RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
            super(RelOptRule.operand(JoinRelBase.class, RelOptRule.any()), "PushFilterPastJoinRule:no-filter", true, filterFactory, projectFactory);
        }

        public void onMatch(RelOptRuleCall call) {
            JoinRelBase join = (JoinRelBase)call.rel(0);
            this.perform(call, null, join);
        }
    }
}

