/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexPermuteInputsShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushJoinThroughJoinRule
extends RelOptRule {
    public static final RelOptRule RIGHT = new PushJoinThroughJoinRule("PushJoinThroughJoinRule:right", true, JoinRel.class, RelFactories.DEFAULT_PROJECT_FACTORY);
    public static final RelOptRule LEFT = new PushJoinThroughJoinRule("PushJoinThroughJoinRule:left", false, JoinRel.class, RelFactories.DEFAULT_PROJECT_FACTORY);
    private final boolean right;
    private final RelFactories.ProjectFactory projectFactory;

    public PushJoinThroughJoinRule(String description, boolean right, Class<? extends JoinRelBase> clazz, RelFactories.ProjectFactory projectFactory) {
        super(PushJoinThroughJoinRule.operand(clazz, PushJoinThroughJoinRule.operand(clazz, PushJoinThroughJoinRule.any()), PushJoinThroughJoinRule.operand(RelNode.class, PushJoinThroughJoinRule.any())), description);
        this.right = right;
        this.projectFactory = projectFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (this.right) {
            this.onMatchRight(call);
        } else {
            this.onMatchLeft(call);
        }
    }

    private void onMatchRight(RelOptRuleCall call) {
        JoinRelBase topJoin = (JoinRelBase)call.rel(0);
        JoinRelBase bottomJoin = (JoinRelBase)call.rel(1);
        Object relC = call.rel(2);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        BitSet bBitSet = BitSets.range(aCount, aCount + bCount);
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        PushJoinThroughJoinRule.split(topJoin.getCondition(), bBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        PushJoinThroughJoinRule.split(bottomJoin.getCondition(), bBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount, aCount + bCount, cCount);
        ArrayList<RexNode> newBottomList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(nonIntersecting, newBottomList);
        Mappings.TargetMapping bottomBottomMapping = Mappings.createShiftMapping(aCount + bCount, 0, 0, aCount);
        new RexPermuteInputsShuttle(bottomBottomMapping, new RelNode[]{relA, relC}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        JoinRelBase newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relA, (RelNode)relC, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList<RexNode> newTopList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        JoinRelBase newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relB, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        assert (!Mappings.isIdentity(topMapping));
        RelNode newProject = RelOptUtil.createProject(this.projectFactory, newTopJoin, Mappings.asList(topMapping));
        call.transformTo(newProject);
    }

    private void onMatchLeft(RelOptRuleCall call) {
        JoinRelBase topJoin = (JoinRelBase)call.rel(0);
        JoinRelBase bottomJoin = (JoinRelBase)call.rel(1);
        Object relC = call.rel(2);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        BitSet aBitSet = BitSets.range(aCount);
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        PushJoinThroughJoinRule.split(topJoin.getCondition(), aBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        PushJoinThroughJoinRule.split(bottomJoin.getCondition(), aBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, cCount, aCount, bCount, 0, aCount + bCount, cCount);
        ArrayList<RexNode> newBottomList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relC, relB}).visitList(nonIntersecting, newBottomList);
        Mappings.TargetMapping bottomBottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, aCount + bCount, cCount, cCount, aCount, bCount);
        new RexPermuteInputsShuttle(bottomBottomMapping, new RelNode[]{relC, relB}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        JoinRelBase newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, (RelNode)relC, relB, bottomJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, cCount + bCount, 0, aCount, cCount, aCount, bCount, 0, aCount + bCount, cCount);
        ArrayList<RexNode> newTopList = new ArrayList<RexNode>();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relA).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relA).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        JoinRelBase newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relA, topJoin.getJoinType(), topJoin.isSemiJoinDone());
        RelNode newProject = RelOptUtil.createProject(this.projectFactory, newTopJoin, Mappings.asList(topMapping));
        call.transformTo(newProject);
    }

    static void split(RexNode condition, BitSet bitSet, List<RexNode> intersecting, List<RexNode> nonIntersecting) {
        for (RexNode node : RelOptUtil.conjunctions(condition)) {
            BitSet inputBitSet = RelOptUtil.InputFinder.bits(node);
            if (bitSet.intersects(inputBitSet)) {
                intersecting.add(node);
                continue;
            }
            nonIntersecting.add(node);
        }
    }
}

