/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SetOpRel;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;

public class PushJoinThroughUnionRule
extends RelOptRule {
    public static final PushJoinThroughUnionRule LEFT_UNION = new PushJoinThroughUnionRule(PushJoinThroughUnionRule.operand(JoinRelBase.class, PushJoinThroughUnionRule.operand(UnionRelBase.class, PushJoinThroughUnionRule.any()), PushJoinThroughUnionRule.operand(RelNode.class, PushJoinThroughUnionRule.any())), "union on left");
    public static final PushJoinThroughUnionRule RIGHT_UNION = new PushJoinThroughUnionRule(PushJoinThroughUnionRule.operand(JoinRelBase.class, PushJoinThroughUnionRule.operand(RelNode.class, PushJoinThroughUnionRule.any()), PushJoinThroughUnionRule.operand(UnionRelBase.class, PushJoinThroughUnionRule.any())), "union on right");

    private PushJoinThroughUnionRule(RelOptRuleOperand operand, String id) {
        super(operand, "PushJoinThroughUnionRule: " + id);
    }

    public void onMatch(RelOptRuleCall call) {
        boolean unionOnLeft;
        Object otherInput;
        UnionRelBase unionRel;
        JoinRelBase join = (JoinRelBase)call.rel(0);
        if (call.rel(1) instanceof UnionRel) {
            unionRel = (UnionRelBase)call.rel(1);
            otherInput = call.rel(2);
            unionOnLeft = true;
        } else {
            otherInput = call.rel(1);
            unionRel = (UnionRelBase)call.rel(2);
            unionOnLeft = false;
        }
        if (!unionRel.all) {
            return;
        }
        if (!join.getVariablesStopped().isEmpty()) {
            return;
        }
        if (unionOnLeft ? join.getJoinType().generatesNullsOnLeft() : join.getJoinType().generatesNullsOnRight()) {
            return;
        }
        ArrayList<RelNode> newUnionInputs = new ArrayList<RelNode>();
        for (RelNode input : unionRel.getInputs()) {
            Object joinRight;
            RelNode joinLeft;
            if (unionOnLeft) {
                joinLeft = input;
                joinRight = otherInput;
            } else {
                joinLeft = otherInput;
                joinRight = input;
            }
            newUnionInputs.add(join.copy(join.getTraitSet(), join.getCondition(), joinLeft, (RelNode)joinRight, join.getJoinType(), join.isSemiJoinDone()));
        }
        SetOpRel newUnionRel = unionRel.copy(unionRel.getTraitSet(), newUnionInputs, true);
        call.transformTo(newUnionRel);
    }
}

