/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SetOpRel;
import org.eigenbase.rel.rules.PushProjector;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;

public class PushProjectPastSetOpRule
extends RelOptRule {
    public static final PushProjectPastSetOpRule INSTANCE = new PushProjectPastSetOpRule(PushProjector.ExprCondition.FALSE);
    private PushProjector.ExprCondition preserveExprCondition;

    public PushProjectPastSetOpRule(PushProjector.ExprCondition preserveExprCondition) {
        super(PushProjectPastSetOpRule.operand(ProjectRel.class, PushProjectPastSetOpRule.operand(SetOpRel.class, PushProjectPastSetOpRule.any()), new RelOptRuleOperand[0]));
        this.preserveExprCondition = preserveExprCondition;
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectRel origProj = (ProjectRel)call.rel(0);
        SetOpRel setOpRel = (SetOpRel)call.rel(1);
        if (!setOpRel.all) {
            return;
        }
        PushProjector pushProject = new PushProjector(origProj, null, setOpRel, this.preserveExprCondition);
        pushProject.locateAllRefs();
        ArrayList<RelNode> newSetOpInputs = new ArrayList<RelNode>();
        int[] adjustments = pushProject.getAdjustments();
        for (RelNode input : setOpRel.getInputs()) {
            ProjectRel p = pushProject.createProjectRefsAndExprs(input, true, false);
            newSetOpInputs.add(pushProject.createNewProject(p, adjustments));
        }
        RelNode newSetOpRel = setOpRel.copy(setOpRel.getTraitSet(), newSetOpInputs);
        call.transformTo(newSetOpRel);
    }
}

