/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlAvgAggFunction;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.fun.SqlSumAggFunction;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.CompositeList;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReduceAggregatesRule
extends RelOptRule {
    public static final ReduceAggregatesRule INSTANCE = new ReduceAggregatesRule(ReduceAggregatesRule.operand(AggregateRel.class, ReduceAggregatesRule.any()));

    protected ReduceAggregatesRule(RelOptRuleOperand operand) {
        super(operand);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        if (!super.matches(call)) {
            return false;
        }
        AggregateRelBase oldAggRel = (AggregateRelBase)call.rels[0];
        return this.containsAvgStddevVarCall(oldAggRel.getAggCallList());
    }

    @Override
    public void onMatch(RelOptRuleCall ruleCall) {
        AggregateRelBase oldAggRel = (AggregateRelBase)ruleCall.rels[0];
        this.reduceAggs(ruleCall, oldAggRel);
    }

    private boolean containsAvgStddevVarCall(List<AggregateCall> aggCallList) {
        for (AggregateCall call : aggCallList) {
            if (!(call.getAggregation() instanceof SqlAvgAggFunction) && !(call.getAggregation() instanceof SqlSumAggFunction)) continue;
            return true;
        }
        return false;
    }

    private void reduceAggs(RelOptRuleCall ruleCall, AggregateRelBase oldAggRel) {
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        List<AggregateCall> oldCalls = oldAggRel.getAggCallList();
        int nGroups = oldAggRel.getGroupCount();
        ArrayList<AggregateCall> newCalls = new ArrayList<AggregateCall>();
        HashMap<AggregateCall, RexNode> aggCallMapping = new HashMap<AggregateCall, RexNode>();
        ArrayList<RexNode> projList = new ArrayList<RexNode>();
        for (int i = 0; i < nGroups; ++i) {
            projList.add(rexBuilder.makeInputRef(this.getFieldType(oldAggRel, i), i));
        }
        RelNode input = oldAggRel.getChild();
        ArrayList<RexNode> inputExprs = new ArrayList<RexNode>();
        for (RelDataTypeField field : input.getRowType().getFieldList()) {
            inputExprs.add(rexBuilder.makeInputRef(field.getType(), inputExprs.size()));
        }
        for (AggregateCall oldCall : oldCalls) {
            projList.add(this.reduceAgg(oldAggRel, oldCall, newCalls, aggCallMapping, inputExprs));
        }
        int extraArgCount = inputExprs.size() - input.getRowType().getFieldCount();
        if (extraArgCount > 0) {
            input = RelOptUtil.createProject(input, inputExprs, CompositeList.of(input.getRowType().getFieldNames(), Collections.nCopies(extraArgCount, null)));
        }
        AggregateRelBase newAggRel = this.newAggregateRel(oldAggRel, input, newCalls);
        RelNode projectRel = RelOptUtil.createProject((RelNode)newAggRel, projList, oldAggRel.getRowType().getFieldNames());
        ruleCall.transformTo(projectRel);
        ruleCall.getPlanner().setImportance(oldAggRel, 0.0);
    }

    private RexNode reduceAgg(AggregateRelBase oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        if (oldCall.getAggregation() instanceof SqlSumAggFunction) {
            return this.reduceSum(oldAggRel, oldCall, newCalls, aggCallMapping);
        }
        if (oldCall.getAggregation() instanceof SqlAvgAggFunction) {
            SqlAvgAggFunction.Subtype subtype = ((SqlAvgAggFunction)oldCall.getAggregation()).getSubtype();
            switch (subtype) {
                case AVG: {
                    return this.reduceAvg(oldAggRel, oldCall, newCalls, aggCallMapping);
                }
                case STDDEV_POP: {
                    return this.reduceStddev(oldAggRel, oldCall, true, true, newCalls, aggCallMapping, inputExprs);
                }
                case STDDEV_SAMP: {
                    return this.reduceStddev(oldAggRel, oldCall, false, true, newCalls, aggCallMapping, inputExprs);
                }
                case VAR_POP: {
                    return this.reduceStddev(oldAggRel, oldCall, true, false, newCalls, aggCallMapping, inputExprs);
                }
                case VAR_SAMP: {
                    return this.reduceStddev(oldAggRel, oldCall, false, false, newCalls, aggCallMapping, inputExprs);
                }
            }
            throw Util.unexpected(subtype);
        }
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int nGroups = oldAggRel.getGroupCount();
        List<RelDataType> oldArgTypes = SqlTypeUtil.projectTypes(oldAggRel.getRowType(), oldCall.getArgList());
        return rexBuilder.addAggCall(oldCall, nGroups, newCalls, aggCallMapping, oldArgTypes);
    }

    private RexNode reduceAvg(AggregateRelBase oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping) {
        RelDataType avgInputType;
        int nGroups = oldAggRel.getGroupCount();
        RelDataTypeFactory typeFactory = oldAggRel.getCluster().getTypeFactory();
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int iAvgInput = oldCall.getArgList().get(0);
        RelDataType sumType = typeFactory.createTypeWithNullability(avgInputType, (avgInputType = this.getFieldType(oldAggRel.getChild(), iAvgInput)).isNullable() || nGroups == 0);
        SqlSumAggFunction sumAgg = new SqlSumAggFunction(sumType);
        AggregateCall sumCall = new AggregateCall(sumAgg, oldCall.isDistinct(), oldCall.getArgList(), sumType, null);
        AggregateCall countCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.getArgList(), oldAggRel.getGroupCount(), oldAggRel.getChild(), null, null);
        RexNode numeratorRef = rexBuilder.addAggCall(sumCall, nGroups, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)avgInputType));
        RexNode denominatorRef = rexBuilder.addAggCall(countCall, nGroups, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)avgInputType));
        RexNode divideRef = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, numeratorRef, denominatorRef);
        return rexBuilder.makeCast(oldCall.getType(), divideRef);
    }

    private RexNode reduceSum(AggregateRelBase oldAggRel, AggregateCall oldCall, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping) {
        int nGroups = oldAggRel.getGroupCount();
        RelDataTypeFactory typeFactory = oldAggRel.getCluster().getTypeFactory();
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        int arg = oldCall.getArgList().get(0);
        RelDataType argType = this.getFieldType(oldAggRel.getChild(), arg);
        RelDataType sumType = typeFactory.createTypeWithNullability(argType, argType.isNullable());
        AggregateCall sumZeroCall = new AggregateCall(SqlStdOperatorTable.SUM0, oldCall.isDistinct(), oldCall.getArgList(), sumType, null);
        AggregateCall countCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.getArgList(), oldAggRel.getGroupCount(), oldAggRel, null, null);
        RexNode sumZeroRef = rexBuilder.addAggCall(sumZeroCall, nGroups, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        if (!oldCall.getType().isNullable()) {
            return sumZeroRef;
        }
        RexNode countRef = rexBuilder.addAggCall(countCall, nGroups, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countRef, rexBuilder.makeExactLiteral(BigDecimal.ZERO)), rexBuilder.constantNull(), sumZeroRef);
    }

    private RexNode reduceStddev(AggregateRelBase oldAggRel, AggregateCall oldCall, boolean biased, boolean sqrt, List<AggregateCall> newCalls, Map<AggregateCall, RexNode> aggCallMapping, List<RexNode> inputExprs) {
        RexNode div;
        RexNode denominator;
        int nGroups = oldAggRel.getGroupCount();
        RelDataTypeFactory typeFactory = oldAggRel.getCluster().getTypeFactory();
        RexBuilder rexBuilder = oldAggRel.getCluster().getRexBuilder();
        assert (oldCall.getArgList().size() == 1) : oldCall.getArgList();
        int argOrdinal = oldCall.getArgList().get(0);
        RelDataType argType = this.getFieldType(oldAggRel.getChild(), argOrdinal);
        RexNode argRef = inputExprs.get(argOrdinal);
        RexNode argSquared = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, argRef, argRef);
        int argSquaredOrdinal = ReduceAggregatesRule.lookupOrAdd(inputExprs, argSquared);
        RelDataType sumType = typeFactory.createTypeWithNullability(argType, true);
        AggregateCall sumArgSquaredAggCall = new AggregateCall(new SqlSumAggFunction(sumType), oldCall.isDistinct(), ImmutableIntList.of(argSquaredOrdinal), sumType, null);
        RexNode sumArgSquared = rexBuilder.addAggCall(sumArgSquaredAggCall, nGroups, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        AggregateCall sumArgAggCall = new AggregateCall(new SqlSumAggFunction(sumType), oldCall.isDistinct(), ImmutableIntList.of(argOrdinal), sumType, null);
        RexNode sumArg = rexBuilder.addAggCall(sumArgAggCall, nGroups, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        RexNode sumSquaredArg = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, sumArg, sumArg);
        AggregateCall countArgAggCall = AggregateCall.create(SqlStdOperatorTable.COUNT, oldCall.isDistinct(), oldCall.getArgList(), oldAggRel.getGroupCount(), oldAggRel.getChild(), null, null);
        RexNode countArg = rexBuilder.addAggCall(countArgAggCall, nGroups, newCalls, aggCallMapping, (List<RelDataType>)ImmutableList.of((Object)argType));
        RexNode avgSumSquaredArg = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, sumSquaredArg, countArg);
        RexNode diff = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, sumArgSquared, avgSumSquaredArg);
        if (biased) {
            denominator = countArg;
        } else {
            RexLiteral one = rexBuilder.makeExactLiteral(BigDecimal.ONE);
            RexNode nul = rexBuilder.makeNullLiteral(countArg.getType().getSqlTypeName());
            RexNode countMinusOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, countArg, one);
            RexNode countEqOne = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, countArg, one);
            denominator = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, countEqOne, nul, countMinusOne);
        }
        RexNode result = div = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE, diff, denominator);
        if (sqrt) {
            RexLiteral half = rexBuilder.makeExactLiteral(new BigDecimal("0.5"));
            result = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.POWER, div, half);
        }
        return rexBuilder.makeCast(oldCall.getType(), result);
    }

    private static <T> int lookupOrAdd(List<T> list, T element) {
        int ordinal = list.indexOf(element);
        if (ordinal == -1) {
            ordinal = list.size();
            list.add(element);
        }
        return ordinal;
    }

    protected AggregateRelBase newAggregateRel(AggregateRelBase oldAggRel, RelNode inputRel, List<AggregateCall> newCalls) {
        return new AggregateRel(oldAggRel.getCluster(), inputRel, oldAggRel.getGroupSet(), newCalls);
    }

    private RelDataType getFieldType(RelNode relNode, int i) {
        RelDataTypeField inputField = relNode.getRowType().getFieldList().get(i);
        return inputField.getType();
    }
}

