/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.EmptyRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexDynamicParam;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.rex.RexRangeRef;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlRowOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Stacks;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReduceExpressionsRule
extends RelOptRule {
    public static final Pattern EXCLUSION_PATTERN = Pattern.compile("Reduce(Expressions|Values)Rule.*");
    public static final ReduceExpressionsRule FILTER_INSTANCE = new ReduceExpressionsRule(FilterRel.class, "ReduceExpressionsRule[Filter]"){

        public void onMatch(RelOptRuleCall call) {
            boolean reduced;
            RexNode newConditionExp;
            ArrayList<RexNode> expList;
            FilterRel filter = (FilterRel)call.rel(0);
            if (1.reduceExpressions(filter, expList = new ArrayList<RexNode>(filter.getChildExps()))) {
                assert (expList.size() == 1);
                newConditionExp = (RexNode)expList.get(0);
                reduced = true;
            } else {
                newConditionExp = filter.getChildExps().get(0);
                reduced = false;
            }
            if (newConditionExp.isAlwaysTrue()) {
                call.transformTo(filter.getChild());
            } else if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral(newConditionExp, true)) {
                call.transformTo(new EmptyRel(filter.getCluster(), filter.getRowType()));
            } else if (reduced) {
                call.transformTo(RelOptUtil.createFilter(filter.getChild(), (RexNode)expList.get(0)));
            } else {
                if (newConditionExp instanceof RexCall) {
                    boolean reverse;
                    RexCall rexCall = (RexCall)newConditionExp;
                    boolean bl = reverse = rexCall.getOperator() == SqlStdOperatorTable.NOT;
                    if (reverse) {
                        rexCall = (RexCall)rexCall.getOperands().get(0);
                    }
                    this.reduceNotNullableFilter(call, filter, rexCall, reverse);
                }
                return;
            }
            call.getPlanner().setImportance(filter, 0.0);
        }

        private void reduceNotNullableFilter(RelOptRuleCall call, FilterRel filter, RexCall rexCall, boolean reverse) {
            RexInputRef inputRef;
            RexNode operand;
            boolean alwaysTrue;
            SqlOperator op = rexCall.getOperator();
            switch (rexCall.getKind()) {
                case IS_NULL: 
                case IS_UNKNOWN: {
                    alwaysTrue = false;
                    break;
                }
                case IS_NOT_NULL: {
                    alwaysTrue = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (reverse) {
                boolean bl = alwaysTrue = !alwaysTrue;
            }
            if ((operand = rexCall.getOperands().get(0)) instanceof RexInputRef && !(inputRef = (RexInputRef)operand).getType().isNullable()) {
                if (alwaysTrue) {
                    call.transformTo(filter.getChild());
                } else {
                    call.transformTo(new EmptyRel(filter.getCluster(), filter.getRowType()));
                }
            }
        }
    };
    public static final ReduceExpressionsRule PROJECT_INSTANCE = new ReduceExpressionsRule(ProjectRel.class, "ReduceExpressionsRule[Project]"){

        public void onMatch(RelOptRuleCall call) {
            ArrayList<RexNode> expList;
            ProjectRel project = (ProjectRel)call.rel(0);
            if (2.reduceExpressions(project, expList = new ArrayList<RexNode>(project.getChildExps()))) {
                call.transformTo(new ProjectRel(project.getCluster(), project.getTraitSet(), project.getChild(), expList, project.getRowType(), 1));
                call.getPlanner().setImportance(project, 0.0);
            }
        }
    };
    public static final ReduceExpressionsRule JOIN_INSTANCE = new ReduceExpressionsRule(JoinRelBase.class, "ReduceExpressionsRule[Join]"){

        public void onMatch(RelOptRuleCall call) {
            ArrayList<RexNode> expList;
            JoinRelBase join = (JoinRelBase)call.rel(0);
            if (3.reduceExpressions(join, expList = new ArrayList<RexNode>(join.getChildExps()))) {
                call.transformTo(join.copy(join.getTraitSet(), (RexNode)expList.get(0), join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone()));
                call.getPlanner().setImportance(join, 0.0);
            }
        }
    };
    public static final ReduceExpressionsRule CALC_INSTANCE = new ReduceExpressionsRule(CalcRel.class, "ReduceExpressionsRule[Calc]"){

        public void onMatch(RelOptRuleCall call) {
            CalcRel calc = (CalcRel)call.rel(0);
            RexProgram program = calc.getProgram();
            List<RexNode> exprList = program.getExprList();
            final ArrayList<RexNode> expandedExprList = new ArrayList<RexNode>(exprList.size());
            RexShuttle shuttle = new RexShuttle(){

                public RexNode visitLocalRef(RexLocalRef localRef) {
                    return (RexNode)expandedExprList.get(localRef.getIndex());
                }
            };
            for (RexNode expr : exprList) {
                expandedExprList.add(expr.accept(shuttle));
            }
            if (4.reduceExpressions(calc, expandedExprList)) {
                int conditionIndex;
                RexNode newConditionExp;
                RexProgramBuilder builder = new RexProgramBuilder(calc.getChild().getRowType(), calc.getCluster().getRexBuilder());
                ArrayList<RexLocalRef> list = new ArrayList<RexLocalRef>();
                for (RexNode expr : expandedExprList) {
                    list.add(builder.registerInput(expr));
                }
                if (program.getCondition() != null && !(newConditionExp = (RexNode)expandedExprList.get(conditionIndex = program.getCondition().getIndex())).isAlwaysTrue()) {
                    if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral(newConditionExp, true)) {
                        call.transformTo(new EmptyRel(calc.getCluster(), calc.getRowType()));
                        return;
                    }
                    builder.addCondition((RexNode)list.get(conditionIndex));
                }
                int k = 0;
                for (RexLocalRef projectExpr : program.getProjectList()) {
                    int index = projectExpr.getIndex();
                    builder.addProject(((RexLocalRef)list.get(index)).getIndex(), program.getOutputRowType().getFieldNames().get(k++));
                }
                call.transformTo(new CalcRel(calc.getCluster(), calc.getTraitSet(), calc.getChild(), calc.getRowType(), builder.getProgram(), calc.getCollationList()));
                call.getPlanner().setImportance(calc, 0.0);
            }
        }
    };

    private ReduceExpressionsRule(Class<? extends RelNode> clazz, String desc) {
        super(ReduceExpressionsRule.operand(clazz, ReduceExpressionsRule.any()), desc);
    }

    static boolean reduceExpressions(RelNode rel, List<RexNode> expList) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        ArrayList<RexNode> constExps = new ArrayList<RexNode>();
        ArrayList<Boolean> addCasts = new ArrayList<Boolean>();
        ArrayList<RexNode> removableCasts = new ArrayList<RexNode>();
        ReduceExpressionsRule.findReducibleExps(rel.getCluster().getTypeFactory(), expList, constExps, addCasts, removableCasts);
        if (constExps.isEmpty() && removableCasts.isEmpty()) {
            return false;
        }
        if (!removableCasts.isEmpty()) {
            ArrayList<RexNode> reducedExprs = new ArrayList<RexNode>();
            ArrayList<Boolean> noCasts = new ArrayList<Boolean>();
            for (RexNode exp : removableCasts) {
                RexCall call = (RexCall)exp;
                reducedExprs.add(call.getOperands().get(0));
                noCasts.add(false);
            }
            RexReplacer replacer = new RexReplacer(rexBuilder, removableCasts, reducedExprs, noCasts);
            replacer.mutate(expList);
        }
        if (constExps.isEmpty()) {
            return true;
        }
        RelOptPlanner.Executor executor = rel.getCluster().getPlanner().getExecutor();
        ArrayList<RexNode> reducedValues = new ArrayList<RexNode>();
        executor.reduce(rexBuilder, constExps, reducedValues);
        if (rel instanceof ProjectRel) {
            for (int i = 0; i < reducedValues.size(); ++i) {
                addCasts.set(i, true);
            }
        }
        RexReplacer replacer = new RexReplacer(rexBuilder, constExps, reducedValues, addCasts);
        replacer.mutate(expList);
        return true;
    }

    private static void findReducibleExps(RelDataTypeFactory typeFactory, List<RexNode> exps, List<RexNode> constExps, List<Boolean> addCasts, List<RexNode> removableCasts) {
        ReducibleExprLocator gardener = new ReducibleExprLocator(typeFactory, constExps, addCasts, removableCasts);
        for (RexNode exp : exps) {
            gardener.analyze(exp);
        }
        assert (constExps.size() == addCasts.size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReducibleExprLocator
    extends RexVisitorImpl<Void> {
        private final RelDataTypeFactory typeFactory;
        private final List<Constancy> stack;
        private final List<RexNode> constExprs;
        private final List<Boolean> addCasts;
        private final List<RexNode> removableCasts;
        private final List<SqlOperator> parentCallTypeStack;

        ReducibleExprLocator(RelDataTypeFactory typeFactory, List<RexNode> constExprs, List<Boolean> addCasts, List<RexNode> removableCasts) {
            super(true);
            this.typeFactory = typeFactory;
            this.constExprs = constExprs;
            this.addCasts = addCasts;
            this.removableCasts = removableCasts;
            this.stack = new ArrayList<Constancy>();
            this.parentCallTypeStack = new ArrayList<SqlOperator>();
        }

        public void analyze(RexNode exp) {
            assert (this.stack.isEmpty());
            exp.accept(this);
            assert (this.stack.size() == 1);
            assert (this.parentCallTypeStack.isEmpty());
            Constancy rootConstancy = this.stack.get(0);
            if (rootConstancy == Constancy.REDUCIBLE_CONSTANT) {
                this.addResult(exp);
            }
            this.stack.clear();
        }

        private Void pushVariable() {
            this.stack.add(Constancy.NON_CONSTANT);
            return null;
        }

        private void addResult(RexNode exp) {
            RexCall cast;
            RexNode operand;
            if (exp.getKind() == SqlKind.CAST && (operand = (cast = (RexCall)exp).getOperands().get(0)) instanceof RexLiteral) {
                return;
            }
            this.constExprs.add(exp);
            if (this.parentCallTypeStack.isEmpty()) {
                this.addCasts.add(false);
            } else {
                this.addCasts.add(this.isUdf(Stacks.peek(this.parentCallTypeStack)));
            }
        }

        private Boolean isUdf(SqlOperator operator) {
            return false;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            return this.pushVariable();
        }

        @Override
        public Void visitLiteral(RexLiteral literal) {
            this.stack.add(Constancy.IRREDUCIBLE_CONSTANT);
            return null;
        }

        @Override
        public Void visitOver(RexOver over) {
            this.analyzeCall(over, Constancy.NON_CONSTANT);
            return null;
        }

        @Override
        public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
            return this.pushVariable();
        }

        @Override
        public Void visitCall(RexCall call) {
            this.analyzeCall(call, Constancy.REDUCIBLE_CONSTANT);
            return null;
        }

        private void analyzeCall(RexCall call, Constancy callConstancy) {
            Stacks.push(this.parentCallTypeStack, call.getOperator());
            super.visitCall(call);
            int operandCount = call.getOperands().size();
            List<Constancy> operandStack = Util.last(this.stack, operandCount);
            for (Constancy operandConstancy : operandStack) {
                if (operandConstancy != Constancy.NON_CONSTANT) continue;
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (!call.getOperator().isDeterministic()) {
                callConstancy = Constancy.NON_CONSTANT;
            } else if (call.getOperator().isDynamicFunction()) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.REDUCIBLE_CONSTANT && call.getOperator() instanceof SqlRowOperator) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.NON_CONSTANT) {
                for (int iOperand = 0; iOperand < operandCount; ++iOperand) {
                    Constancy constancy = operandStack.get(iOperand);
                    if (constancy != Constancy.REDUCIBLE_CONSTANT) continue;
                    this.addResult(call.getOperands().get(iOperand));
                }
                if (call.getOperator() == SqlStdOperatorTable.CAST) {
                    this.reduceCasts(call);
                }
            }
            operandStack.clear();
            Stacks.pop(this.parentCallTypeStack, call.getOperator());
            this.stack.add(callConstancy);
        }

        private void reduceCasts(RexCall outerCast) {
            RelDataType innerTypeNullable;
            List<RexNode> operands = outerCast.getOperands();
            if (operands.size() != 1) {
                return;
            }
            RelDataType outerCastType = outerCast.getType();
            RelDataType operandType = operands.get(0).getType();
            if (operandType.equals(outerCastType)) {
                this.removableCasts.add(outerCast);
                return;
            }
            if (!(operands.get(0) instanceof RexCall)) {
                return;
            }
            RexCall innerCast = (RexCall)operands.get(0);
            if (innerCast.getOperator() != SqlStdOperatorTable.CAST) {
                return;
            }
            if (innerCast.getOperands().size() != 1) {
                return;
            }
            RelDataType outerTypeNullable = this.typeFactory.createTypeWithNullability(outerCastType, true);
            if (outerTypeNullable != (innerTypeNullable = this.typeFactory.createTypeWithNullability(operandType, true))) {
                return;
            }
            if (operandType.isNullable()) {
                this.removableCasts.add(innerCast);
            }
        }

        @Override
        public Void visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.pushVariable();
        }

        @Override
        public Void visitRangeRef(RexRangeRef rangeRef) {
            return this.pushVariable();
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.pushVariable();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Constancy {
            NON_CONSTANT,
            REDUCIBLE_CONSTANT,
            IRREDUCIBLE_CONSTANT;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RexReplacer
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final List<RexNode> reducibleExps;
        private final List<RexNode> reducedValues;
        private final List<Boolean> addCasts;

        RexReplacer(RexBuilder rexBuilder, List<RexNode> reducibleExps, List<RexNode> reducedValues, List<Boolean> addCasts) {
            this.rexBuilder = rexBuilder;
            this.reducibleExps = reducibleExps;
            this.reducedValues = reducedValues;
            this.addCasts = addCasts;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            int i = this.reducibleExps.indexOf(call);
            if (i == -1) {
                return super.visitCall(call);
            }
            RexNode replacement = this.reducedValues.get(i);
            if (this.addCasts.get(i).booleanValue() && replacement.getType() != call.getType()) {
                replacement = this.rexBuilder.makeCast(call.getType(), replacement);
            }
            return replacement;
        }
    }
}

