/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.base.Predicate;
import java.util.List;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveTrivialProjectRule
extends RelOptRule {
    private static final Predicate<ProjectRelBase> PREDICATE = new Predicate<ProjectRelBase>(){

        public boolean apply(ProjectRelBase input) {
            return RemoveTrivialProjectRule.isTrivial(input);
        }
    };
    public static final RemoveTrivialProjectRule INSTANCE = new RemoveTrivialProjectRule();

    private RemoveTrivialProjectRule() {
        super(RemoveTrivialProjectRule.operand(ProjectRelBase.class, null, PREDICATE, RemoveTrivialProjectRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ProjectRelBase project = (ProjectRelBase)call.rel(0);
        assert (RemoveTrivialProjectRule.isTrivial(project));
        RelNode stripped = project.getChild();
        RelNode child = call.getPlanner().register(stripped, project);
        call.transformTo(child);
    }

    public static RelNode strip(ProjectRelBase project) {
        return RemoveTrivialProjectRule.isTrivial(project) ? project.getChild() : project;
    }

    public static boolean isTrivial(ProjectRelBase project) {
        RelNode child = project.getChild();
        RelDataType childRowType = child.getRowType();
        if (!childRowType.isStruct()) {
            return false;
        }
        if (!project.isBoxed()) {
            return false;
        }
        return RemoveTrivialProjectRule.isIdentity(project.getProjects(), project.getRowType(), childRowType);
    }

    public static boolean isIdentity(List<? extends RexNode> exps, RelDataType rowType, RelDataType childRowType) {
        List<RelDataTypeField> fields = rowType.getFieldList();
        List<RelDataTypeField> childFields = childRowType.getFieldList();
        int fieldCount = childFields.size();
        if (exps.size() != fieldCount) {
            return false;
        }
        for (int i = 0; i < exps.size(); ++i) {
            RexNode exp = exps.get(i);
            if (!(exp instanceof RexInputRef)) {
                return false;
            }
            RexInputRef var = (RexInputRef)exp;
            if (var.getIndex() != i) {
                return false;
            }
            if (fields.get(i).getName().equals(childFields.get(i).getName())) continue;
            return false;
        }
        return true;
    }
}

