/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.JoinInfo;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.IntList;

public class SemiJoinRule
extends RelOptRule {
    public static final SemiJoinRule INSTANCE = new SemiJoinRule();

    private SemiJoinRule() {
        super(SemiJoinRule.operand(ProjectRelBase.class, SemiJoinRule.some(SemiJoinRule.operand(JoinRelBase.class, SemiJoinRule.some(SemiJoinRule.operand(RelNode.class, SemiJoinRule.any()), SemiJoinRule.operand(AggregateRelBase.class, SemiJoinRule.any()))), new RelOptRuleOperand[0])));
    }

    public void onMatch(RelOptRuleCall call) {
        BitSet rightBits;
        ProjectRelBase project = (ProjectRelBase)call.rel(0);
        JoinRelBase join = (JoinRelBase)call.rel(1);
        Object left = call.rel(2);
        AggregateRelBase aggregate = (AggregateRelBase)call.rel(3);
        BitSet bits = RelOptUtil.InputFinder.bits(project.getProjects(), null);
        if (bits.intersects(rightBits = BitSets.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount()))) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(BitSets.range(aggregate.getGroupCount()))) {
            return;
        }
        ArrayList newRightKeys = Lists.newArrayList();
        IntList aggregateKeys = BitSets.toList(aggregate.getGroupSet());
        for (int key : joinInfo.rightKeys) {
            newRightKeys.add(aggregateKeys.get(key));
        }
        SemiJoinRel semiJoin = new SemiJoinRel(join.getCluster(), join.getCluster().traitSetOf(Convention.NONE), (RelNode)left, aggregate.getChild(), join.getCondition(), joinInfo.leftKeys, ImmutableIntList.copyOf(newRightKeys));
        ProjectRelBase newProject = project.copy(project.getTraitSet(), semiJoin, project.getProjects(), project.getRowType());
        call.transformTo(RemoveTrivialProjectRule.strip(newProject));
    }
}

