/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import net.hydromatic.optiq.config.OptiqConnectionConfig;
import org.eigenbase.relopt.Context;

public class Contexts {
    public static final EmptyContext EMPTY_CONTEXT = new EmptyContext();

    private Contexts() {
    }

    public static Context withConfig(OptiqConnectionConfig config) {
        return new ConfigContext(config);
    }

    public static Context empty() {
        return EMPTY_CONTEXT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyContext
    implements Context {
        EmptyContext() {
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConfigContext
    implements Context {
        private OptiqConnectionConfig config;

        public ConfigContext(OptiqConnectionConfig config) {
            this.config = config;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this.config)) {
                return clazz.cast(this.config);
            }
            return null;
        }
    }
}

