/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.collect.ImmutableList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelOptAbstractTable
implements RelOptTable {
    protected final RelOptSchema schema;
    protected final RelDataType rowType;
    protected final String name;

    protected RelOptAbstractTable(RelOptSchema schema, String name, RelDataType rowType) {
        this.schema = schema;
        this.name = name;
        this.rowType = rowType;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getQualifiedName() {
        return ImmutableList.of((Object)this.name);
    }

    @Override
    public double getRowCount() {
        return 100.0;
    }

    @Override
    public RelDataType getRowType() {
        return this.rowType;
    }

    @Override
    public RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    @Override
    public List<RelCollation> getCollationList() {
        return Collections.emptyList();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return clazz.isInstance(this) ? (T)clazz.cast(this) : null;
    }

    @Override
    public boolean isKey(BitSet columns) {
        return false;
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        return new TableAccessRel(context.getCluster(), this);
    }

    @Override
    public Expression getExpression(Class clazz) {
        throw new UnsupportedOperationException();
    }
}

