/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.Lattice;
import net.hydromatic.optiq.materialize.MaterializationService;
import net.hydromatic.optiq.materialize.TileKey;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptMaterialization;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelOptLattice {
    public final Lattice lattice;
    public final RelOptTable starRelOptTable;

    public RelOptLattice(Lattice lattice, RelOptTable starRelOptTable) {
        this.lattice = lattice;
        this.starRelOptTable = starRelOptTable;
    }

    public RelOptTable rootTable() {
        return ((Lattice.Node)this.lattice.nodes.get((int)0)).scan.getTable();
    }

    public RelNode rewrite(RelNode node) {
        return RelOptMaterialization.tryUseStar(node, this.starRelOptTable);
    }

    public Pair<OptiqSchema.TableEntry, TileKey> getAggregate(RelOptPlanner planner, BitSet groupSet, List<Lattice.Measure> measureList) {
        OptiqConnectionConfig config = planner.getContext().unwrap(OptiqConnectionConfig.class);
        if (config == null) {
            return null;
        }
        MaterializationService service = MaterializationService.instance();
        boolean create = this.lattice.auto && config.createMaterializations();
        OptiqSchema schema = this.starRelOptTable.unwrap(OptiqSchema.class);
        return service.defineTile(this.lattice, groupSet, measureList, schema, create, false);
    }
}

