/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.StarTable;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.Programs;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttleImpl;
import org.eigenbase.rel.TableAccessRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.metadata.DefaultRelMetadataProvider;
import org.eigenbase.rel.rules.AggregateFilterTransposeRule;
import org.eigenbase.rel.rules.AggregateProjectMergeRule;
import org.eigenbase.rel.rules.MergeProjectRule;
import org.eigenbase.rel.rules.PullUpProjectsAboveJoinRule;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.rel.rules.PushProjectPastFilterRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mappings;

public class RelOptMaterialization {
    public final RelNode tableRel;
    public final RelOptTable starRelOptTable;
    public final StarTable starTable;
    public final RelOptTable table;
    public final RelNode queryRel;

    public RelOptMaterialization(RelNode tableRel, RelNode queryRel, RelOptTable starRelOptTable) {
        this.tableRel = tableRel;
        this.starRelOptTable = starRelOptTable;
        if (starRelOptTable == null) {
            this.starTable = null;
        } else {
            this.starTable = starRelOptTable.unwrap(StarTable.class);
            assert (this.starTable != null);
        }
        this.table = tableRel.getTable();
        this.queryRel = queryRel;
    }

    public static RelNode tryUseStar(RelNode rel, final RelOptTable starRelOptTable) {
        final StarTable starTable = starRelOptTable.unwrap(StarTable.class);
        assert (starTable != null);
        RelNode rel2 = rel.accept(new RelShuttleImpl(){

            public RelNode visit(TableAccessRelBase scan) {
                RelOptTable relOptTable = scan.getTable();
                Table table = relOptTable.unwrap(Table.class);
                if (table.equals(starTable.tables.get(0))) {
                    Mappings.TargetMapping mapping = Mappings.createShiftMapping(starRelOptTable.getRowType().getFieldCount(), 0, 0, relOptTable.getRowType().getFieldCount());
                    RelOptCluster cluster = scan.getCluster();
                    RelNode scan2 = starRelOptTable.toRel(RelOptUtil.getContext(cluster));
                    return RelOptUtil.createProject(scan2, Mappings.asList(mapping.inverse()));
                }
                return scan;
            }

            public RelNode visit(JoinRel join) {
                RelNode rel;
                while ((rel = super.visit(join)) != join && rel instanceof JoinRel) {
                    ProjectFilterTable right;
                    join = (JoinRel)rel;
                    ProjectFilterTable left = ProjectFilterTable.of(join.getLeft());
                    if (left == null || (right = ProjectFilterTable.of(join.getRight())) == null) continue;
                    try {
                        this.match(left, right, join.getCluster());
                    }
                    catch (Util.FoundOne e) {
                        return (RelNode)e.getNode();
                    }
                }
                return rel;
            }

            private void match(ProjectFilterTable left, ProjectFilterTable right, RelOptCluster cluster) {
                Mappings.TargetMapping leftMapping = left.mapping();
                Mappings.TargetMapping rightMapping = right.mapping();
                RelOptTable leftRelOptTable = left.getTable();
                Table leftTable = leftRelOptTable.unwrap(Table.class);
                int leftCount = leftRelOptTable.getRowType().getFieldCount();
                RelOptTable rightRelOptTable = right.getTable();
                Table rightTable = rightRelOptTable.unwrap(Table.class);
                if (leftTable instanceof StarTable && ((StarTable)leftTable).tables.contains((Object)rightTable)) {
                    int offset = ((StarTable)leftTable).columnOffset(rightTable);
                    Mappings.TargetMapping mapping = Mappings.merge(leftMapping, Mappings.offsetTarget(Mappings.offsetSource(rightMapping, offset), leftMapping.getTargetCount()));
                    RelNode project = RelOptUtil.createProject(new TableAccessRel(cluster, leftRelOptTable), Mappings.asList(mapping.inverse()));
                    ArrayList conditions = Lists.newArrayList();
                    if (left.condition != null) {
                        conditions.add(left.condition);
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(right.condition, offset)));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
                if (rightTable instanceof StarTable && ((StarTable)rightTable).tables.contains((Object)leftTable)) {
                    int offset = ((StarTable)rightTable).columnOffset(leftTable);
                    Mappings.TargetMapping mapping = Mappings.merge(Mappings.offsetSource(leftMapping, offset), Mappings.offsetTarget(rightMapping, leftCount));
                    RelNode project = RelOptUtil.createProject(new TableAccessRel(cluster, rightRelOptTable), Mappings.asList(mapping.inverse()));
                    ArrayList conditions = Lists.newArrayList();
                    if (left.condition != null) {
                        conditions.add(RexUtil.apply(mapping, RexUtil.shift(left.condition, offset)));
                    }
                    if (right.condition != null) {
                        conditions.add(RexUtil.apply(mapping, right.condition));
                    }
                    RelNode filter = RelOptUtil.createFilter(project, conditions);
                    throw new Util.FoundOne(filter);
                }
            }
        });
        if (rel2 == rel) {
            return rel;
        }
        Program program = Programs.hep((ImmutableList<RelOptRule>)ImmutableList.of((Object)PushProjectPastFilterRule.INSTANCE, (Object)AggregateProjectMergeRule.INSTANCE, (Object)AggregateFilterTransposeRule.INSTANCE), false, new DefaultRelMetadataProvider());
        return program.run(null, rel2, null);
    }

    public static RelNode toLeafJoinForm(RelNode rel) {
        Program program = Programs.hep((ImmutableList<RelOptRule>)ImmutableList.of((Object)PullUpProjectsAboveJoinRule.RIGHT_PROJECT, (Object)PullUpProjectsAboveJoinRule.LEFT_PROJECT, (Object)PushFilterPastJoinRule.PushFilterIntoJoinRule.FILTER_ON_JOIN, (Object)MergeProjectRule.INSTANCE), false, new DefaultRelMetadataProvider());
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println(RelOptUtil.dumpPlan("before", rel, false, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        RelNode rel2 = program.run(null, rel, null);
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println(RelOptUtil.dumpPlan("after", rel2, false, SqlExplainLevel.DIGEST_ATTRIBUTES));
        }
        return rel2;
    }

    private static class ProjectFilterTable {
        final RexNode condition;
        final Mappings.TargetMapping mapping;
        final TableAccessRelBase scan;

        private ProjectFilterTable(RexNode condition, Mappings.TargetMapping mapping, TableAccessRelBase scan) {
            this.condition = condition;
            this.mapping = mapping;
            this.scan = (TableAccessRelBase)Preconditions.checkNotNull((Object)scan);
        }

        static ProjectFilterTable of(RelNode node) {
            if (node instanceof FilterRelBase) {
                FilterRelBase filter = (FilterRelBase)node;
                return ProjectFilterTable.of2(filter.getCondition(), filter.getChild());
            }
            return ProjectFilterTable.of2(null, node);
        }

        private static ProjectFilterTable of2(RexNode condition, RelNode node) {
            if (node instanceof ProjectRelBase) {
                ProjectRelBase project = (ProjectRelBase)node;
                return ProjectFilterTable.of3(condition, project.getMapping(), project.getChild());
            }
            return ProjectFilterTable.of3(condition, null, node);
        }

        private static ProjectFilterTable of3(RexNode condition, Mappings.TargetMapping mapping, RelNode node) {
            if (node instanceof TableAccessRelBase) {
                return new ProjectFilterTable(condition, mapping, (TableAccessRelBase)node);
            }
            return null;
        }

        public Mappings.TargetMapping mapping() {
            return this.mapping != null ? this.mapping : Mappings.createIdentity(this.scan.getRowType().getFieldCount());
        }

        public RelOptTable getTable() {
            return this.scan.getTable();
        }
    }
}

