/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import java.util.BitSet;
import java.util.List;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strong {
    private final BitSet nullColumns;

    private Strong(BitSet nullColumns) {
        this.nullColumns = nullColumns;
    }

    public static Strong of(BitSet nullColumns) {
        return new Strong(nullColumns);
    }

    public static boolean is(RexNode node, BitSet nullColumns) {
        return Strong.of(nullColumns).strong(node);
    }

    private boolean strong(RexNode node) {
        switch (node.getKind()) {
            case LITERAL: {
                return ((RexLiteral)node).getValue() == null;
            }
            case IS_TRUE: 
            case IS_NOT_NULL: 
            case AND: 
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.anyStrong(((RexCall)node).getOperands());
            }
            case OR: {
                return this.allStrong(((RexCall)node).getOperands());
            }
            case INPUT_REF: {
                return this.nullColumns.get(((RexInputRef)node).getIndex());
            }
        }
        return false;
    }

    private boolean allStrong(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (this.strong(operand)) continue;
            return false;
        }
        return true;
    }

    private boolean anyStrong(List<RexNode> operands) {
        for (RexNode operand : operands) {
            if (!this.strong(operand)) continue;
            return true;
        }
        return false;
    }
}

