/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.reltype;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeSystem;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.type.SqlTypeName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RelDataTypeFactory {
    public RelDataTypeSystem getTypeSystem();

    public RelDataType createJavaType(Class var1);

    public RelDataType createJoinType(RelDataType ... var1);

    public RelDataType createStructType(List<RelDataType> var1, List<String> var2);

    public RelDataType createStructType(FieldInfo var1);

    public RelDataType createStructType(List<? extends Map.Entry<String, RelDataType>> var1);

    public RelDataType createArrayType(RelDataType var1, long var2);

    public RelDataType createMapType(RelDataType var1, RelDataType var2);

    public RelDataType createMultisetType(RelDataType var1, long var2);

    public RelDataType copyType(RelDataType var1);

    public RelDataType createTypeWithNullability(RelDataType var1, boolean var2);

    public RelDataType createTypeWithCharsetAndCollation(RelDataType var1, Charset var2, SqlCollation var3);

    public Charset getDefaultCharset();

    public RelDataType leastRestrictive(List<RelDataType> var1);

    public RelDataType createSqlType(SqlTypeName var1);

    public RelDataType createSqlType(SqlTypeName var1, int var2);

    public RelDataType createSqlType(SqlTypeName var1, int var2, int var3);

    public RelDataType createSqlIntervalType(SqlIntervalQualifier var1);

    public RelDataType createDecimalProduct(RelDataType var1, RelDataType var2);

    public boolean useDoubleMultiplication(RelDataType var1, RelDataType var2);

    public RelDataType createDecimalQuotient(RelDataType var1, RelDataType var2);

    public FieldInfoBuilder builder();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldInfoBuilder
    implements FieldInfo {
        private final List<String> names = new ArrayList<String>();
        private final List<RelDataType> types = new ArrayList<RelDataType>();
        private final RelDataTypeFactory typeFactory;

        public FieldInfoBuilder(RelDataTypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            assert (typeFactory != null);
        }

        @Override
        public int getFieldCount() {
            return this.names.size();
        }

        @Override
        public String getFieldName(int index) {
            return this.names.get(index);
        }

        @Override
        public RelDataType getFieldType(int index) {
            return this.types.get(index);
        }

        public FieldInfoBuilder add(String name, RelDataType type) {
            this.names.add(name);
            this.types.add(type);
            return this;
        }

        public FieldInfoBuilder add(String name, SqlTypeName typeName) {
            this.add(name, this.typeFactory.createSqlType(typeName));
            return this;
        }

        public FieldInfoBuilder add(String name, SqlTypeName typeName, int precision) {
            this.add(name, this.typeFactory.createSqlType(typeName, precision));
            return this;
        }

        public FieldInfoBuilder add(String name, SqlTypeName typeName, int precision, int scale) {
            this.add(name, this.typeFactory.createSqlType(typeName, precision, scale));
            return this;
        }

        public FieldInfoBuilder nullable(boolean nullable) {
            RelDataType lastType = this.types.get(this.types.size() - 1);
            if (lastType.isNullable() != nullable) {
                RelDataType type = this.typeFactory.createTypeWithNullability(lastType, nullable);
                this.types.set(this.types.size() - 1, type);
            }
            return this;
        }

        public FieldInfoBuilder add(RelDataTypeField field) {
            this.add(field.getName(), field.getType());
            return this;
        }

        public FieldInfoBuilder addAll(Iterable<? extends Map.Entry<String, RelDataType>> fields) {
            for (Map.Entry<String, RelDataType> entry : fields) {
                this.add(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public RelDataType build() {
            return this.typeFactory.createStructType(this.types, this.names);
        }
    }

    public static interface FieldInfo {
        public int getFieldCount();

        public String getFieldName(int var1);

        public RelDataType getFieldType(int var1);
    }
}

