/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RexWindowBound {
    public static RexWindowBound create(SqlNode node, RexNode rexNode) {
        if (SqlWindow.isUnboundedPreceding(node) || SqlWindow.isUnboundedFollowing(node)) {
            return new RexWindowBoundUnbounded(node);
        }
        if (SqlWindow.isCurrentRow(node)) {
            return new RexWindowBoundCurrentRow();
        }
        return new RexWindowBoundBounded(rexNode);
    }

    public boolean isUnbounded() {
        return false;
    }

    public boolean isPreceding() {
        return false;
    }

    public boolean isFollowing() {
        return false;
    }

    public boolean isCurrentRow() {
        return false;
    }

    public RexNode getOffset() {
        return null;
    }

    public int getOrderKey() {
        return -1;
    }

    public <R> RexWindowBound accept(RexVisitor<R> visitor) {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RexWindowBoundBounded
    extends RexWindowBound {
        private final SqlKind sqlKind;
        private final RexNode offset;

        public RexWindowBoundBounded(RexNode node) {
            assert (node instanceof RexCall) : "RexWindowBoundBounded window bound should be either 'X preceding' or 'X following' call. Actual type is " + node;
            RexCall call = (RexCall)node;
            this.offset = call.getOperands().get(0);
            this.sqlKind = call.getKind();
            assert (this.offset != null) : "RexWindowBoundBounded offset should not be null";
        }

        private RexWindowBoundBounded(SqlKind sqlKind, RexNode offset) {
            this.sqlKind = sqlKind;
            this.offset = offset;
        }

        @Override
        public boolean isPreceding() {
            return this.sqlKind == SqlKind.PRECEDING;
        }

        @Override
        public boolean isFollowing() {
            return this.sqlKind == SqlKind.FOLLOWING;
        }

        @Override
        public RexNode getOffset() {
            return this.offset;
        }

        @Override
        public <R> RexWindowBound accept(RexVisitor<R> visitor) {
            R r = this.offset.accept(visitor);
            if (r instanceof RexNode && r != this.offset) {
                return new RexWindowBoundBounded(this.sqlKind, (RexNode)r);
            }
            return this;
        }

        public String toString() {
            return this.offset.toString() + " " + this.sqlKind.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RexWindowBoundBounded that = (RexWindowBoundBounded)o;
            if (!this.offset.equals(that.offset)) {
                return false;
            }
            return this.sqlKind == that.sqlKind;
        }

        public int hashCode() {
            int result = this.sqlKind.hashCode();
            result = 31 * result + this.offset.hashCode();
            return result;
        }
    }

    private static class RexWindowBoundCurrentRow
    extends RexWindowBound {
        private RexWindowBoundCurrentRow() {
        }

        public boolean isCurrentRow() {
            return true;
        }

        public String toString() {
            return "CURRENT ROW";
        }

        public int getOrderKey() {
            return 1;
        }

        public boolean equals(Object obj) {
            return this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return 123;
        }
    }

    private static class RexWindowBoundUnbounded
    extends RexWindowBound {
        private final SqlNode node;

        public RexWindowBoundUnbounded(SqlNode node) {
            this.node = node;
        }

        public boolean isUnbounded() {
            return true;
        }

        public boolean isPreceding() {
            return SqlWindow.isUnboundedPreceding(this.node);
        }

        public boolean isFollowing() {
            return SqlWindow.isUnboundedFollowing(this.node);
        }

        public String toString() {
            return ((SqlLiteral)this.node).getValue().toString();
        }

        public int getOrderKey() {
            return this.isPreceding() ? 0 : 2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RexWindowBoundUnbounded that = (RexWindowBoundUnbounded)o;
            return this.node.equals(that.node);
        }

        public int hashCode() {
            return this.node.hashCode();
        }
    }
}

