/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util.UnmodifiableArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlBasicCall
extends SqlCall {
    private SqlOperator operator;
    public final SqlNode[] operands;
    private final SqlLiteral functionQuantifier;
    private final boolean expanded;

    public SqlBasicCall(SqlOperator operator, SqlNode[] operands, SqlParserPos pos) {
        this(operator, operands, pos, false, null);
    }

    protected SqlBasicCall(SqlOperator operator, SqlNode[] operands, SqlParserPos pos, boolean expanded, SqlLiteral functionQualifier) {
        super(pos);
        this.operator = operator;
        this.operands = operands;
        this.expanded = expanded;
        this.functionQuantifier = functionQualifier;
    }

    @Override
    public SqlKind getKind() {
        return this.operator.getKind();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        this.operands[i] = operand;
    }

    public void setOperator(SqlOperator operator) {
        this.operator = operator;
    }

    @Override
    public SqlOperator getOperator() {
        return this.operator;
    }

    public SqlNode[] getOperands() {
        return this.operands;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return UnmodifiableArrayList.of(this.operands);
    }

    @Override
    public <S extends SqlNode> S operand(int i) {
        return (S)this.operands[i];
    }

    @Override
    public int operandCount() {
        return this.operands.length;
    }

    @Override
    public SqlLiteral getFunctionQuantifier() {
        return this.functionQuantifier;
    }
}

