/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import java.util.Iterator;
import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlInsert;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlUpdate;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.ImmutableNullableList;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMerge
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("MERGE", SqlKind.MERGE);
    SqlIdentifier targetTable;
    SqlNode condition;
    SqlNode source;
    SqlUpdate updateCall;
    SqlInsert insertCall;
    SqlSelect sourceSelect;
    SqlIdentifier alias;

    public SqlMerge(SqlParserPos pos, SqlIdentifier targetTable, SqlNode condition, SqlNode source, SqlUpdate updateCall, SqlInsert insertCall, SqlSelect sourceSelect, SqlIdentifier alias) {
        super(pos);
        this.targetTable = targetTable;
        this.condition = condition;
        this.source = source;
        this.updateCall = updateCall;
        this.insertCall = insertCall;
        this.sourceSelect = sourceSelect;
        this.alias = alias;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.MERGE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.targetTable, this.condition, this.source, this.updateCall, this.insertCall, this.sourceSelect, this.alias);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.targetTable = (SqlIdentifier)operand;
                break;
            }
            case 1: {
                this.condition = operand;
                break;
            }
            case 2: {
                this.source = operand;
                break;
            }
            case 3: {
                this.updateCall = (SqlUpdate)operand;
                break;
            }
            case 4: {
                this.insertCall = (SqlInsert)operand;
                break;
            }
            case 5: {
                this.sourceSelect = (SqlSelect)operand;
                break;
            }
            case 6: {
                this.alias = (SqlIdentifier)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlIdentifier getTargetTable() {
        return this.targetTable;
    }

    public SqlIdentifier getAlias() {
        return this.alias;
    }

    public SqlNode getSourceTableRef() {
        return this.source;
    }

    public void setSourceTableRef(SqlNode tableRef) {
        this.source = tableRef;
    }

    public SqlUpdate getUpdateCall() {
        return this.updateCall;
    }

    public SqlInsert getInsertCall() {
        return this.insertCall;
    }

    public SqlNode getCondition() {
        return this.condition;
    }

    public SqlSelect getSourceSelect() {
        return this.sourceSelect;
    }

    public void setSourceSelect(SqlSelect sourceSelect) {
        this.sourceSelect = sourceSelect;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SELECT, "MERGE INTO", "");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        if (this.alias != null) {
            writer.keyword("AS");
            this.alias.unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        writer.keyword("USING");
        this.source.unparse(writer, opLeft, opRight);
        writer.newlineAndIndent();
        writer.keyword("ON");
        this.condition.unparse(writer, opLeft, opRight);
        if (this.updateCall != null) {
            writer.newlineAndIndent();
            writer.keyword("WHEN MATCHED THEN UPDATE");
            SqlWriter.Frame setFrame = writer.startList(SqlWriter.FrameTypeEnum.UPDATE_SET_LIST, "SET", "");
            Iterator<SqlNode> targetColumnIter = this.updateCall.getTargetColumnList().getList().iterator();
            Iterator<SqlNode> sourceExpressionIter = this.updateCall.getSourceExpressionList().getList().iterator();
            for (Pair<SqlNode, SqlNode> pair : Pair.zip(this.updateCall.targetColumnList, this.updateCall.sourceExpressionList)) {
                writer.sep(",");
                SqlIdentifier id = (SqlIdentifier)pair.left;
                id.unparse(writer, opLeft, opRight);
                writer.keyword("=");
                SqlNode sourceExp = (SqlNode)pair.right;
                sourceExp.unparse(writer, opLeft, opRight);
            }
            writer.endList(setFrame);
        }
        if (this.insertCall != null) {
            writer.newlineAndIndent();
            writer.keyword("WHEN NOT MATCHED THEN INSERT");
            if (this.insertCall.getTargetColumnList() != null) {
                this.insertCall.getTargetColumnList().unparse(writer, opLeft, opRight);
            }
            this.insertCall.getSource().unparse(writer, opLeft, opRight);
            writer.endList(frame);
        }
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateMerge(this);
    }
}

