/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.advise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.advise.SqlSimpleParser;
import org.eigenbase.sql.parser.SqlAbstractParserImpl;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonikerImpl;
import org.eigenbase.sql.validate.SqlMonikerType;
import org.eigenbase.sql.validate.SqlValidatorWithHints;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAdvisor {
    public static final Logger LOGGER = EigenbaseTrace.PARSER_LOGGER;
    private final SqlValidatorWithHints validator;
    private final String hintToken = "_suggest_";

    public SqlAdvisor(SqlValidatorWithHints validator) {
        this.validator = validator;
    }

    public List<SqlMoniker> getCompletionHints(String sql, int cursor, String[] replaced) {
        List<SqlMoniker> result;
        int wordEnd;
        int wordStart;
        boolean quoted = false;
        for (wordStart = cursor; wordStart > 0 && Character.isJavaIdentifierPart(sql.charAt(wordStart - 1)); --wordStart) {
        }
        if (wordStart > 0 && sql.charAt(wordStart - 1) == '\"') {
            quoted = true;
            --wordStart;
        }
        if (wordStart < 0) {
            return Collections.emptyList();
        }
        for (wordEnd = cursor; wordEnd < sql.length() && Character.isJavaIdentifierPart(sql.charAt(wordEnd)); ++wordEnd) {
        }
        if (quoted && wordEnd < sql.length() && sql.charAt(wordEnd) == '\"') {
            ++wordEnd;
        }
        String word = replaced[0] = sql.substring(wordStart, cursor);
        if (wordStart < wordEnd) {
            sql = sql.substring(0, wordStart) + sql.substring(wordEnd, sql.length());
        }
        List<SqlMoniker> completionHints = this.getCompletionHints0(sql, wordStart);
        if (word.length() > 0) {
            result = new ArrayList<SqlMoniker>();
            if (quoted) {
                word = word.substring(1);
                for (SqlMoniker hint : completionHints) {
                    String cname = hint.toString();
                    if (!cname.startsWith(word)) continue;
                    result.add(hint);
                }
            } else {
                for (SqlMoniker hint : completionHints) {
                    String cname = hint.toString();
                    if (cname.length() < word.length() || !cname.substring(0, word.length()).equalsIgnoreCase(word)) continue;
                    result.add(hint);
                }
            }
        } else {
            result = completionHints;
        }
        return result;
    }

    public List<SqlMoniker> getCompletionHints0(String sql, int cursor) {
        String simpleSql = this.simplifySql(sql, cursor);
        int idx = simpleSql.indexOf("_suggest_");
        if (idx < 0) {
            return Collections.emptyList();
        }
        SqlParserPos pos = new SqlParserPos(1, idx + 1);
        return this.getCompletionHints(simpleSql, pos);
    }

    public List<SqlMoniker> getCompletionHints(String sql, SqlParserPos pos) {
        ArrayList<SqlMoniker> hintList = new ArrayList<SqlMoniker>();
        SqlNode sqlNode = this.tryParse(sql, hintList);
        if (sqlNode == null) {
            return hintList;
        }
        int x = pos.getColumnNum() - 1;
        sql = sql.substring(0, x) + " \u0007" + sql.substring(x);
        this.tryParse(sql, hintList);
        try {
            this.validator.validate(sqlNode);
        }
        catch (Exception e) {
            Util.swallow(e, LOGGER);
        }
        List<SqlMoniker> validatorHints = this.validator.lookupHints(sqlNode, pos);
        hintList.addAll(validatorHints);
        return hintList;
    }

    private SqlNode tryParse(String sql, List<SqlMoniker> hintList) {
        try {
            return this.parseQuery(sql);
        }
        catch (SqlParseException e) {
            for (String tokenName : e.getExpectedTokenNames()) {
                if (!tokenName.startsWith("\"") || !tokenName.endsWith("\"")) continue;
                hintList.add(new SqlMonikerImpl(tokenName.substring(1, tokenName.length() - 1), SqlMonikerType.KEYWORD));
            }
            return null;
        }
        catch (EigenbaseException e) {
            Util.swallow(e, null);
            return null;
        }
    }

    public SqlMoniker getQualifiedName(String sql, int cursor) {
        SqlNode sqlNode;
        try {
            sqlNode = this.parseQuery(sql);
            this.validator.validate(sqlNode);
        }
        catch (Exception e) {
            return null;
        }
        SqlParserPos pos = new SqlParserPos(1, cursor + 1);
        try {
            return this.validator.lookupQualifiedName(sqlNode, pos);
        }
        catch (EigenbaseContextException e) {
            return null;
        }
        catch (AssertionError e) {
            return null;
        }
    }

    public boolean isValid(String sql) {
        SqlNode sqlNode;
        SqlSimpleParser simpleParser = new SqlSimpleParser("_suggest_");
        String simpleSql = simpleParser.simplifySql(sql);
        try {
            sqlNode = this.parseQuery(simpleSql);
        }
        catch (Exception e) {
            return false;
        }
        try {
            this.validator.validate(sqlNode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List<ValidateErrorInfo> validate(String sql) {
        ArrayList<ValidateErrorInfo> errorList = new ArrayList<ValidateErrorInfo>();
        SqlNode sqlNode = this.collectParserError(sql, errorList);
        if (!errorList.isEmpty()) {
            return errorList;
        }
        try {
            this.validator.validate(sqlNode);
        }
        catch (EigenbaseContextException e) {
            ValidateErrorInfo errInfo = new ValidateErrorInfo(e);
            errorList.add(errInfo);
            return errorList;
        }
        catch (Exception e) {
            ValidateErrorInfo errInfo = new ValidateErrorInfo(1, 1, 1, sql.length(), e.getMessage());
            errorList.add(errInfo);
            return errorList;
        }
        return null;
    }

    public String simplifySql(String sql, int cursor) {
        SqlSimpleParser parser = new SqlSimpleParser("_suggest_");
        return parser.simplifySql(sql, cursor);
    }

    public List<String> getReservedAndKeyWords() {
        Set<String> c = SqlAbstractParserImpl.getSql92ReservedWords();
        List<String> l = Arrays.asList(this.getParserMetadata().getJdbcKeywords().split(","));
        ArrayList<String> al = new ArrayList<String>();
        al.addAll(c);
        al.addAll(l);
        return al;
    }

    protected SqlAbstractParserImpl.Metadata getParserMetadata() {
        SqlParser parser = SqlParser.create("");
        return parser.getMetadata();
    }

    protected SqlNode parseQuery(String sql) throws SqlParseException {
        SqlParser parser = SqlParser.create(sql);
        return parser.parseStmt();
    }

    protected SqlNode collectParserError(String sql, List<ValidateErrorInfo> errorList) {
        try {
            return this.parseQuery(sql);
        }
        catch (SqlParseException e) {
            ValidateErrorInfo errInfo = new ValidateErrorInfo(e.getPos(), e.getMessage());
            errorList.add(errInfo);
            return null;
        }
    }

    public class ValidateErrorInfo {
        private int startLineNum;
        private int startColumnNum;
        private int endLineNum;
        private int endColumnNum;
        private String errorMsg;

        public ValidateErrorInfo(int startLineNum, int startColumnNum, int endLineNum, int endColumnNum, String errorMsg) {
            this.startLineNum = startLineNum;
            this.startColumnNum = startColumnNum;
            this.endLineNum = endLineNum;
            this.endColumnNum = endColumnNum;
            this.errorMsg = errorMsg;
        }

        public ValidateErrorInfo(EigenbaseContextException e) {
            this.startLineNum = e.getPosLine();
            this.startColumnNum = e.getPosColumn();
            this.endLineNum = e.getEndPosLine();
            this.endColumnNum = e.getEndPosColumn();
            this.errorMsg = e.getCause().getMessage();
        }

        public ValidateErrorInfo(SqlParserPos pos, String errorMsg) {
            this.startLineNum = pos.getLineNum();
            this.startColumnNum = pos.getColumnNum();
            this.endLineNum = pos.getEndLineNum();
            this.endColumnNum = pos.getEndColumnNum();
            this.errorMsg = errorMsg;
        }

        public int getStartLineNum() {
            return this.startLineNum;
        }

        public int getStartColumnNum() {
            return this.startColumnNum;
        }

        public int getEndLineNum() {
            return this.endLineNum;
        }

        public int getEndColumnNum() {
            return this.endColumnNum;
        }

        public String getMessage() {
            return this.errorMsg;
        }
    }
}

