/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlBinaryOperator;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.type.MultisetSqlType;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.util.Static;

public class SqlMultisetMemberOfOperator
extends SqlBinaryOperator {
    public SqlMultisetMemberOfOperator() {
        super("MEMBER OF", SqlKind.OTHER, 30, true, ReturnTypes.BOOLEAN_NULLABLE, null, null);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (!OperandTypes.MULTISET.checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(1), 0, throwOnFailure)) {
            return false;
        }
        MultisetSqlType mt = (MultisetSqlType)callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)callBinding.getCall().operand(1));
        RelDataType t0 = callBinding.getValidator().deriveType(callBinding.getScope(), (SqlNode)callBinding.getCall().operand(0));
        RelDataType t1 = mt.getComponentType();
        if (t0.getFamily() != t1.getFamily()) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.typeNotComparableNear(((Object)t0).toString(), ((Object)t1).toString()));
            }
            return false;
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(2);
    }
}

