/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;

public class SqlOverlayFunction
extends SqlFunction {
    private static final SqlOperandTypeChecker OTC_CUSTOM = OperandTypes.or(OperandTypes.STRING_STRING_INTEGER, OperandTypes.STRING_STRING_INTEGER_INTEGER);

    public SqlOverlayFunction() {
        super("OVERLAY", SqlKind.OTHER_FUNCTION, ReturnTypes.DYADIC_STRING_SUM_PRECISION_NULLABLE_VARYING, null, OTC_CUSTOM, SqlFunctionCategory.STRING);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep("PLACING");
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        if (4 == call.operandCount()) {
            writer.sep("FOR");
            ((SqlNode)call.operand(3)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    public String getSignatureTemplate(int operandsCount) {
        switch (operandsCount) {
            case 3: {
                return "{0}({1} PLACING {2} FROM {3})";
            }
            case 4: {
                return "{0}({1} PLACING {2} FROM {3} FOR {4})";
            }
        }
        assert (false);
        return null;
    }
}

