/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import java.nio.charset.Charset;
import org.eigenbase.reltype.RelDataTypeSystem;
import org.eigenbase.sql.SqlCollation;
import org.eigenbase.sql.type.AbstractSqlType;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.type.SqlTypeUtil;
import org.eigenbase.util.SerializableCharset;
import org.eigenbase.util.Util;

public class BasicSqlType
extends AbstractSqlType {
    private final int precision;
    private final int scale;
    private final RelDataTypeSystem typeSystem;
    private SqlCollation collation;
    private SerializableCharset wrappedCharset;

    public BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName) {
        this(typeSystem, typeName, false, -1, Integer.MIN_VALUE);
        assert (typeName.allowsPrecScale(false, false)) : "typeName.allowsPrecScale(false,false), typeName=" + typeName.name();
        this.computeDigest();
    }

    public BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName, int precision) {
        this(typeSystem, typeName, false, precision, Integer.MIN_VALUE);
        assert (typeName.allowsPrecScale(true, false)) : "typeName.allowsPrecScale(true, false)";
        this.computeDigest();
    }

    public BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName, int precision, int scale) {
        this(typeSystem, typeName, false, precision, scale);
        assert (typeName.allowsPrecScale(true, true));
        this.computeDigest();
    }

    private BasicSqlType(RelDataTypeSystem typeSystem, SqlTypeName typeName, boolean nullable, int precision, int scale) {
        super(typeName, nullable, null);
        this.typeSystem = typeSystem;
        this.precision = precision;
        this.scale = scale;
    }

    BasicSqlType createWithNullability(boolean nullable) {
        BasicSqlType ret;
        try {
            ret = (BasicSqlType)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Util.newInternal(e);
        }
        ret.isNullable = nullable;
        ret.computeDigest();
        return ret;
    }

    BasicSqlType createWithCharsetAndCollation(Charset charset, SqlCollation collation) {
        BasicSqlType ret;
        Util.pre(SqlTypeUtil.inCharFamily(this), "Not an chartype");
        try {
            ret = (BasicSqlType)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Util.newInternal(e);
        }
        ret.wrappedCharset = SerializableCharset.forCharset(charset);
        ret.collation = collation;
        ret.computeDigest();
        return ret;
    }

    public int getPrecision() {
        if (this.precision == -1) {
            switch (this.typeName) {
                case BOOLEAN: {
                    return 1;
                }
                case TINYINT: {
                    return 3;
                }
                case SMALLINT: {
                    return 5;
                }
                case INTEGER: {
                    return 10;
                }
                case BIGINT: {
                    return 19;
                }
                case DECIMAL: {
                    return RelDataTypeSystem.DEFAULT.getMaxNumericPrecision();
                }
                case REAL: {
                    return 7;
                }
                case FLOAT: 
                case DOUBLE: {
                    return 15;
                }
                case TIME: {
                    return 0;
                }
                case TIMESTAMP: {
                    return 0;
                }
                case DATE: {
                    return 0;
                }
                case CHAR: 
                case VARCHAR: 
                case BINARY: 
                case VARBINARY: {
                    return 1;
                }
            }
        }
        return this.precision;
    }

    public int getScale() {
        if (this.scale == Integer.MIN_VALUE) {
            switch (this.typeName) {
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case DECIMAL: {
                    return 0;
                }
            }
        }
        return this.scale;
    }

    public Charset getCharset() {
        return this.wrappedCharset == null ? null : this.wrappedCharset.getCharset();
    }

    public SqlCollation getCollation() {
        return this.collation;
    }

    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        boolean printScale;
        sb.append(this.typeName.name());
        boolean printPrecision = this.precision != -1;
        boolean bl = printScale = this.scale != Integer.MIN_VALUE;
        if (withDetail) {
            if (this.typeSystem.getDefaultPrecision(this.typeName) > -1) {
                printPrecision = true;
            }
            if (this.typeName.getDefaultScale() > -1) {
                printScale = true;
            }
        }
        if (printPrecision) {
            sb.append('(');
            sb.append(this.getPrecision());
            if (printScale) {
                sb.append(", ");
                sb.append(this.getScale());
            }
            sb.append(')');
        }
        if (!withDetail) {
            return;
        }
        if (this.wrappedCharset != null) {
            sb.append(" CHARACTER SET \"");
            sb.append(this.wrappedCharset.getCharset().name());
            sb.append("\"");
        }
        if (this.collation != null) {
            sb.append(" COLLATE \"");
            sb.append(this.collation.getCollationName());
            sb.append("\"");
        }
    }

    public Object getLimit(boolean sign, SqlTypeName.Limit limit, boolean beyond) {
        int precision = this.typeName.allowsPrec() ? this.getPrecision() : -1;
        int scale = this.typeName.allowsScale() ? this.getScale() : -1;
        return this.typeName.getLimit(sign, limit, beyond, precision, scale);
    }
}

