/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlSingleOperandTypeChecker;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

public class LiteralOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    private boolean allowNull;

    public LiteralOperandTypeChecker(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
        Util.discard(iFormalOperand);
        if (SqlUtil.isNullLiteral(node, true)) {
            if (this.allowNull) {
                return true;
            }
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustNotBeNull(callBinding.getOperator().getName()));
            }
            return false;
        }
        if (!SqlUtil.isLiteral(node) && !SqlUtil.isLiteralChain(node)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.argumentMustBeLiteral(callBinding.getOperator().getName()));
            }
            return false;
        }
        return true;
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return this.checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(0), 0, throwOnFailure);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<LITERAL>";
    }
}

