/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFamily;
import org.eigenbase.sql.type.AbstractSqlType;
import org.eigenbase.sql.type.SqlTypeName;

public class MapSqlType
extends AbstractSqlType {
    private final RelDataType keyType;
    private final RelDataType valueType;

    public MapSqlType(RelDataType keyType, RelDataType valueType, boolean isNullable) {
        super(SqlTypeName.MAP, isNullable, null);
        assert (keyType != null);
        assert (valueType != null);
        this.keyType = keyType;
        this.valueType = valueType;
        this.computeDigest();
    }

    public RelDataType getValueType() {
        return this.valueType;
    }

    public RelDataType getKeyType() {
        return this.keyType;
    }

    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("(").append(withDetail ? this.keyType.getFullTypeString() : ((Object)this.keyType).toString()).append(", ").append(withDetail ? this.valueType.getFullTypeString() : ((Object)this.valueType).toString()).append(") MAP");
    }

    public RelDataTypeFamily getFamily() {
        return this;
    }
}

