/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFamily;
import org.eigenbase.sql.type.AbstractSqlType;
import org.eigenbase.sql.type.SqlTypeName;

public class MultisetSqlType
extends AbstractSqlType {
    private final RelDataType elementType;

    public MultisetSqlType(RelDataType elementType, boolean isNullable) {
        super(SqlTypeName.MULTISET, isNullable, null);
        assert (elementType != null);
        this.elementType = elementType;
        this.computeDigest();
    }

    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        if (withDetail) {
            sb.append(this.elementType.getFullTypeString());
        } else {
            sb.append(((Object)this.elementType).toString());
        }
        sb.append(" MULTISET");
    }

    public RelDataType getComponentType() {
        return this.elementType;
    }

    public RelDataTypeFamily getFamily() {
        return this;
    }
}

