/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeComparability;
import org.eigenbase.sql.SqlCallBinding;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperandCountRange;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.type.ComparableOperandTypeChecker;
import org.eigenbase.sql.type.CompositeOperandTypeChecker;
import org.eigenbase.sql.type.FamilyOperandTypeChecker;
import org.eigenbase.sql.type.LiteralOperandTypeChecker;
import org.eigenbase.sql.type.MultisetOperandTypeChecker;
import org.eigenbase.sql.type.SameOperandTypeChecker;
import org.eigenbase.sql.type.SetopOperandTypeChecker;
import org.eigenbase.sql.type.SqlOperandCountRanges;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlSingleOperandTypeChecker;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperandTypes {
    public static final SqlSingleOperandTypeChecker NILADIC = OperandTypes.family(new SqlTypeFamily[0]);
    public static final SqlOperandTypeChecker VARIADIC = OperandTypes.variadic(SqlOperandCountRanges.any());
    public static final SqlOperandTypeChecker ONE_OR_MORE = OperandTypes.variadic(SqlOperandCountRanges.from(1));
    public static final SqlSingleOperandTypeChecker BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker BOOLEAN_BOOLEAN = OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.BOOLEAN);
    public static final SqlSingleOperandTypeChecker NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker NUMERIC_NUMERIC = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker EXACT_NUMERIC_EXACT_NUMERIC = OperandTypes.family(SqlTypeFamily.EXACT_NUMERIC, SqlTypeFamily.EXACT_NUMERIC);
    public static final SqlSingleOperandTypeChecker BINARY = OperandTypes.family(SqlTypeFamily.BINARY);
    public static final SqlSingleOperandTypeChecker STRING = OperandTypes.family(SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final FamilyOperandTypeChecker STRING_STRING_STRING = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING);
    public static final SqlSingleOperandTypeChecker CHARACTER = OperandTypes.family(SqlTypeFamily.CHARACTER);
    public static final SqlSingleOperandTypeChecker DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL);
    public static final FamilyOperandTypeChecker INTERVAL_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker MULTISET = OperandTypes.family(SqlTypeFamily.MULTISET);
    public static final SqlSingleOperandTypeChecker ARRAY = OperandTypes.family(SqlTypeFamily.ARRAY);
    public static final SqlSingleOperandTypeChecker COLLECTION = OperandTypes.or(OperandTypes.family(SqlTypeFamily.MULTISET), OperandTypes.family(SqlTypeFamily.ARRAY));
    public static final SqlSingleOperandTypeChecker COLLECTION_OR_MAP = OperandTypes.or(OperandTypes.family(SqlTypeFamily.MULTISET), OperandTypes.family(SqlTypeFamily.ARRAY), OperandTypes.family(SqlTypeFamily.MAP));
    public static final SqlSingleOperandTypeChecker NULLABLE_LITERAL = new LiteralOperandTypeChecker(true);
    public static final SqlSingleOperandTypeChecker LITERAL = new LiteralOperandTypeChecker(false);
    public static final SqlSingleOperandTypeChecker POSITIVE_INTEGER_LITERAL = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.INTEGER)){

        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            if (!LITERAL.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            if (!super.checkSingleOperandType(callBinding, node, iFormalOperand, throwOnFailure)) {
                return false;
            }
            SqlLiteral arg = (SqlLiteral)node;
            int value = arg.intValue(true);
            if (value < 0) {
                if (throwOnFailure) {
                    throw callBinding.newError(Static.RESOURCE.argumentMustBePositiveInteger(callBinding.getOperator().getName()));
                }
                return false;
            }
            return true;
        }
    };
    public static final SqlSingleOperandTypeChecker SAME_SAME = new SameOperandTypeChecker(2);
    public static final SqlSingleOperandTypeChecker SAME_SAME_SAME = new SameOperandTypeChecker(3);
    public static final SqlOperandTypeChecker SAME_VARIADIC = new SameOperandTypeChecker(-1);
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED_COMPARABLE_ORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.ALL);
    public static final SqlOperandTypeChecker COMPARABLE_ORDERED = new ComparableOperandTypeChecker(1, RelDataTypeComparability.ALL);
    public static final SqlOperandTypeChecker COMPARABLE_UNORDERED_COMPARABLE_UNORDERED = new ComparableOperandTypeChecker(2, RelDataTypeComparability.UNORDERED);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME = OperandTypes.and(STRING_STRING, SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_SAME_SAME_SAME = OperandTypes.and(STRING_STRING_STRING, SAME_SAME_SAME);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker STRING_STRING_INTEGER_INTEGER = OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER);
    public static final SqlSingleOperandTypeChecker ANY = OperandTypes.family(SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker ANY_ANY = OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.ANY);
    public static final SqlSingleOperandTypeChecker INTERVAL_SAME_SAME = OperandTypes.and(INTERVAL_INTERVAL, SAME_SAME);
    public static final SqlSingleOperandTypeChecker NUMERIC_INTERVAL = OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker INTERVAL_NUMERIC = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.NUMERIC);
    public static final SqlSingleOperandTypeChecker DATETIME_INTERVAL = OperandTypes.family(SqlTypeFamily.DATETIME, SqlTypeFamily.DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker INTERVAL_DATETIME = OperandTypes.family(SqlTypeFamily.DATETIME_INTERVAL, SqlTypeFamily.DATETIME);
    public static final SqlSingleOperandTypeChecker INTERVALINTERVAL_INTERVALDATETIME = OperandTypes.or(INTERVAL_SAME_SAME, INTERVAL_DATETIME);
    public static final SqlSingleOperandTypeChecker PLUS_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_SAME_SAME, DATETIME_INTERVAL, INTERVAL_DATETIME);
    public static final SqlSingleOperandTypeChecker MULTIPLY_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_NUMERIC, NUMERIC_INTERVAL);
    public static final SqlSingleOperandTypeChecker DIVISION_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_NUMERIC);
    public static final SqlSingleOperandTypeChecker MINUS_OPERATOR = OperandTypes.or(NUMERIC_NUMERIC, INTERVAL_SAME_SAME, DATETIME_INTERVAL);
    public static final SqlSingleOperandTypeChecker MINUS_DATE_OPERATOR = new FamilyOperandTypeChecker((List)ImmutableList.of((Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.DATETIME_INTERVAL)){

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (!super.checkOperandTypes(callBinding, throwOnFailure)) {
                return false;
            }
            return SAME_SAME.checkOperandTypes(callBinding, throwOnFailure);
        }
    };
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_INTERVAL = OperandTypes.or(NUMERIC, INTERVAL);
    public static final SqlSingleOperandTypeChecker NUMERIC_OR_STRING = OperandTypes.or(NUMERIC, STRING);
    public static final SqlSingleOperandTypeChecker RECORD_COLLECTION = new SqlSingleOperandTypeChecker(){

        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            } else {
                SqlTypeName typeName = type.getFieldList().get(0).getType().getSqlTypeName();
                if (typeName != SqlTypeName.MULTISET && typeName != SqlTypeName.ARRAY) {
                    validationError = true;
                }
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return this.checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(0), 0, throwOnFailure);
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(1);
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return "UNNEST(<MULTISET>)";
        }
    };
    public static final SqlSingleOperandTypeChecker SCALAR_OR_RECORD_COLLECTION = OperandTypes.or(COLLECTION, RECORD_COLLECTION);
    public static final SqlOperandTypeChecker MULTISET_MULTISET = new MultisetOperandTypeChecker();
    public static final SqlOperandTypeChecker SET_OP = new SetopOperandTypeChecker();
    public static final SqlOperandTypeChecker RECORD_TO_SCALAR = new SqlSingleOperandTypeChecker(){

        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode node, int iFormalOperand, boolean throwOnFailure) {
            assert (0 == iFormalOperand);
            RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), node);
            boolean validationError = false;
            if (!type.isStruct()) {
                validationError = true;
            } else if (type.getFieldList().size() != 1) {
                validationError = true;
            }
            if (validationError && throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return !validationError;
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            return this.checkSingleOperandType(callBinding, (SqlNode)callBinding.getCall().operand(0), 0, throwOnFailure);
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of(1);
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return SqlUtil.getAliasedSignature(op, opName, ImmutableList.of((Object)"RECORDTYPE(SINGLE FIELD)"));
        }
    };

    private OperandTypes() {
    }

    public static FamilyOperandTypeChecker family(SqlTypeFamily ... families) {
        return new FamilyOperandTypeChecker((List<SqlTypeFamily>)ImmutableList.copyOf((Object[])families));
    }

    public static FamilyOperandTypeChecker family(List<SqlTypeFamily> families) {
        return new FamilyOperandTypeChecker(families);
    }

    public static SqlSingleOperandTypeChecker or(SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.OR, (ImmutableList<SqlSingleOperandTypeChecker>)ImmutableList.copyOf((Object[])rules));
    }

    public static SqlSingleOperandTypeChecker and(SqlSingleOperandTypeChecker ... rules) {
        return new CompositeOperandTypeChecker(CompositeOperandTypeChecker.Composition.AND, (ImmutableList<SqlSingleOperandTypeChecker>)ImmutableList.copyOf((Object[])rules));
    }

    private static SqlOperandTypeChecker variadic(final SqlOperandCountRange range) {
        return new SqlOperandTypeChecker(){

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                return range.isValidCount(callBinding.getOperandCount());
            }

            public SqlOperandCountRange getOperandCountRange() {
                return range;
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(...)";
            }
        };
    }
}

