/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.Stack;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.util.SqlShuttle;
import org.eigenbase.sql.validate.SqlValidatorScope;

public abstract class SqlScopedShuttle
extends SqlShuttle {
    private final Stack<SqlValidatorScope> scopes = new Stack();

    protected SqlScopedShuttle(SqlValidatorScope initialScope) {
        this.scopes.push(initialScope);
    }

    public final SqlNode visit(SqlCall call) {
        SqlValidatorScope oldScope = this.scopes.peek();
        SqlValidatorScope newScope = oldScope.getOperandScope(call);
        this.scopes.push(newScope);
        SqlNode result = this.visitScoped(call);
        this.scopes.pop();
        return result;
    }

    protected SqlNode visitScoped(SqlCall call) {
        return super.visit(call);
    }

    protected SqlValidatorScope getScope() {
        return this.scopes.peek();
    }
}

