/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import java.util.List;
import java.util.Map;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.resource.Resources;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDataTypeSpec;
import org.eigenbase.sql.SqlDelete;
import org.eigenbase.sql.SqlDynamicParam;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlInsert;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlMerge;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlUpdate;
import org.eigenbase.sql.SqlWindow;
import org.eigenbase.sql.SqlWith;
import org.eigenbase.sql.SqlWithItem;
import org.eigenbase.sql.validate.SelectScope;
import org.eigenbase.sql.validate.SqlConformance;
import org.eigenbase.sql.validate.SqlValidatorCatalogReader;
import org.eigenbase.sql.validate.SqlValidatorException;
import org.eigenbase.sql.validate.SqlValidatorNamespace;
import org.eigenbase.sql.validate.SqlValidatorScope;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SqlValidator {
    public static final boolean STRICT = Util.first(Boolean.getBoolean("calcite.strict.sql"), false);

    public SqlConformance getConformance();

    public SqlValidatorCatalogReader getCatalogReader();

    public SqlOperatorTable getOperatorTable();

    public SqlNode validate(SqlNode var1);

    public SqlNode validateParameterizedExpression(SqlNode var1, Map<String, RelDataType> var2);

    public void validateQuery(SqlNode var1, SqlValidatorScope var2);

    public RelDataType getValidatedNodeType(SqlNode var1);

    public RelDataType getValidatedNodeTypeIfKnown(SqlNode var1);

    public void validateIdentifier(SqlIdentifier var1, SqlValidatorScope var2);

    public void validateLiteral(SqlLiteral var1);

    public void validateIntervalQualifier(SqlIntervalQualifier var1);

    public void validateInsert(SqlInsert var1);

    public void validateUpdate(SqlUpdate var1);

    public void validateDelete(SqlDelete var1);

    public void validateMerge(SqlMerge var1);

    public void validateDataType(SqlDataTypeSpec var1);

    public void validateDynamicParam(SqlDynamicParam var1);

    public void validateWindow(SqlNode var1, SqlValidatorScope var2, SqlCall var3);

    public void validateCall(SqlCall var1, SqlValidatorScope var2);

    public void validateAggregateParams(SqlCall var1, SqlValidatorScope var2);

    public void validateColumnListParams(SqlFunction var1, List<RelDataType> var2, List<SqlNode> var3);

    public RelDataType deriveType(SqlValidatorScope var1, SqlNode var2);

    public EigenbaseContextException newValidationError(SqlNode var1, Resources.ExInst<SqlValidatorException> var2);

    public boolean isAggregate(SqlSelect var1);

    public boolean isAggregate(SqlNode var1);

    public SqlWindow resolveWindow(SqlNode var1, SqlValidatorScope var2, boolean var3);

    public SqlValidatorNamespace getNamespace(SqlNode var1);

    public String deriveAlias(SqlNode var1, int var2);

    public SqlNodeList expandStar(SqlNodeList var1, SqlSelect var2, boolean var3);

    public SqlValidatorScope getWhereScope(SqlSelect var1);

    public RelDataTypeFactory getTypeFactory();

    public void setValidatedNodeType(SqlNode var1, RelDataType var2);

    public void removeValidatedNodeType(SqlNode var1);

    public RelDataType getUnknownType();

    public SqlValidatorScope getSelectScope(SqlSelect var1);

    public SelectScope getRawSelectScope(SqlSelect var1);

    public SqlValidatorScope getFromScope(SqlSelect var1);

    public SqlValidatorScope getJoinScope(SqlNode var1);

    public SqlValidatorScope getGroupScope(SqlSelect var1);

    public SqlValidatorScope getHavingScope(SqlSelect var1);

    public SqlValidatorScope getOrderScope(SqlSelect var1);

    public void declareCursor(SqlSelect var1, SqlValidatorScope var2);

    public void pushFunctionCall();

    public void popFunctionCall();

    public String getParentCursor(String var1);

    public void setIdentifierExpansion(boolean var1);

    public void setColumnReferenceExpansion(boolean var1);

    public boolean getColumnReferenceExpansion();

    public boolean shouldExpandIdentifiers();

    public void setCallRewrite(boolean var1);

    public RelDataType deriveConstructorType(SqlValidatorScope var1, SqlCall var2, SqlFunction var3, SqlFunction var4, List<RelDataType> var5);

    public EigenbaseException handleUnresolvedFunction(SqlCall var1, SqlFunction var2, List<RelDataType> var3);

    public SqlNode expandOrderExpr(SqlSelect var1, SqlNode var2);

    public SqlNode expand(SqlNode var1, SqlValidatorScope var2);

    public boolean isSystemField(RelDataTypeField var1);

    public List<List<String>> getFieldOrigins(SqlNode var1);

    public RelDataType getParameterRowType(SqlNode var1);

    public SqlValidatorScope getOverScope(SqlNode var1);

    public void validateWith(SqlWith var1, SqlValidatorScope var2);

    public void validateWithItem(SqlWithItem var1);

    public SqlValidatorScope getWithScope(SqlNode var1);
}

