/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql2rel;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.Correlation;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelShuttleImpl;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.relopt.Context;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCostImpl;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepRelVertex;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexCorrelVariable;
import org.eigenbase.rex.RexFieldAccess;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.rex.RexVisitor;
import org.eigenbase.rex.RexVisitorImpl;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlCountAggFunction;
import org.eigenbase.sql.fun.SqlSingleValueAggFunction;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.Bug;
import org.eigenbase.util.Holder;
import org.eigenbase.util.Pair;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelDecorrelator
implements ReflectiveVisitor {
    private static final Logger SQL2REL_LOGGER = EigenbaseTrace.getSqlToRelTracer();
    private CorelMap cm;
    private final DecorrelateRelVisitor decorrelateVisitor;
    private final RexBuilder rexBuilder;
    private RelNode currentRel;
    private final Context context;
    private final Map<RelNode, RelNode> mapOldToNewRel = Maps.newHashMap();
    private final Map<RelNode, SortedMap<Correlation, Integer>> mapNewRelToMapCorVarToOutputPos = Maps.newHashMap();
    private final Map<RelNode, Map<Integer, Integer>> mapNewRelToMapOldToNewOutputPos = Maps.newHashMap();
    private final HashSet<CorrelatorRel> generatedCorRels = Sets.newHashSet();

    private RelDecorrelator(RexBuilder rexBuilder, CorelMap cm, Context context) {
        this.cm = cm;
        this.rexBuilder = rexBuilder;
        this.context = context;
        this.decorrelateVisitor = new DecorrelateRelVisitor();
    }

    public static RelNode decorrelateQuery(RelNode rootRel) {
        CorelMap corelMap = CorelMap.build(rootRel);
        if (!corelMap.hasCorrelation()) {
            return rootRel;
        }
        RelOptCluster cluster = rootRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDecorrelator decorrelator = new RelDecorrelator(rexBuilder, corelMap, cluster.getPlanner().getContext());
        RelNode newRootRel = decorrelator.removeCorrelationViaRule(rootRel);
        if (SQL2REL_LOGGER.isLoggable(Level.FINE)) {
            SQL2REL_LOGGER.fine(RelOptUtil.dumpPlan("Plan after removing CorrelatorRel", newRootRel, false, SqlExplainLevel.EXPPLAN_ATTRIBUTES));
        }
        if (!decorrelator.cm.mapCorVarToCorRel.isEmpty()) {
            newRootRel = decorrelator.decorrelate(newRootRel);
        }
        return newRootRel;
    }

    private void setCurrent(RelNode root, CorrelatorRel corRel) {
        this.currentRel = corRel;
        if (corRel != null) {
            this.cm = CorelMap.build(Util.first(root, corRel));
        }
    }

    private RelNode decorrelate(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new AdjustProjectForCountAggregateRule(false)).addRuleInstance(new AdjustProjectForCountAggregateRule(true)).addRuleInstance(PushFilterPastJoinRule.FILTER_ON_JOIN).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        root = planner.findBestExp();
        this.mapOldToNewRel.clear();
        this.mapNewRelToMapCorVarToOutputPos.clear();
        this.mapNewRelToMapOldToNewOutputPos.clear();
        this.decorrelateVisitor.visit(root, 0, null);
        if (this.mapOldToNewRel.containsKey(root)) {
            return this.mapOldToNewRel.get(root);
        }
        return root;
    }

    private Function2<RelNode, RelNode, Void> createCopyHook() {
        return new Function2<RelNode, RelNode, Void>(){

            public Void apply(RelNode oldNode, RelNode newNode) {
                if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey((Object)oldNode)) {
                    RelDecorrelator.this.cm.mapRefRelToCorVar.putAll((Object)newNode, (Iterable)RelDecorrelator.this.cm.mapRefRelToCorVar.get((Object)oldNode));
                }
                if (oldNode instanceof CorrelatorRel && newNode instanceof CorrelatorRel) {
                    CorrelatorRel oldCor = (CorrelatorRel)oldNode;
                    for (Correlation c : oldCor.getCorrelations()) {
                        if (RelDecorrelator.this.cm.mapCorVarToCorRel.get(c) != oldNode) continue;
                        RelDecorrelator.this.cm.mapCorVarToCorRel.put(c, (CorrelatorRel)newNode);
                    }
                    if (RelDecorrelator.this.generatedCorRels.contains(oldNode)) {
                        RelDecorrelator.this.generatedCorRels.add((CorrelatorRel)newNode);
                    }
                }
                return null;
            }
        };
    }

    private HepPlanner createPlanner(HepProgram program) {
        return new HepPlanner(program, this.context, true, this.createCopyHook(), RelOptCostImpl.FACTORY);
    }

    public RelNode removeCorrelationViaRule(RelNode root) {
        HepProgram program = HepProgram.builder().addRuleInstance(new RemoveSingleAggregateRule()).addRuleInstance(new RemoveCorrelationForScalarProjectRule()).addRuleInstance(new RemoveCorrelationForScalarAggregateRule()).build();
        HepPlanner planner = this.createPlanner(program);
        planner.setRoot(root);
        RelNode newRootRel = planner.findBestExp();
        return newRootRel;
    }

    protected RexNode decorrelateExpr(RexNode exp) {
        DecorrelateRexShuttle shuttle = new DecorrelateRexShuttle();
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator);
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator);
        return exp.accept(shuttle);
    }

    protected RexNode removeCorrelationExpr(RexNode exp, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
        RemoveCorrelationRexShuttle shuttle = new RemoveCorrelationRexShuttle(this.rexBuilder, projectPulledAboveLeftCorrelator, isCount);
        return exp.accept(shuttle);
    }

    public void decorrelateRelGeneric(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        if (rel.getInputs().size() > 0) {
            List<RelNode> oldInputs = rel.getInputs();
            ArrayList newInputs = Lists.newArrayList();
            for (int i = 0; i < oldInputs.size(); ++i) {
                RelNode newInputRel = this.mapOldToNewRel.get(oldInputs.get(i));
                if (newInputRel == null || this.mapNewRelToMapCorVarToOutputPos.containsKey(newInputRel)) {
                    return;
                }
                newInputs.add(newInputRel);
                newRel.replaceInput(i, newInputRel);
            }
            if (!Util.equalShallow(oldInputs, newInputs)) {
                newRel = rel.copy(rel.getTraitSet(), newInputs);
            }
        }
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        for (int i = 0; i < rel.getRowType().getFieldCount(); ++i) {
            mapOldToNewOutputPos.put(i, i);
        }
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, mapOldToNewOutputPos);
    }

    public void decorrelateRel(SortRel rel) {
        assert (!this.cm.mapRefRelToCorVar.containsKey((Object)rel));
        RelNode oldChildRel = rel.getChild();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        Mappings.TargetMapping mapping = Mappings.target(childMapOldToNewOutputPos, oldChildRel.getRowType().getFieldCount(), newChildRel.getRowType().getFieldCount());
        RelCollation oldCollation = rel.getCollation();
        RelCollation newCollation = RexUtil.apply(mapping, oldCollation);
        SortRel newRel = new SortRel(rel.getCluster(), rel.getCluster().traitSetOf(Convention.NONE).plus(newCollation), newChildRel, newCollation, rel.offset, rel.fetch);
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, childMapOldToNewOutputPos);
    }

    public void decorrelateRel(AggregateRel rel) {
        int newPos;
        assert (!this.cm.mapRefRelToCorVar.containsKey((Object)rel));
        RelNode oldChildRel = rel.getChild();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        HashMap mapNewChildToProjOutputPos = Maps.newHashMap();
        int oldGroupKeyCount = rel.getGroupSet().cardinality();
        ArrayList projects = Lists.newArrayList();
        List<RelDataTypeField> newChildOutput = newChildRel.getRowType().getFieldList();
        for (newPos = 0; newPos < oldGroupKeyCount; ++newPos) {
            int newChildPos = childMapOldToNewOutputPos.get(newPos);
            projects.add(RexInputRef.of2(newChildPos, newChildOutput));
            mapNewChildToProjOutputPos.put(newChildPos, newPos);
        }
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        boolean produceCorVar = this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel);
        if (produceCorVar) {
            SortedMap<Correlation, Integer> childMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newChildRel);
            for (Correlation corVar : childMapCorVarToOutputPos.keySet()) {
                int newChildPos = (Integer)childMapCorVarToOutputPos.get(corVar);
                projects.add(RexInputRef.of2(newChildPos, newChildOutput));
                mapCorVarToOutputPos.put(corVar, newPos);
                mapNewChildToProjOutputPos.put(newChildPos, newPos);
                ++newPos;
            }
        }
        int newGroupKeyCount = newPos;
        for (int i = 0; i < newChildOutput.size(); ++i) {
            if (mapNewChildToProjOutputPos.containsKey(i)) continue;
            projects.add(RexInputRef.of2(i, newChildOutput));
            mapNewChildToProjOutputPos.put(i, newPos);
            ++newPos;
        }
        assert (newPos == newChildOutput.size());
        RelNode newProjectRel = RelOptUtil.createProject(newChildRel, projects, false);
        HashMap combinedMap = Maps.newHashMap();
        for (Integer oldChildPos : childMapOldToNewOutputPos.keySet()) {
            combinedMap.put(oldChildPos, mapNewChildToProjOutputPos.get(childMapOldToNewOutputPos.get(oldChildPos)));
        }
        this.mapOldToNewRel.put(oldChildRel, newProjectRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newProjectRel, combinedMap);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newProjectRel, mapCorVarToOutputPos);
        }
        ArrayList newAggCalls = Lists.newArrayList();
        List<AggregateCall> oldAggCalls = rel.getAggCallList();
        int oldChildOutputFieldCount = oldChildRel.getRowType().getFieldCount();
        int newChildOutputFieldCount = newProjectRel.getRowType().getFieldCount();
        int i = -1;
        for (AggregateCall oldAggCall : oldAggCalls) {
            ++i;
            List<Integer> oldAggArgs = oldAggCall.getArgList();
            ArrayList aggArgs = Lists.newArrayList();
            for (int oldPos : oldAggArgs) {
                aggArgs.add(combinedMap.get(oldPos));
            }
            newAggCalls.add(oldAggCall.adaptTo(newProjectRel, aggArgs, oldGroupKeyCount, newGroupKeyCount));
            combinedMap.put(oldChildOutputFieldCount + i, newChildOutputFieldCount + i);
        }
        AggregateRel newAggregateRel = new AggregateRel(rel.getCluster(), newProjectRel, BitSets.range(newGroupKeyCount), newAggCalls);
        this.mapOldToNewRel.put(rel, newAggregateRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newAggregateRel, combinedMap);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newAggregateRel, mapCorVarToOutputPos);
        }
    }

    public void decorrelateRel(ProjectRel rel) {
        int newPos;
        RelNode oldChildRel = rel.getChild();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        List<RexNode> oldProj = rel.getProjects();
        List<RelDataTypeField> relOutput = rel.getRowType().getFieldList();
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        boolean produceCorVar = this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel);
        ArrayList projects = Lists.newArrayList();
        if (this.cm.mapRefRelToCorVar.containsKey((Object)rel)) {
            this.decorrelateInputWithValueGenerator(rel);
            newChildRel = this.mapOldToNewRel.get(oldChildRel);
            produceCorVar = true;
        }
        for (newPos = 0; newPos < oldProj.size(); ++newPos) {
            projects.add(newPos, Pair.of(this.decorrelateExpr(oldProj.get(newPos)), relOutput.get(newPos).getName()));
            mapOldToNewOutputPos.put(newPos, newPos);
        }
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        if (produceCorVar) {
            SortedMap<Correlation, Integer> childMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newChildRel);
            List<RelDataTypeField> newChildOutput = newChildRel.getRowType().getFieldList();
            for (Correlation corVar : childMapCorVarToOutputPos.keySet()) {
                int corVarPos = (Integer)childMapCorVarToOutputPos.get(corVar);
                projects.add(RexInputRef.of2(corVarPos, newChildOutput));
                mapCorVarToOutputPos.put(corVar, newPos);
                ++newPos;
            }
        }
        RelNode newProjectRel = RelOptUtil.createProject(newChildRel, projects, false);
        this.mapOldToNewRel.put(rel, newProjectRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newProjectRel, mapOldToNewOutputPos);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newProjectRel, mapCorVarToOutputPos);
        }
    }

    private RelNode createValueGenerator(Iterable<Correlation> correlations, int valueGenFieldOffset, SortedMap<Correlation, Integer> mapCorVarToOutputPos) {
        List newLocalOutputPosList;
        RelNode newInputRel;
        RelNode oldInputRel;
        RelNode resultRel = null;
        HashMap mapNewInputRelToOutputPos = Maps.newHashMap();
        HashMap mapNewInputRelToNewOffset = Maps.newHashMap();
        for (Correlation corVar : correlations) {
            int oldCorVarOffset = corVar.getOffset();
            oldInputRel = ((CorrelatorRel)this.cm.mapCorVarToCorRel.get(corVar)).getInput(0);
            assert (oldInputRel != null);
            newInputRel = this.mapOldToNewRel.get(oldInputRel);
            assert (newInputRel != null);
            newLocalOutputPosList = !mapNewInputRelToOutputPos.containsKey(newInputRel) ? Lists.newArrayList() : (List)mapNewInputRelToOutputPos.get(newInputRel);
            Map<Integer, Integer> mapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newInputRel);
            assert (mapOldToNewOutputPos != null);
            int newCorVarOffset = mapOldToNewOutputPos.get(oldCorVarOffset);
            if (!newLocalOutputPosList.contains(newCorVarOffset)) {
                newLocalOutputPosList.add(newCorVarOffset);
            }
            mapNewInputRelToOutputPos.put(newInputRel, newLocalOutputPosList);
        }
        int offset = 0;
        HashSet joinedInputRelSet = Sets.newHashSet();
        for (Correlation corVar : correlations) {
            oldInputRel = ((CorrelatorRel)this.cm.mapCorVarToCorRel.get(corVar)).getInput(0);
            assert (oldInputRel != null);
            newInputRel = this.mapOldToNewRel.get(oldInputRel);
            assert (newInputRel != null);
            if (joinedInputRelSet.contains(newInputRel)) continue;
            RelNode projectRel = RelOptUtil.createProject(newInputRel, (List)mapNewInputRelToOutputPos.get(newInputRel));
            RelNode distinctRel = RelOptUtil.createDistinctRel(projectRel);
            RelOptCluster cluster = distinctRel.getCluster();
            joinedInputRelSet.add(newInputRel);
            mapNewInputRelToNewOffset.put(newInputRel, offset);
            offset += distinctRel.getRowType().getFieldCount();
            if (resultRel == null) {
                resultRel = distinctRel;
                continue;
            }
            resultRel = new JoinRel(cluster, resultRel, distinctRel, cluster.getRexBuilder().makeLiteral(true), JoinRelType.INNER, Collections.<String>emptySet());
        }
        for (Correlation corVar : correlations) {
            newInputRel = this.mapOldToNewRel.get(((CorrelatorRel)this.cm.mapCorVarToCorRel.get(corVar)).getInput(0));
            newLocalOutputPosList = (List)mapNewInputRelToOutputPos.get(newInputRel);
            Map<Integer, Integer> mapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newInputRel);
            assert (mapOldToNewOutputPos != null);
            int newLocalOutputPos = mapOldToNewOutputPos.get(corVar.getOffset());
            int newOutputPos = newLocalOutputPosList.indexOf(newLocalOutputPos) + (Integer)mapNewInputRelToNewOffset.get(newInputRel) + valueGenFieldOffset;
            if (mapCorVarToOutputPos.containsKey(corVar)) assert ((Integer)mapCorVarToOutputPos.get(corVar) == newOutputPos);
            mapCorVarToOutputPos.put(corVar, newOutputPos);
        }
        return resultRel;
    }

    private void decorrelateInputWithValueGenerator(RelNode rel) {
        assert (rel.getInputs().size() == 1);
        RelNode oldChildRel = rel.getInput(0);
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel)) {
            mapCorVarToOutputPos.putAll((Map)this.mapNewRelToMapCorVarToOutputPos.get(newChildRel));
        }
        Collection corVarList = this.cm.mapRefRelToCorVar.get((Object)rel);
        RelNode newLeftChildRel = newChildRel;
        int leftChildOutputCount = newLeftChildRel.getRowType().getFieldCount();
        RelNode valueGenRel = this.createValueGenerator(corVarList, leftChildOutputCount, mapCorVarToOutputPos);
        Set<String> variablesStopped = Collections.emptySet();
        JoinRel joinRel = new JoinRel(rel.getCluster(), newLeftChildRel, valueGenRel, this.rexBuilder.makeLiteral(true), JoinRelType.INNER, variablesStopped);
        this.mapOldToNewRel.put(oldChildRel, joinRel);
        this.mapNewRelToMapCorVarToOutputPos.put(joinRel, mapCorVarToOutputPos);
        this.mapNewRelToMapOldToNewOutputPos.put(joinRel, childMapOldToNewOutputPos);
    }

    public void decorrelateRel(FilterRel rel) {
        RelNode oldChildRel = rel.getChild();
        RelNode newChildRel = this.mapOldToNewRel.get(oldChildRel);
        if (newChildRel == null) {
            return;
        }
        Map<Integer, Integer> childMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newChildRel);
        assert (childMapOldToNewOutputPos != null);
        boolean produceCorVar = this.mapNewRelToMapCorVarToOutputPos.containsKey(newChildRel);
        if (this.cm.mapRefRelToCorVar.containsKey((Object)rel)) {
            this.decorrelateInputWithValueGenerator(rel);
            newChildRel = this.mapOldToNewRel.get(oldChildRel);
            produceCorVar = true;
        }
        RelNode newFilterRel = RelOptUtil.createFilter(newChildRel, this.decorrelateExpr(rel.getCondition()));
        this.mapOldToNewRel.put(rel, newFilterRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newFilterRel, childMapOldToNewOutputPos);
        if (produceCorVar) {
            this.mapNewRelToMapCorVarToOutputPos.put(newFilterRel, this.mapNewRelToMapCorVarToOutputPos.get(newChildRel));
        }
    }

    public void decorrelateRel(CorrelatorRel rel) {
        RelNode oldLeftRel = rel.getInputs().get(0);
        RelNode oldRightRel = rel.getInputs().get(1);
        RelNode newLeftRel = this.mapOldToNewRel.get(oldLeftRel);
        RelNode newRightRel = this.mapOldToNewRel.get(oldRightRel);
        if (newLeftRel == null || newRightRel == null) {
            return;
        }
        SortedMap<Correlation, Integer> rightChildMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newRightRel);
        if (rightChildMapCorVarToOutputPos == null) {
            return;
        }
        Map<Integer, Integer> leftChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newLeftRel);
        assert (leftChildMapOldToNewOutputPos != null);
        Map<Integer, Integer> rightChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newRightRel);
        assert (rightChildMapOldToNewOutputPos != null);
        SortedMap<Correlation, Integer> mapCorVarToOutputPos = rightChildMapCorVarToOutputPos;
        assert (rel.getCorrelations().size() <= rightChildMapCorVarToOutputPos.keySet().size());
        RexNode condition = rel.getCondition();
        List<RelDataTypeField> newLeftOutput = newLeftRel.getRowType().getFieldList();
        int newLeftFieldCount = newLeftOutput.size();
        List<RelDataTypeField> newRightOutput = newRightRel.getRowType().getFieldList();
        for (Correlation corVar : rel.getCorrelations()) {
            int newLeftPos = leftChildMapOldToNewOutputPos.get(corVar.getOffset());
            int newRightPos = (Integer)rightChildMapCorVarToOutputPos.get(corVar);
            RexNode equi = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, RexInputRef.of(newLeftPos, newLeftOutput), new RexInputRef(newLeftFieldCount + newRightPos, newRightOutput.get(newRightPos).getType()));
            condition = condition == this.rexBuilder.makeLiteral(true) ? equi : this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, condition, equi);
            mapCorVarToOutputPos.remove(corVar);
        }
        for (Correlation corVar : mapCorVarToOutputPos.keySet()) {
            int newPos = (Integer)mapCorVarToOutputPos.get(corVar) + newLeftFieldCount;
            mapCorVarToOutputPos.put(corVar, newPos);
        }
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newLeftRel)) {
            mapCorVarToOutputPos.putAll((Map<Correlation, Integer>)this.mapNewRelToMapCorVarToOutputPos.get(newLeftRel));
        }
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        int oldLeftFieldCount = oldLeftRel.getRowType().getFieldCount();
        int oldRightFieldCount = oldRightRel.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputPos.putAll(leftChildMapOldToNewOutputPos);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputPos.put(i + oldLeftFieldCount, rightChildMapOldToNewOutputPos.get(i) + newLeftFieldCount);
        }
        Set<String> variablesStopped = Collections.emptySet();
        JoinRel newRel = new JoinRel(rel.getCluster(), newLeftRel, newRightRel, condition, rel.getJoinType(), variablesStopped);
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, mapOldToNewOutputPos);
        if (!mapCorVarToOutputPos.isEmpty()) {
            this.mapNewRelToMapCorVarToOutputPos.put(newRel, mapCorVarToOutputPos);
        }
    }

    public void decorrelateRel(JoinRel rel) {
        RelNode oldLeftRel = rel.getInputs().get(0);
        RelNode oldRightRel = rel.getInputs().get(1);
        RelNode newLeftRel = this.mapOldToNewRel.get(oldLeftRel);
        RelNode newRightRel = this.mapOldToNewRel.get(oldRightRel);
        if (newLeftRel == null || newRightRel == null) {
            return;
        }
        Map<Integer, Integer> leftChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newLeftRel);
        assert (leftChildMapOldToNewOutputPos != null);
        Map<Integer, Integer> rightChildMapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newRightRel);
        assert (rightChildMapOldToNewOutputPos != null);
        TreeMap mapCorVarToOutputPos = Maps.newTreeMap();
        Set<String> variablesStopped = Collections.emptySet();
        JoinRel newRel = new JoinRel(rel.getCluster(), newLeftRel, newRightRel, this.decorrelateExpr(rel.getCondition()), rel.getJoinType(), variablesStopped);
        HashMap mapOldToNewOutputPos = Maps.newHashMap();
        int oldLeftFieldCount = oldLeftRel.getRowType().getFieldCount();
        int newLeftFieldCount = newLeftRel.getRowType().getFieldCount();
        int oldRightFieldCount = oldRightRel.getRowType().getFieldCount();
        assert (rel.getRowType().getFieldCount() == oldLeftFieldCount + oldRightFieldCount);
        mapOldToNewOutputPos.putAll(leftChildMapOldToNewOutputPos);
        for (int i = 0; i < oldRightFieldCount; ++i) {
            mapOldToNewOutputPos.put(i + oldLeftFieldCount, rightChildMapOldToNewOutputPos.get(i) + newLeftFieldCount);
        }
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newLeftRel)) {
            mapCorVarToOutputPos.putAll((Map)this.mapNewRelToMapCorVarToOutputPos.get(newLeftRel));
        }
        if (this.mapNewRelToMapCorVarToOutputPos.containsKey(newRightRel)) {
            SortedMap<Correlation, Integer> rightChildMapCorVarToOutputPos = this.mapNewRelToMapCorVarToOutputPos.get(newRightRel);
            for (Correlation corVar : rightChildMapCorVarToOutputPos.keySet()) {
                int oldRightPos = (Integer)rightChildMapCorVarToOutputPos.get(corVar);
                mapCorVarToOutputPos.put(corVar, oldRightPos + newLeftFieldCount);
            }
        }
        this.mapOldToNewRel.put(rel, newRel);
        this.mapNewRelToMapOldToNewOutputPos.put(newRel, mapOldToNewOutputPos);
        if (!mapCorVarToOutputPos.isEmpty()) {
            this.mapNewRelToMapCorVarToOutputPos.put(newRel, mapCorVarToOutputPos);
        }
    }

    private RexInputRef getNewForOldInputRef(RexInputRef oldInputRef) {
        int oldLocalOrdinal;
        assert (this.currentRel != null);
        int oldOrdinal = oldInputRef.getIndex();
        int newOrdinal = 0;
        List<RelNode> oldInputRels = this.currentRel.getInputs();
        RelNode oldInputRel = null;
        for (RelNode oldInputRel0 : oldInputRels) {
            RelDataType oldInputType = oldInputRel0.getRowType();
            int n = oldInputType.getFieldCount();
            if (oldOrdinal < n) {
                oldInputRel = oldInputRel0;
                break;
            }
            RelNode newInput = this.mapOldToNewRel.get(oldInputRel0);
            newOrdinal += newInput.getRowType().getFieldCount();
            oldOrdinal -= n;
        }
        assert (oldInputRel != null);
        RelNode newInputRel = this.mapOldToNewRel.get(oldInputRel);
        assert (newInputRel != null);
        int newLocalOrdinal = oldLocalOrdinal = oldOrdinal;
        Map<Integer, Integer> mapOldToNewOutputPos = this.mapNewRelToMapOldToNewOutputPos.get(newInputRel);
        if (mapOldToNewOutputPos != null) {
            newLocalOrdinal = mapOldToNewOutputPos.get(oldLocalOrdinal);
        }
        return new RexInputRef(newOrdinal += newLocalOrdinal, newInputRel.getRowType().getFieldList().get(newLocalOrdinal).getType());
    }

    private RelNode projectJoinOutputWithNullability(JoinRel joinRel, ProjectRel projRel, int nullIndicatorPos) {
        RelDataTypeFactory typeFactory = joinRel.getCluster().getTypeFactory();
        RelNode leftInputRel = joinRel.getLeft();
        JoinRelType joinType = joinRel.getJoinType();
        RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, typeFactory.createTypeWithNullability(joinRel.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
        ArrayList newProjExprs = Lists.newArrayList();
        List<RelDataTypeField> leftInputFields = leftInputRel.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjExprs.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : projRel.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, nullIndicator);
            newProjExprs.add(Pair.of(newProjExpr, pair.right));
        }
        RelNode newProjRel = RelOptUtil.createProject((RelNode)joinRel, newProjExprs, false);
        return newProjRel;
    }

    private RelNode aggregateCorrelatorOutput(CorrelatorRel corRel, ProjectRel projRel, Set<Integer> isCount) {
        RelNode leftInputRel = corRel.getLeft();
        JoinRelType joinType = corRel.getJoinType();
        ArrayList newProjects = Lists.newArrayList();
        List<RelDataTypeField> leftInputFields = leftInputRel.getRowType().getFieldList();
        for (int i = 0; i < leftInputFields.size(); ++i) {
            newProjects.add(RexInputRef.of2(i, leftInputFields));
        }
        boolean projectPulledAboveLeftCorrelator = joinType.generatesNullsOnRight();
        for (Pair<RexNode, String> pair : projRel.getNamedProjects()) {
            RexNode newProjExpr = this.removeCorrelationExpr((RexNode)pair.left, projectPulledAboveLeftCorrelator, isCount);
            newProjects.add(Pair.of(newProjExpr, pair.right));
        }
        return RelOptUtil.createProject((RelNode)corRel, newProjects, false);
    }

    private boolean checkCorVars(CorrelatorRel corRel, ProjectRel projRel, FilterRel filterRel, List<RexFieldAccess> correlatedJoinKeys) {
        if (filterRel != null) {
            assert (correlatedJoinKeys != null);
            HashSet corVarInFilter = Sets.newHashSet((Iterable)this.cm.mapRefRelToCorVar.get((Object)filterRel));
            for (RexFieldAccess correlatedJoinKey : correlatedJoinKeys) {
                corVarInFilter.remove(this.cm.mapFieldAccessToCorVar.get(correlatedJoinKey));
            }
            if (!corVarInFilter.isEmpty()) {
                return false;
            }
            corVarInFilter.addAll(this.cm.mapRefRelToCorVar.get((Object)filterRel));
            for (Correlation corVar : corVarInFilter) {
                if (this.cm.mapCorVarToCorRel.get(corVar) == corRel) continue;
                return false;
            }
        }
        if (projRel != null && this.cm.mapRefRelToCorVar.containsKey((Object)projRel)) {
            for (Correlation corVar : this.cm.mapRefRelToCorVar.get((Object)projRel)) {
                if (this.cm.mapCorVarToCorRel.get(corVar) == corRel) continue;
                return false;
            }
        }
        return true;
    }

    private void removeCorVarFromTree(CorrelatorRel corRel) {
        for (Correlation c : Lists.newArrayList(this.cm.mapCorVarToCorRel.keySet())) {
            if (this.cm.mapCorVarToCorRel.get(c) != corRel) continue;
            this.cm.mapCorVarToCorRel.remove(c);
        }
    }

    private RelNode createProjectWithAdditionalExprs(RelNode childRel, List<Pair<RexNode, String>> additionalExprs) {
        List<RelDataTypeField> fieldList = childRel.getRowType().getFieldList();
        ArrayList projects = Lists.newArrayList();
        for (Ord field : Ord.zip(fieldList)) {
            projects.add(Pair.of(this.rexBuilder.makeInputRef(((RelDataTypeField)field.e).getType(), field.i), ((RelDataTypeField)field.e).getName()));
        }
        projects.addAll(additionalExprs);
        return RelOptUtil.createProject(childRel, projects, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CorelMap {
        private final Multimap<RelNode, Correlation> mapRefRelToCorVar;
        private final SortedMap<Correlation, CorrelatorRel> mapCorVarToCorRel;
        private final Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar;

        private CorelMap(Multimap<RelNode, Correlation> mapRefRelToCorVar, SortedMap<Correlation, CorrelatorRel> mapCorVarToCorRel, Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar) {
            this.mapRefRelToCorVar = mapRefRelToCorVar;
            this.mapCorVarToCorRel = mapCorVarToCorRel;
            this.mapFieldAccessToCorVar = mapFieldAccessToCorVar;
        }

        public String toString() {
            return "mapRefRelToCorVar=" + this.mapRefRelToCorVar + "\nmapCorVarToCorRel=" + this.mapCorVarToCorRel + "\nmapFieldAccessToCorVar=" + this.mapFieldAccessToCorVar + "\n";
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof CorelMap && this.mapRefRelToCorVar.equals(((CorelMap)obj).mapRefRelToCorVar) && this.mapCorVarToCorRel.equals(((CorelMap)obj).mapCorVarToCorRel) && ((Object)this.mapFieldAccessToCorVar).equals(((CorelMap)obj).mapFieldAccessToCorVar);
        }

        public int hashCode() {
            return Util.hashV(this.mapRefRelToCorVar, this.mapCorVarToCorRel, this.mapFieldAccessToCorVar);
        }

        public static CorelMap of(SortedSetMultimap<RelNode, Correlation> mapRefRelToCorVar, SortedMap<Correlation, CorrelatorRel> mapCorVarToCorRel, Map<RexFieldAccess, Correlation> mapFieldAccessToCorVar) {
            return new CorelMap((Multimap<RelNode, Correlation>)mapRefRelToCorVar, mapCorVarToCorRel, mapFieldAccessToCorVar);
        }

        public static CorelMap build(RelNode rel) {
            final TreeMap<Correlation, CorrelatorRel> mapCorVarToCorRel = new TreeMap<Correlation, CorrelatorRel>();
            final SortedSetMultimap mapRefRelToCorVar = Multimaps.newSortedSetMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<TreeSet<Correlation>>(){

                public TreeSet<Correlation> get() {
                    Bug.upgrade("use MultimapBuilder when we're on Guava-16");
                    return Sets.newTreeSet();
                }
            });
            final HashMap<RexFieldAccess, Correlation> mapFieldAccessToCorVar = new HashMap<RexFieldAccess, Correlation>();
            final HashMap mapNameToCorVar = Maps.newHashMap();
            final Holder<Integer> offset = Holder.of(0);
            RelShuttleImpl shuttle = new RelShuttleImpl(){

                @Override
                public RelNode visit(JoinRel join) {
                    return this.visitJoin(join);
                }

                @Override
                protected RelNode visitChild(RelNode parent, int i, RelNode child) {
                    return super.visitChild(parent, i, CorelMap.stripHep(child));
                }

                @Override
                public RelNode visit(CorrelatorRel correlator) {
                    for (Correlation c : correlator.getCorrelations()) {
                        mapNameToCorVar.put("$cor" + c.getId(), c);
                        mapCorVarToCorRel.put(c, correlator);
                    }
                    return this.visitJoin(correlator);
                }

                private JoinRelBase visitJoin(JoinRelBase join) {
                    join.getCondition().accept(this.rexVisitor(join));
                    int x = (Integer)offset.get();
                    this.visitChild(join, 0, join.getLeft());
                    offset.set(x + join.getLeft().getRowType().getFieldCount());
                    this.visitChild(join, 0, join.getRight());
                    offset.set(x);
                    return join;
                }

                @Override
                public RelNode visit(FilterRel filter) {
                    filter.getCondition().accept(this.rexVisitor(filter));
                    return super.visit(filter);
                }

                @Override
                public RelNode visit(ProjectRel project) {
                    for (RexNode node : project.getProjects()) {
                        node.accept(this.rexVisitor(project));
                    }
                    return super.visit(project);
                }

                private RexVisitorImpl<Void> rexVisitor(final RelNode rel) {
                    return new RexVisitorImpl<Void>(true){

                        @Override
                        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
                            RexNode ref = fieldAccess.getReferenceExpr();
                            if (ref instanceof RexCorrelVariable) {
                                RexCorrelVariable var = (RexCorrelVariable)ref;
                                Correlation correlation = (Correlation)mapNameToCorVar.get(var.getName());
                                mapFieldAccessToCorVar.put(fieldAccess, correlation);
                                mapRefRelToCorVar.put((Object)rel, (Object)correlation);
                            }
                            return (Void)super.visitFieldAccess(fieldAccess);
                        }
                    };
                }
            };
            CorelMap.stripHep(rel).accept(shuttle);
            return new CorelMap((Multimap<RelNode, Correlation>)mapRefRelToCorVar, mapCorVarToCorRel, mapFieldAccessToCorVar);
        }

        private static RelNode stripHep(RelNode rel) {
            if (rel instanceof HepRelVertex) {
                HepRelVertex hepRelVertex = (HepRelVertex)rel;
                rel = hepRelVertex.getCurrentRel();
            }
            return rel;
        }

        public boolean hasCorrelation() {
            return !this.mapCorVarToCorRel.isEmpty();
        }
    }

    private final class AdjustProjectForCountAggregateRule
    extends RelOptRule {
        final boolean flavor;

        public AdjustProjectForCountAggregateRule(boolean flavor) {
            super(flavor ? AdjustProjectForCountAggregateRule.operand(CorrelatorRel.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(ProjectRel.class, AdjustProjectForCountAggregateRule.operand(AggregateRel.class, AdjustProjectForCountAggregateRule.any()), new RelOptRuleOperand[0])) : AdjustProjectForCountAggregateRule.operand(CorrelatorRel.class, AdjustProjectForCountAggregateRule.operand(RelNode.class, AdjustProjectForCountAggregateRule.any()), AdjustProjectForCountAggregateRule.operand(AggregateRel.class, AdjustProjectForCountAggregateRule.any())));
            this.flavor = flavor;
        }

        public void onMatch(RelOptRuleCall call) {
            AggregateRel aggRel;
            ProjectRel aggOutputProjRel;
            CorrelatorRel corRel = (CorrelatorRel)call.rel(0);
            Object leftInputRel = call.rel(1);
            if (this.flavor) {
                aggOutputProjRel = (ProjectRel)call.rel(2);
                aggRel = (AggregateRel)call.rel(3);
            } else {
                aggRel = (AggregateRel)call.rel(2);
                ArrayList projects = Lists.newArrayList();
                List<RelDataTypeField> fields = aggRel.getRowType().getFieldList();
                for (int i = 0; i < fields.size(); ++i) {
                    projects.add(RexInputRef.of2(projects.size(), fields));
                }
                aggOutputProjRel = (ProjectRel)RelOptUtil.createProject((RelNode)aggRel, projects, false);
            }
            this.onMatch2(call, corRel, (RelNode)leftInputRel, aggOutputProjRel, aggRel);
        }

        private void onMatch2(RelOptRuleCall call, CorrelatorRel corRel, RelNode leftInputRel, ProjectRel aggOutputProjRel, AggregateRel aggRel) {
            RelOptCluster cluster = corRel.getCluster();
            if (RelDecorrelator.this.generatedCorRels.contains(corRel)) {
                return;
            }
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), corRel);
            List<RexNode> aggOutputProjExprs = aggOutputProjRel.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = corRel.getJoinType();
            RexNode joinCond = corRel.getCondition();
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            List<AggregateCall> aggCalls = aggRel.getAggCallList();
            HashSet isCount = Sets.newHashSet();
            int i = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++i;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction)) continue;
                isCount.add(i);
            }
            CorrelatorRel newCorRel = new CorrelatorRel(cluster, leftInputRel, aggRel, corRel.getCorrelations(), corRel.getJoinType());
            RelDecorrelator.this.generatedCorRels.add(newCorRel);
            for (Correlation c : Lists.newArrayList(RelDecorrelator.this.cm.mapCorVarToCorRel.keySet())) {
                if (RelDecorrelator.this.cm.mapCorVarToCorRel.get(c) != corRel) continue;
                RelDecorrelator.this.cm.mapCorVarToCorRel.put(c, newCorRel);
            }
            RelNode newOutputRel = RelDecorrelator.this.aggregateCorrelatorOutput(newCorRel, aggOutputProjRel, isCount);
            call.transformTo(newOutputRel);
        }
    }

    private final class RemoveCorrelationForScalarAggregateRule
    extends RelOptRule {
        public RemoveCorrelationForScalarAggregateRule() {
            super(RemoveCorrelationForScalarAggregateRule.operand(CorrelatorRel.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), RemoveCorrelationForScalarAggregateRule.operand(ProjectRel.class, RemoveCorrelationForScalarAggregateRule.operand(AggregateRel.class, RemoveCorrelationForScalarAggregateRule.operand(ProjectRel.class, RemoveCorrelationForScalarAggregateRule.operand(RelNode.class, RemoveCorrelationForScalarAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        public void onMatch(RelOptRuleCall call) {
            CorrelatorRel corRel = (CorrelatorRel)call.rel(0);
            Object leftInputRel = call.rel(1);
            ProjectRel aggOutputProjRel = (ProjectRel)call.rel(2);
            AggregateRel aggRel = (AggregateRel)call.rel(3);
            ProjectRel aggInputProjRel = (ProjectRel)call.rel(4);
            Object rightInputRel = call.rel(5);
            RelOptCluster cluster = corRel.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), corRel);
            List<RexNode> aggOutputProjExprs = aggOutputProjRel.getProjects();
            if (aggOutputProjExprs.size() != 1) {
                return;
            }
            JoinRelType joinType = corRel.getJoinType();
            RexNode joinCond = corRel.getCondition();
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            List<RexNode> aggInputProjExprs = aggInputProjRel.getProjects();
            List<AggregateCall> aggCalls = aggRel.getAggCallList();
            HashSet isCountStar = Sets.newHashSet();
            int k = -1;
            for (AggregateCall aggCall : aggCalls) {
                ++k;
                if (!(aggCall.getAggregation() instanceof SqlCountAggFunction) || aggCall.getArgList().size() != 0) continue;
                isCountStar.add(k);
            }
            if (rightInputRel instanceof FilterRel && RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(rightInputRel)) {
                FilterRel filterRel = (FilterRel)rightInputRel;
                rightInputRel = filterRel.getChild();
                assert (rightInputRel instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(rightInputRel = ((HepRelVertex)rightInputRel).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList rightJoinKeys = Lists.newArrayList();
                ArrayList tmpCorrelatedJoinKeys = Lists.newArrayList();
                RelOptUtil.splitCorrelatedFilterCondition(filterRel, rightJoinKeys, tmpCorrelatedJoinKeys, true);
                ArrayList correlatedJoinKeys = Lists.newArrayList();
                ArrayList correlatedInputRefJoinKeys = Lists.newArrayList();
                for (RexNode joinKey : tmpCorrelatedJoinKeys) {
                    assert (joinKey instanceof RexFieldAccess);
                    correlatedJoinKeys.add((RexFieldAccess)joinKey);
                    RexNode correlatedInputRef = RelDecorrelator.this.removeCorrelationExpr(joinKey, false);
                    assert (correlatedInputRef instanceof RexInputRef);
                    correlatedInputRefJoinKeys.add((RexInputRef)correlatedInputRef);
                }
                if (correlatedInputRefJoinKeys.isEmpty()) {
                    return;
                }
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered(leftInputRel, correlatedInputRefJoinKeys)) {
                    SQL2REL_LOGGER.fine(((Object)correlatedJoinKeys).toString() + "are not unique keys for " + leftInputRel.toString());
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, aggInputProjRel, filterRel, correlatedJoinKeys)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filterRel.getCondition(), false);
            } else if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey((Object)aggInputProjRel)) {
                if (RelOptUtil.getVariablesUsed(rightInputRel).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, aggInputProjRel, null, null)) {
                    return;
                }
                int nFields = leftInputRel.getRowType().getFieldCount();
                BitSet allCols = BitSets.range(nFields);
                if (!RelMdUtil.areColumnsDefinitelyUnique(leftInputRel, allCols)) {
                    SQL2REL_LOGGER.fine("There are no unique keys for " + leftInputRel);
                    return;
                }
            } else {
                return;
            }
            RelDataType leftInputFieldType = leftInputRel.getRowType();
            int leftInputFieldCount = leftInputFieldType.getFieldCount();
            int joinOutputProjExprCount = leftInputFieldCount + aggInputProjExprs.size() + 1;
            rightInputRel = RelDecorrelator.this.createProjectWithAdditionalExprs(rightInputRel, (List)ImmutableList.of(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
            JoinRel joinRel = new JoinRel(cluster, (RelNode)leftInputRel, (RelNode)rightInputRel, joinCond, joinType, (Set<String>)ImmutableSet.of());
            int nullIndicatorPos = joinRel.getRowType().getFieldCount() - 1;
            RexInputRef nullIndicator = new RexInputRef(nullIndicatorPos, cluster.getTypeFactory().createTypeWithNullability(joinRel.getRowType().getFieldList().get(nullIndicatorPos).getType(), true));
            ArrayList joinOutputProjExprs = Lists.newArrayList();
            for (int i = 0; i < leftInputFieldCount; ++i) {
                joinOutputProjExprs.add(RelDecorrelator.this.rexBuilder.makeInputRef(leftInputFieldType.getFieldList().get(i).getType(), i));
            }
            for (RexNode aggInputProjExpr : aggInputProjExprs) {
                joinOutputProjExprs.add(RelDecorrelator.this.removeCorrelationExpr(aggInputProjExpr, joinType.generatesNullsOnRight(), nullIndicator));
            }
            joinOutputProjExprs.add(RelDecorrelator.this.rexBuilder.makeInputRef(joinRel, nullIndicatorPos));
            RelNode joinOutputProjRel = RelOptUtil.createProject((RelNode)joinRel, joinOutputProjExprs, null);
            nullIndicatorPos = joinOutputProjExprCount - 1;
            int groupCount = leftInputFieldCount;
            ArrayList newAggCalls = Lists.newArrayList();
            k = -1;
            for (AggregateCall aggCall : aggCalls) {
                List<Object> newAggArgs;
                List<Integer> aggArgs = aggCall.getArgList();
                if (isCountStar.contains(++k)) {
                    newAggArgs = Collections.singletonList(nullIndicatorPos);
                } else {
                    newAggArgs = Lists.newArrayList();
                    for (Integer aggArg : aggArgs) {
                        newAggArgs.add(aggArg + groupCount);
                    }
                }
                newAggCalls.add(aggCall.adaptTo(joinOutputProjRel, (List<Integer>)newAggArgs, aggRel.getGroupCount(), groupCount));
            }
            BitSet groupSet = BitSets.range(groupCount);
            AggregateRel newAggRel = new AggregateRel(cluster, joinOutputProjRel, groupSet, newAggCalls);
            ArrayList newAggOutputProjExprList = Lists.newArrayList();
            for (int i : BitSets.toIter(groupSet)) {
                newAggOutputProjExprList.add(RelDecorrelator.this.rexBuilder.makeInputRef(newAggRel, i));
            }
            RexNode newAggOutputProjExpr = RelDecorrelator.this.removeCorrelationExpr(aggOutputProjExprs.get(0), false);
            newAggOutputProjExprList.add(RelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(newAggOutputProjExpr.getType(), true), newAggOutputProjExpr));
            RelNode newAggOutputProjRel = RelOptUtil.createProject((RelNode)newAggRel, newAggOutputProjExprList, null);
            call.transformTo(newAggOutputProjRel);
            RelDecorrelator.this.removeCorVarFromTree(corRel);
        }
    }

    private final class RemoveCorrelationForScalarProjectRule
    extends RelOptRule {
        public RemoveCorrelationForScalarProjectRule() {
            super(RemoveCorrelationForScalarProjectRule.operand(CorrelatorRel.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), RemoveCorrelationForScalarProjectRule.operand(AggregateRel.class, RemoveCorrelationForScalarProjectRule.operand(ProjectRel.class, RemoveCorrelationForScalarProjectRule.operand(RelNode.class, RemoveCorrelationForScalarProjectRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0])));
        }

        public void onMatch(RelOptRuleCall call) {
            int nullIndicatorPos;
            CorrelatorRel corRel = (CorrelatorRel)call.rel(0);
            Object leftInputRel = call.rel(1);
            AggregateRel aggRel = (AggregateRel)call.rel(2);
            ProjectRel projRel = (ProjectRel)call.rel(3);
            Object rightInputRel = call.rel(4);
            RelOptCluster cluster = corRel.getCluster();
            RelDecorrelator.this.setCurrent(call.getPlanner().getRoot(), corRel);
            JoinRelType joinType = corRel.getJoinType();
            RexNode joinCond = corRel.getCondition();
            if (joinType != JoinRelType.LEFT || joinCond != RelDecorrelator.this.rexBuilder.makeLiteral(true)) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty() || aggRel.getAggCallList().size() != 1 || !(aggRel.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            if (projRel.getProjects().size() != 1) {
                return;
            }
            if (rightInputRel instanceof FilterRel && RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey(rightInputRel)) {
                FilterRel filterRel = (FilterRel)rightInputRel;
                rightInputRel = filterRel.getChild();
                assert (rightInputRel instanceof HepRelVertex);
                if (RelOptUtil.getVariablesUsed(rightInputRel = ((HepRelVertex)rightInputRel).getCurrentRel()).size() > 0) {
                    return;
                }
                ArrayList tmpRightJoinKeys = Lists.newArrayList();
                ArrayList correlatedJoinKeys = Lists.newArrayList();
                RelOptUtil.splitCorrelatedFilterCondition(filterRel, tmpRightJoinKeys, correlatedJoinKeys, false);
                ArrayList<RexInputRef> rightJoinKeys = new ArrayList<RexInputRef>();
                for (RexNode key : tmpRightJoinKeys) {
                    assert (key instanceof RexInputRef);
                    rightJoinKeys.add((RexInputRef)key);
                }
                if (rightJoinKeys.isEmpty()) {
                    return;
                }
                if (!RelMdUtil.areColumnsDefinitelyUniqueWhenNullsFiltered((RelNode)rightInputRel, rightJoinKeys)) {
                    SQL2REL_LOGGER.fine(((Object)rightJoinKeys).toString() + "are not unique keys for " + rightInputRel.toString());
                    return;
                }
                RexUtil.FieldAccessFinder visitor = new RexUtil.FieldAccessFinder();
                RexUtil.apply((RexVisitor<Void>)visitor, correlatedJoinKeys, null);
                List<RexFieldAccess> correlatedKeyList = visitor.getFieldAccessList();
                if (!RelDecorrelator.this.checkCorVars(corRel, projRel, filterRel, correlatedKeyList)) {
                    return;
                }
                joinCond = RelDecorrelator.this.removeCorrelationExpr(filterRel.getCondition(), false);
                nullIndicatorPos = leftInputRel.getRowType().getFieldCount() + ((RexInputRef)rightJoinKeys.get(0)).getIndex();
            } else if (RelDecorrelator.this.cm.mapRefRelToCorVar.containsKey((Object)projRel)) {
                if (RelOptUtil.getVariablesUsed(rightInputRel).size() > 0) {
                    return;
                }
                if (!RelDecorrelator.this.checkCorVars(corRel, projRel, null, null)) {
                    return;
                }
                rightInputRel = RelDecorrelator.this.createProjectWithAdditionalExprs(rightInputRel, (List)ImmutableList.of(Pair.of(RelDecorrelator.this.rexBuilder.makeLiteral(true), "nullIndicator")));
                rightInputRel = RelOptUtil.createSingleValueAggRel(cluster, rightInputRel);
                nullIndicatorPos = leftInputRel.getRowType().getFieldCount() + rightInputRel.getRowType().getFieldCount() - 1;
            } else {
                return;
            }
            JoinRel joinRel = new JoinRel(corRel.getCluster(), (RelNode)leftInputRel, (RelNode)rightInputRel, joinCond, joinType, (Set<String>)ImmutableSet.of());
            RelNode newProjRel = RelDecorrelator.this.projectJoinOutputWithNullability(joinRel, projRel, nullIndicatorPos);
            call.transformTo(newProjRel);
            RelDecorrelator.this.removeCorVarFromTree(corRel);
        }
    }

    private final class RemoveSingleAggregateRule
    extends RelOptRule {
        public RemoveSingleAggregateRule() {
            super(RemoveSingleAggregateRule.operand(AggregateRel.class, RemoveSingleAggregateRule.operand(ProjectRel.class, RemoveSingleAggregateRule.operand(AggregateRel.class, RemoveSingleAggregateRule.any()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            AggregateRel singleAggRel = (AggregateRel)call.rel(0);
            ProjectRel projRel = (ProjectRel)call.rel(1);
            AggregateRel aggRel = (AggregateRel)call.rel(2);
            if (!singleAggRel.getGroupSet().isEmpty() || singleAggRel.getAggCallList().size() != 1 || !(singleAggRel.getAggCallList().get(0).getAggregation() instanceof SqlSingleValueAggFunction)) {
                return;
            }
            List<RexNode> projExprs = projRel.getProjects();
            if (projExprs.size() != 1) {
                return;
            }
            if (!aggRel.getGroupSet().isEmpty()) {
                return;
            }
            RelOptCluster cluster = projRel.getCluster();
            RelNode newProjRel = RelOptUtil.createProject((RelNode)aggRel, (List<? extends RexNode>)ImmutableList.of((Object)RelDecorrelator.this.rexBuilder.makeCast(cluster.getTypeFactory().createTypeWithNullability(projExprs.get(0).getType(), true), projExprs.get(0))), null);
            call.transformTo(newProjRel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveCorrelationRexShuttle
    extends RexShuttle {
        RexBuilder rexBuilder;
        RelDataTypeFactory typeFactory;
        boolean projectPulledAboveLeftCorrelator;
        RexInputRef nullIndicator;
        Set<Integer> isCount;

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, null, null);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, nullIndicator, null);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, Set<Integer> isCount) {
            this(rexBuilder, projectPulledAboveLeftCorrelator, null, isCount);
        }

        public RemoveCorrelationRexShuttle(RexBuilder rexBuilder, boolean projectPulledAboveLeftCorrelator, RexInputRef nullIndicator, Set<Integer> isCount) {
            this.projectPulledAboveLeftCorrelator = projectPulledAboveLeftCorrelator;
            this.nullIndicator = nullIndicator;
            this.isCount = isCount;
            this.rexBuilder = rexBuilder;
            this.typeFactory = rexBuilder.getTypeFactory();
        }

        private RexNode createCaseExpression(RexInputRef nullInputRef, RexLiteral lit, RexNode rexNode) {
            RexNode[] caseOperands = new RexNode[]{this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexInputRef(nullInputRef.getIndex(), this.typeFactory.createTypeWithNullability(nullInputRef.getType(), true))), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), lit), this.rexBuilder.makeCast(this.typeFactory.createTypeWithNullability(rexNode.getType(), true), rexNode)};
            return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, caseOperands);
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (RelDecorrelator.this.cm.mapFieldAccessToCorVar.containsKey(fieldAccess)) {
                Correlation corVar = (Correlation)RelDecorrelator.this.cm.mapFieldAccessToCorVar.get(fieldAccess);
                RexNode newRexNode = new RexInputRef(corVar.getOffset(), fieldAccess.getType());
                if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                    newRexNode = this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newRexNode);
                }
                return newRexNode;
            }
            return fieldAccess;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            if (RelDecorrelator.this.currentRel != null && RelDecorrelator.this.currentRel instanceof CorrelatorRel) {
                int leftInputFieldCount = ((CorrelatorRel)RelDecorrelator.this.currentRel).getLeft().getRowType().getFieldCount();
                RelDataType newType = inputRef.getType();
                if (this.projectPulledAboveLeftCorrelator) {
                    newType = this.typeFactory.createTypeWithNullability(newType, true);
                }
                int pos = inputRef.getIndex();
                RexInputRef newInputRef = new RexInputRef(leftInputFieldCount + pos, newType);
                if (this.isCount != null && this.isCount.contains(pos)) {
                    return this.createCaseExpression(newInputRef, this.rexBuilder.makeExactLiteral(BigDecimal.ZERO), newInputRef);
                }
                return newInputRef;
            }
            return inputRef;
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            if (!RexUtil.isNull(literal) && this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), literal);
            }
            return literal;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode newCall;
            boolean[] update = new boolean[]{false};
            List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
            if (update[0]) {
                SqlFunction function;
                SqlOperator operator = call.getOperator();
                boolean isSpecialCast = false;
                if (operator instanceof SqlFunction && (function = (SqlFunction)operator).getKind() == SqlKind.CAST && call.operands.size() < 2) {
                    isSpecialCast = true;
                }
                RelDataType newType = !isSpecialCast ? this.rexBuilder.deriveReturnType(operator, clonedOperands) : call.getType();
                newCall = this.rexBuilder.makeCall(newType, operator, clonedOperands);
            } else {
                newCall = call;
            }
            if (this.projectPulledAboveLeftCorrelator && this.nullIndicator != null) {
                return this.createCaseExpression(this.nullIndicator, this.rexBuilder.constantNull(), newCall);
            }
            return newCall;
        }
    }

    private class DecorrelateRexShuttle
    extends RexShuttle {
        private DecorrelateRexShuttle() {
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            int newInputRelOutputOffset = 0;
            List<RelNode> inputs = RelDecorrelator.this.currentRel.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                RelNode oldInputRel = inputs.get(i);
                RelNode newInputRel = (RelNode)RelDecorrelator.this.mapOldToNewRel.get(oldInputRel);
                if (newInputRel != null && RelDecorrelator.this.mapNewRelToMapCorVarToOutputPos.containsKey(newInputRel)) {
                    Integer newInputPos;
                    Correlation corVar;
                    SortedMap childMapCorVarToOutputPos = (SortedMap)RelDecorrelator.this.mapNewRelToMapCorVarToOutputPos.get(newInputRel);
                    if (childMapCorVarToOutputPos != null && (corVar = (Correlation)RelDecorrelator.this.cm.mapFieldAccessToCorVar.get(fieldAccess)) != null && (newInputPos = (Integer)childMapCorVarToOutputPos.get(corVar)) != null) {
                        newInputPos = newInputPos + newInputRelOutputOffset;
                        RexInputRef newInput = new RexInputRef(newInputPos, fieldAccess.getType());
                        return newInput;
                    }
                    newInputRelOutputOffset += newInputRel.getRowType().getFieldCount();
                    continue;
                }
                newInputRelOutputOffset += oldInputRel.getRowType().getFieldCount();
            }
            return fieldAccess;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RexInputRef newInputRef = RelDecorrelator.this.getNewForOldInputRef(inputRef);
            return newInputRef;
        }
    }

    private class DecorrelateRelVisitor
    extends RelVisitor {
        private final ReflectiveVisitDispatcher<RelDecorrelator, RelNode> dispatcher = ReflectUtil.createDispatcher(RelDecorrelator.class, RelNode.class);

        private DecorrelateRelVisitor() {
        }

        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            RelDecorrelator.this.currentRel = p;
            String visitMethodName = "decorrelateRel";
            boolean found = this.dispatcher.invokeVisitor(RelDecorrelator.this, RelDecorrelator.this.currentRel, "decorrelateRel");
            RelDecorrelator.this.setCurrent(null, null);
            if (!found) {
                RelDecorrelator.this.decorrelateRelGeneric(p);
            }
        }
    }
}

