/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapParameterMetaData;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Member;
import org.olap4j.type.MemberType;
import org.olap4j.type.NumericType;
import org.olap4j.type.SetType;
import org.olap4j.type.StringType;
import org.olap4j.type.Type;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.Olap4jUtil;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.QueryResultWrapper;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public abstract class AbstractMDXDataFactory
extends AbstractDataFactory {
    private static final Log logger = LogFactory.getLog(AbstractMDXDataFactory.class);
    private static final String[] EMPTY_QUERYNAMES = new String[0];
    private OlapConnectionProvider connectionProvider;
    private transient OlapConnection connection;
    private String jdbcUserField;
    private String jdbcPasswordField;
    private String roleField;
    private boolean membersOnAxisSorted;

    public AbstractMDXDataFactory(OlapConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.connectionProvider = connectionProvider;
    }

    public void setConnectionProvider(OlapConnectionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        if (this.connection != null) {
            throw new IllegalStateException();
        }
        this.connectionProvider = connectionProvider;
    }

    public OlapConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public boolean isMembersOnAxisSorted() {
        return this.membersOnAxisSorted;
    }

    public void setMembersOnAxisSorted(boolean membersOnAxisSorted) {
        this.membersOnAxisSorted = membersOnAxisSorted;
    }

    public String getJdbcUserField() {
        return this.jdbcUserField;
    }

    public void setJdbcUserField(String jdbcUserField) {
        this.jdbcUserField = jdbcUserField;
    }

    public String getJdbcPasswordField() {
        return this.jdbcPasswordField;
    }

    public void setJdbcPasswordField(String jdbcPasswordField) {
        this.jdbcPasswordField = jdbcPasswordField;
    }

    public String getRoleField() {
        return this.roleField;
    }

    public void setRoleField(String roleField) {
        this.roleField = roleField;
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return true;
    }

    public String[] getQueryNames() {
        return EMPTY_QUERYNAMES;
    }

    protected PreparedOlapStatement getStatement(String query, DataRow parameter) throws ReportDataFactoryException, OlapException {
        if (this.connection == null) {
            try {
                this.connection = this.connectionProvider.createConnection(this.computeJdbcUser(parameter), this.computeJdbcPassword(parameter));
                this.connection.setLocale(this.getLocale());
                String role = this.computeRole(parameter);
                if (role != null) {
                    this.connection.setRoleName(role);
                }
            }
            catch (SQLException e) {
                throw new ReportDataFactoryException("Failed to obtain a connection", (Throwable)e);
            }
        }
        MDXCompiler compiler = new MDXCompiler(parameter, this.getLocale());
        String translatedQuery = compiler.translateAndLookup(query, parameter);
        return this.connection.prepareOlapStatement(translatedQuery);
    }

    private String computeJdbcUser(DataRow parameters) {
        Object field;
        if (this.jdbcUserField != null && (field = parameters.get(this.jdbcUserField)) != null) {
            return String.valueOf(field);
        }
        return null;
    }

    private String computeJdbcPassword(DataRow parameters) {
        Object field;
        if (this.jdbcPasswordField != null && (field = parameters.get(this.jdbcPasswordField)) != null) {
            return String.valueOf(field);
        }
        return null;
    }

    private String computeRole(DataRow parameters) throws ReportDataFactoryException {
        Object field;
        if (this.roleField != null && (field = parameters.get(this.roleField)) != null) {
            if (field instanceof Object[]) {
                Object[] roleArray = (Object[])field;
                StringBuilder buffer = new StringBuilder();
                for (Object o : roleArray) {
                    String role;
                    if (o == null || (role = this.filter(String.valueOf(o))) == null) continue;
                    buffer.append(this.quoteRole(role));
                }
                return buffer.toString();
            }
            if (field.getClass().isArray()) {
                StringBuilder buffer = new StringBuilder();
                int length = Array.getLength(field);
                for (int i = 0; i < length; ++i) {
                    String role;
                    Object o = Array.get(field, i);
                    if (o == null || (role = this.filter(String.valueOf(o))) == null) continue;
                    buffer.append(this.quoteRole(role));
                }
                return buffer.toString();
            }
            String role = this.filter(String.valueOf(field));
            if (role != null) {
                return role;
            }
        }
        return null;
    }

    private String quoteRole(String role) {
        if (role.indexOf(44) == -1) {
            return role;
        }
        StringBuilder b = new StringBuilder(role.length() + 5);
        char[] chars = role.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ',') {
                b.append(c);
            }
            b.append(c);
        }
        return b.toString();
    }

    protected QueryResultWrapper performQuery(String rawMdxQuery, DataRow parameters) throws ReportDataFactoryException, SQLException {
        PreparedOlapStatement statement = this.getStatement(rawMdxQuery, parameters);
        int queryTimeoutValue = this.calculateQueryTimeOut(parameters);
        if (queryTimeoutValue > 0) {
            statement.setQueryTimeout(queryTimeoutValue);
        }
        this.parametrizeQuery(parameters, statement);
        return new QueryResultWrapper(statement, statement.executeQuery());
    }

    private void parametrizeQuery(DataRow parameters, PreparedOlapStatement statement) throws SQLException, ReportDataFactoryException {
        OlapParameterMetaData olapParameterMetaData = statement.getParameterMetaData();
        int paramCount = olapParameterMetaData.getParameterCount();
        for (int i = 1; i <= paramCount; ++i) {
            String paramName = olapParameterMetaData.getParameterName(i);
            Object parameterValue = parameters.get(paramName);
            Type parameterType = olapParameterMetaData.getParameterOlapType(i);
            parameterValue = this.computeParameterValue(statement, parameterType, parameterValue);
            statement.setObject(i, parameterValue);
        }
    }

    private Object computeParameterValue(PreparedOlapStatement statement, Type parameterType, Object parameterValue) throws ReportDataFactoryException, SQLException {
        Cube cube;
        Hierarchy hierarchy;
        MemberType type;
        if (parameterValue == null) {
            return null;
        }
        if (parameterType instanceof StringType && !(parameterValue instanceof String)) {
            throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
        }
        if (parameterType instanceof NumericType && !(parameterValue instanceof Number)) {
            throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
        }
        if (parameterType instanceof MemberType) {
            if (parameterValue instanceof String) {
                type = (MemberType)parameterType;
                hierarchy = type.getHierarchy();
                cube = statement.getCube();
                parameterValue = this.findMember(hierarchy, cube, String.valueOf(parameterValue));
            } else if (!(parameterValue instanceof Member)) {
                throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
            }
        }
        if (parameterType instanceof SetType) {
            if (parameterValue instanceof String) {
                type = (SetType)parameterType;
                hierarchy = type.getHierarchy();
                cube = statement.getCube();
                String rawString = (String)((Object)parameterValue);
                String[] memberStr = rawString.replaceFirst("^ *\\{", "").replaceFirst("} *$", "").split(",");
                ArrayList<Member> list = new ArrayList<Member>(memberStr.length);
                for (int j = 0; j < memberStr.length; ++j) {
                    String str = memberStr[j];
                    Member member = this.findMember(hierarchy, cube, String.valueOf(str));
                    list.add(member);
                }
                parameterValue = list;
            } else if (!(parameterValue instanceof Member)) {
                throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
            }
        }
        return parameterValue;
    }

    public String[] getReferencedFields(String queryName, DataRow parameter) throws ReportDataFactoryException {
        try {
            if (this.connection == null) {
                this.connection = this.connectionProvider.createConnection(this.computeJdbcUser(parameter), this.computeJdbcPassword(parameter));
                this.connection.setLocale(this.getLocale());
                String role = this.computeRole(parameter);
                if (role != null) {
                    this.connection.setRoleName(role);
                }
            }
            MDXCompiler compiler = new MDXCompiler(parameter, this.getLocale());
            String value = this.computedQuery(queryName, parameter);
            String translatedQuery = compiler.translateAndLookup(value, parameter);
            LinkedHashSet<String> params = new LinkedHashSet<String>();
            params.addAll(compiler.getParameter());
            if (this.getRoleField() != null) {
                params.add(this.getRoleField());
            }
            if (this.getJdbcPasswordField() != null) {
                params.add(this.getJdbcPasswordField());
            }
            if (this.getJdbcUserField() != null) {
                params.add(this.getJdbcUserField());
            }
            PreparedOlapStatement statement = this.connection.prepareOlapStatement(translatedQuery);
            OlapParameterMetaData data = statement.getParameterMetaData();
            int count = data.getParameterCount();
            for (int i = 0; i < count; ++i) {
                String parameterName = data.getParameterName(i + 1);
                params.add(parameterName);
            }
            params.add("::org.pentaho.reporting::query-limit");
            return params.toArray(new String[params.size()]);
        }
        catch (Throwable e) {
            throw new ReportDataFactoryException("Failed to obtain a connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Member findMember(Hierarchy hierarchy, Cube cube, String parameter) throws ReportDataFactoryException, SQLException {
        Member memberById = null;
        Member memberByUniqueId = null;
        Configuration configuration = this.getConfiguration();
        boolean searchForNames = !"true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.NeedDimensionPrefix"));
        boolean missingMembersIsFatal = !"true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.IgnoreInvalidMembersDuringQuery"));
        try {
            Member directValue = this.lookupDirectly(hierarchy, cube, parameter, searchForNames);
            if (directValue != null) {
                return directValue;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        OlapStatement statement = this.connection.createStatement();
        try {
            CellSet result = statement.executeOlapQuery("SELECT " + hierarchy.getUniqueName() + ".AllMembers ON 0, {} ON 1 FROM " + cube.getUniqueName());
            try {
                List setAxises = result.getAxes();
                List positionList = ((CellSetAxis)setAxises.get(0)).getPositions();
                for (int i = 0; i < positionList.size(); ++i) {
                    Position position = (Position)positionList.get(i);
                    List memberList = position.getMembers();
                    for (int j = 0; j < memberList.size(); ++j) {
                        Member member = (Member)memberList.get(j);
                        if (parameter.equals(Olap4jUtil.getUniqueMemberName(member))) {
                            if (memberByUniqueId == null) {
                                memberByUniqueId = member;
                            } else {
                                logger.warn((Object)("Encountered a member with a duplicate unique key: " + member.getUniqueName()));
                            }
                        }
                        if (!searchForNames || !parameter.equals(member.getName())) continue;
                        if (memberById == null) {
                            memberById = member;
                            continue;
                        }
                        logger.warn((Object)("Encountered a member with a duplicate name: " + member.getUniqueName()));
                    }
                }
            }
            finally {
                result.close();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {}
        }
        if (memberByUniqueId != null) {
            return memberByUniqueId;
        }
        if (memberById != null) {
            return memberById;
        }
        if (missingMembersIsFatal) {
            throw new ReportDataFactoryException("No member matches parameter value '" + parameter + "'.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Member lookupDirectly(Hierarchy hierarchy, Cube cube, String parameter, boolean searchForNames) throws SQLException {
        Hierarchy memberHierarchy;
        Member memberById = null;
        Member memberByUniqueId = null;
        OlapStatement statement = this.connection.createStatement();
        try {
            CellSet result = statement.executeOlapQuery("SELECT STRTOMEMBER(" + AbstractMDXDataFactory.quote(parameter) + ") ON 0, {} ON 1 FROM " + cube.getUniqueName());
            try {
                List setAxises = result.getAxes();
                List positionList = ((CellSetAxis)setAxises.get(0)).getPositions();
                for (int i = 0; i < positionList.size(); ++i) {
                    Position position = (Position)positionList.get(i);
                    List memberList = position.getMembers();
                    for (int j = 0; j < memberList.size(); ++j) {
                        Member member = (Member)memberList.get(j);
                        if (parameter.startsWith("[")) {
                            if (memberByUniqueId == null) {
                                memberByUniqueId = member;
                            } else {
                                logger.warn((Object)("Encountered a member with a duplicate unique key: " + member.getUniqueName()));
                            }
                        }
                        if (!searchForNames || !parameter.equals(member.getName())) continue;
                        if (memberById == null) {
                            memberById = member;
                            continue;
                        }
                        logger.warn((Object)("Encountered a member with a duplicate name: " + member.getUniqueName()));
                    }
                }
            }
            finally {
                result.close();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException e) {}
        }
        if (memberByUniqueId != null) {
            memberHierarchy = memberByUniqueId.getHierarchy();
            if (hierarchy != memberHierarchy && !ObjectUtilities.equal((Object)hierarchy, (Object)memberHierarchy)) {
                logger.warn((Object)"Cannot match hierarchy of member found with the hierarchy specfied in the parameter: Unabe to guarantee that the correct member has been queried, returning null.");
                return null;
            }
            return memberByUniqueId;
        }
        if (memberById != null) {
            memberHierarchy = memberById.getHierarchy();
            if (hierarchy != memberHierarchy && !ObjectUtilities.equal((Object)hierarchy, (Object)memberHierarchy)) {
                logger.warn((Object)"Cannot match hierarchy of member found with the hierarchy specfied in the parameter: Unabe to guarantee that the correct member has been queried, returning null.");
                return null;
            }
            return memberById;
        }
        return null;
    }

    protected int extractQueryLimit(DataRow parameters) {
        int queryLimitValue;
        Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
        if (queryLimit instanceof Number) {
            Number i = (Number)queryLimit;
            queryLimitValue = Math.max(0, i.intValue());
        } else {
            queryLimitValue = 0;
        }
        return queryLimitValue;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    public AbstractMDXDataFactory clone() {
        AbstractMDXDataFactory dataFactory = (AbstractMDXDataFactory)super.clone();
        dataFactory.connection = null;
        return dataFactory;
    }

    protected static String quote(String original) {
        int length = original.length();
        StringBuilder b = new StringBuilder(length * 12 / 10);
        b.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = original.charAt(i);
            if (c == '\"') {
                b.append('\"');
                b.append('\"');
                continue;
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    private String filter(String role) throws ReportDataFactoryException {
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        if (!"true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.role-filter.enable"))) {
            return role;
        }
        Iterator staticDenyKeys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.role-filter.static.deny");
        while (staticDenyKeys.hasNext()) {
            String key = (String)staticDenyKeys.next();
            String value = configuration.getConfigProperty(key);
            if (!ObjectUtilities.equal((Object)value, (Object)role)) continue;
            return null;
        }
        Iterator regExpDenyKeys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.role-filter.reg-exp.deny");
        while (regExpDenyKeys.hasNext()) {
            String key = (String)regExpDenyKeys.next();
            String value = configuration.getConfigProperty(key);
            try {
                if (!role.matches(value)) continue;
                return null;
            }
            catch (PatternSyntaxException pe) {
                throw new ReportDataFactoryException("Unable to match reg-exp role filter:", (Throwable)pe);
            }
        }
        boolean hasAccept = false;
        Iterator staticAcceptKeys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.role-filter.static.accept");
        while (staticAcceptKeys.hasNext()) {
            hasAccept = true;
            String key = (String)staticAcceptKeys.next();
            String value = configuration.getConfigProperty(key);
            if (!ObjectUtilities.equal((Object)value, (Object)role)) continue;
            return role;
        }
        Iterator regExpAcceptKeys = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.role-filter.reg-exp.accept");
        while (regExpAcceptKeys.hasNext()) {
            hasAccept = true;
            String key = (String)regExpAcceptKeys.next();
            String value = configuration.getConfigProperty(key);
            try {
                if (!role.matches(value)) continue;
                return role;
            }
            catch (PatternSyntaxException pe) {
                throw new ReportDataFactoryException("Unable to match reg-exp role filter:", (Throwable)pe);
            }
        }
        if (!hasAccept) {
            return role;
        }
        return null;
    }

    protected String computedQuery(String queryName, DataRow parameters) throws ReportDataFactoryException {
        return queryName;
    }

    protected String translateQuery(String queryName) {
        return queryName;
    }

    public ArrayList<Object> getQueryHash(String queryRaw, DataRow parameter) throws ReportDataFactoryException {
        Object connection = this.getConnectionProvider().getConnectionHash();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((Object)((Object)this)).getClass().getName());
        list.add(this.translateQuery(queryRaw));
        list.add(connection);
        return list;
    }

    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        super.initialize(dataFactoryContext);
        this.membersOnAxisSorted = "true".equals(dataFactoryContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.MembersOnAxisSorted"));
    }

    protected static class MDXCompiler
    extends PropertyLookupParser {
        private DataRow parameters;
        private Locale locale;
        private HashSet<String> collectedLists = new HashSet();

        protected MDXCompiler(DataRow parameters, Locale locale) {
            this.parameters = parameters;
            this.locale = locale;
            this.setMarkerChar('$');
            this.setOpeningBraceChar('{');
            this.setClosingBraceChar('}');
        }

        protected String lookupVariable(String name) {
            CSVTokenizer tokenizer = new CSVTokenizer(name, false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String parameterName = tokenizer.nextToken();
            Object o = this.parameters.get(parameterName);
            this.collectedLists.add(parameterName);
            String subType = null;
            StringBuilder b = new StringBuilder(name.length() + 4);
            b.append('{');
            b.append("0");
            while (tokenizer.hasMoreTokens()) {
                b.append(',');
                String token = tokenizer.nextToken();
                b.append(token);
                if (subType != null) continue;
                subType = token;
            }
            b.append('}');
            String formatString = b.toString();
            if ("string".equals(subType)) {
                if (o == null) {
                    return "null";
                }
                return AbstractMDXDataFactory.quote(String.valueOf(o));
            }
            FastMessageFormat messageFormat = new FastMessageFormat(formatString, this.locale);
            return messageFormat.format((Object)new Object[]{o});
        }

        public Set<String> getParameter() {
            return Collections.unmodifiableSet((Set)this.collectedLists.clone());
        }
    }
}

